/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.RectF;
import androidx.collection.LongSparseArray;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.maps.IconManager;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Markers;
import com.mapbox.mapboxsdk.maps.NativeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class MarkerContainer
implements Markers {
    private final LongSparseArray<Annotation> annotations;
    private final IconManager iconManager;
    private final NativeMap nativeMapView;

    MarkerContainer(NativeMap nativeMap, LongSparseArray<Annotation> longSparseArray, IconManager iconManager) {
        this.nativeMapView = nativeMap;
        this.annotations = longSparseArray;
        this.iconManager = iconManager;
    }

    private void ensureIconLoaded(Marker marker, MapboxMap mapboxMap) {
        this.iconManager.ensureIconLoaded(marker, mapboxMap);
    }

    private List<Annotation> obtainAnnotations() {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            LongSparseArray<Annotation> longSparseArray = this.annotations;
            arrayList.add((Annotation)longSparseArray.get(longSparseArray.keyAt(i)));
        }
        return arrayList;
    }

    private Marker prepareMarker(BaseMarkerOptions object) {
        Object u = ((BaseMarkerOptions)object).getMarker();
        object = this.iconManager.loadIconForMarker((Marker)u);
        ((Marker)u).setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon((Icon)object));
        return u;
    }

    @Override
    public Marker addBy(BaseMarkerOptions object, MapboxMap mapboxMap) {
        object = this.prepareMarker((BaseMarkerOptions)object);
        NativeMap nativeMap = this.nativeMapView;
        long l = nativeMap != null ? nativeMap.addMarker((Marker)object) : 0L;
        ((Annotation)object).setMapboxMap(mapboxMap);
        ((Annotation)object).setId(l);
        this.annotations.put(l, object);
        return object;
    }

    @Override
    public List<Marker> addBy(List<? extends BaseMarkerOptions> object, MapboxMap mapboxMap) {
        int n = object.size();
        ArrayList<Marker> arrayList = new ArrayList<Marker>(n);
        if (this.nativeMapView != null && n > 0) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                arrayList.add(this.prepareMarker(object.get(n2)));
            }
            if (arrayList.size() > 0) {
                object = this.nativeMapView.addMarkers(arrayList);
                for (n2 = n3; n2 < ((Object)object).length; ++n2) {
                    Marker marker = (Marker)arrayList.get(n2);
                    marker.setMapboxMap(mapboxMap);
                    marker.setId((long)object[n2]);
                    this.annotations.put((long)object[n2], (Object)marker);
                }
            }
        }
        return arrayList;
    }

    @Override
    public List<Marker> obtainAll() {
        ArrayList<Marker> arrayList = new ArrayList<Marker>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Object object = this.annotations;
            if (!((object = (Annotation)object.get(object.keyAt(i))) instanceof Marker)) continue;
            arrayList.add((Marker)object);
        }
        return arrayList;
    }

    @Override
    public List<Marker> obtainAllIn(RectF object) {
        int n;
        object = this.nativeMapView.getDensityDependantRectangle((RectF)object);
        Object object2 = this.nativeMapView.queryPointAnnotations((RectF)object);
        object = new ArrayList(((long[])object2).length);
        int n2 = ((long[])object2).length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            object.add(object2[n]);
        }
        object2 = new ArrayList(((long[])object2).length);
        List<Annotation> list = this.obtainAnnotations();
        n2 = list.size();
        for (n = n3; n < n2; ++n) {
            Annotation annotation = list.get(n);
            if (!(annotation instanceof Marker) || !object.contains(annotation.getId())) continue;
            object2.add((Marker)annotation);
        }
        return new ArrayList<Marker>((Collection<Marker>)object2);
    }

    @Override
    public void reload() {
        this.iconManager.reloadIcons();
        int n = this.annotations.size();
        for (int i = 0; i < n; ++i) {
            Annotation annotation = (Annotation)this.annotations.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            this.nativeMapView.removeAnnotation(annotation.getId());
            marker.setId(this.nativeMapView.addMarker(marker));
        }
    }

    @Override
    public void update(Marker marker, MapboxMap longSparseArray) {
        this.ensureIconLoaded(marker, (MapboxMap)longSparseArray);
        this.nativeMapView.updateMarker(marker);
        longSparseArray = this.annotations;
        longSparseArray.setValueAt(longSparseArray.indexOfKey(marker.getId()), (Object)marker);
    }
}

