/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.geometry.VisibleRegion;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.NativeMap;
import java.util.ArrayList;

public class Projection {
    private final MapView mapView;
    private final NativeMap nativeMapView;

    Projection(NativeMap nativeMap, MapView mapView) {
        this.nativeMapView = nativeMap;
        this.mapView = mapView;
    }

    static double bearing(LatLng latLng, LatLng latLng2) {
        double d = Projection.degreesToRadians(latLng.getLongitude());
        double d2 = Projection.degreesToRadians(latLng2.getLongitude());
        double d3 = Projection.degreesToRadians(latLng.getLatitude());
        double d4 = Projection.degreesToRadians(latLng2.getLatitude());
        return Projection.radiansToDegrees(Math.atan2(Math.sin(d2 -= d) * Math.cos(d4), Math.cos(d3) * Math.sin(d4) - Math.sin(d3) * Math.cos(d4) * Math.cos(d2)));
    }

    static double degreesToRadians(double d) {
        return d % 360.0 * Math.PI / 180.0;
    }

    static double getLongitudeSpan(double d, double d2) {
        double d3 = Math.abs(d - d2);
        if (d > d2) {
            return d3;
        }
        return 360.0 - d3;
    }

    static double radiansToDegrees(double d) {
        return d % (Math.PI * 2) * 180.0 / Math.PI;
    }

    public double calculateZoom(float f) {
        return this.nativeMapView.getZoom() + Math.log(f) / Math.log(2.0);
    }

    public LatLng fromScreenLocation(PointF pointF) {
        return this.nativeMapView.latLngForPixel(pointF);
    }

    public void fromScreenLocations(double[] dArray, double[] dArray2) {
        this.nativeMapView.latLngsForPixels(dArray, dArray2);
    }

    int[] getContentPadding() {
        double[] dArray = this.nativeMapView.getCameraPosition().padding;
        return new int[]{(int)dArray[0], (int)dArray[1], (int)dArray[2], (int)dArray[3]};
    }

    float getHeight() {
        return this.mapView.getHeight();
    }

    public LatLng getLatLngForProjectedMeters(ProjectedMeters projectedMeters) {
        return this.nativeMapView.latLngForProjectedMeters(projectedMeters);
    }

    public double getMetersPerPixelAtLatitude(double d) {
        return this.nativeMapView.getMetersPerPixelAtLatitude(d);
    }

    public ProjectedMeters getProjectedMetersForLatLng(LatLng latLng) {
        return this.nativeMapView.projectedMetersForLatLng(latLng);
    }

    public void getVisibleCoordinateBounds(double[] dArray) {
        this.nativeMapView.getVisibleCoordinateBounds(dArray);
    }

    public VisibleRegion getVisibleRegion() {
        return this.getVisibleRegion(true);
    }

    public VisibleRegion getVisibleRegion(boolean bl) {
        double d;
        double d2;
        double d3;
        Object object;
        float f;
        float f2;
        float f3;
        float f4 = 0.0f;
        if (bl) {
            f3 = this.mapView.getWidth();
            f2 = this.mapView.getHeight();
            f = 0.0f;
        } else {
            object = this.getContentPadding();
            f4 = object[0];
            f3 = this.mapView.getWidth() - object[2];
            f = object[1];
            f2 = this.mapView.getHeight() - object[3];
        }
        LatLng latLng = this.fromScreenLocation(new PointF((f3 - f4) / 2.0f + f4, (f2 - f) / 2.0f + f));
        LatLng latLng2 = this.fromScreenLocation(new PointF(f4, f));
        LatLng latLng3 = this.fromScreenLocation(new PointF(f3, f));
        LatLng latLng4 = this.fromScreenLocation(new PointF(f3, f2));
        LatLng latLng5 = this.fromScreenLocation(new PointF(f4, f2));
        object = new ArrayList();
        object.add(latLng3);
        object.add(latLng4);
        object.add(latLng5);
        object.add(latLng2);
        object = object.iterator();
        double d4 = -90.0;
        double d5 = 90.0;
        double d6 = d3 = (d2 = (d = 0.0));
        double d7 = d3;
        d3 = d4;
        double d8 = d2;
        while (object.hasNext()) {
            double d9;
            double d10;
            double d11;
            LatLng latLng6 = (LatLng)object.next();
            if (Projection.bearing(latLng, latLng6) >= 0.0) {
                d11 = Projection.getLongitudeSpan(latLng6.getLongitude(), latLng.getLongitude());
                d4 = d;
                d2 = d8;
                d10 = d7;
                d9 = d6;
                if (d11 > d8) {
                    d10 = latLng6.getLongitude();
                    d2 = d11;
                    d4 = d;
                    d9 = d6;
                }
            } else {
                d11 = Projection.getLongitudeSpan(latLng.getLongitude(), latLng6.getLongitude());
                d4 = d;
                d2 = d8;
                d10 = d7;
                d9 = d6;
                if (d11 > d) {
                    d9 = latLng6.getLongitude();
                    d4 = d11;
                    d10 = d7;
                    d2 = d8;
                }
            }
            d6 = d3;
            if (d3 < latLng6.getLatitude()) {
                d6 = latLng6.getLatitude();
            }
            d11 = d5;
            if (d5 > latLng6.getLatitude()) {
                d11 = latLng6.getLatitude();
            }
            d = d4;
            d8 = d2;
            d3 = d6;
            d7 = d10;
            d5 = d11;
            d6 = d9;
        }
        if (d7 < d6) {
            return new VisibleRegion(latLng2, latLng3, latLng5, latLng4, LatLngBounds.from(d3, d7 + 360.0, d5, d6));
        }
        return new VisibleRegion(latLng2, latLng3, latLng5, latLng4, LatLngBounds.from(d3, d7, d5, d6));
    }

    float getWidth() {
        return this.mapView.getWidth();
    }

    @Deprecated
    public void invalidateContentPadding() {
    }

    void setContentPadding(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = nArray[i];
        }
        this.nativeMapView.setContentPadding(dArray);
    }

    public PointF toScreenLocation(LatLng latLng) {
        return this.nativeMapView.pixelForLatLng(latLng);
    }

    public void toScreenLocations(double[] dArray, double[] dArray2) {
        this.nativeMapView.pixelsForLatLngs(dArray, dArray2);
    }
}

