/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.RectF;
import androidx.collection.LongSparseArray;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.ShapeAnnotations;
import java.util.ArrayList;
import java.util.List;

class ShapeAnnotationContainer
implements ShapeAnnotations {
    private final LongSparseArray<Annotation> annotations;
    private final NativeMap nativeMapView;

    ShapeAnnotationContainer(NativeMap nativeMap, LongSparseArray<Annotation> longSparseArray) {
        this.nativeMapView = nativeMap;
        this.annotations = longSparseArray;
    }

    private List<Annotation> getAnnotationsFromIds(long[] lArray) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (long l : lArray) {
            Annotation annotation = (Annotation)this.annotations.get(l);
            if (annotation == null) continue;
            arrayList.add(annotation);
        }
        return arrayList;
    }

    @Override
    public List<Annotation> obtainAllIn(RectF rectF) {
        rectF = this.nativeMapView.getDensityDependantRectangle(rectF);
        return this.getAnnotationsFromIds(this.nativeMapView.queryShapeAnnotations(rectF));
    }
}

