/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.renderer;

import android.content.Context;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.GlyphsRasterizationMode;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.renderer.MapRendererRunnable;
import com.mapbox.mapboxsdk.maps.renderer.MapRendererScheduler;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public abstract class MapRenderer
implements MapRendererScheduler {
    private static final String TAG = "Mbgl-MapRenderer";
    private double expectedRenderTime = 0.0;
    private long nativePtr = 0L;
    private MapboxMap.OnFpsChangedListener onFpsChangedListener;
    private long timeElapsed;

    static {
        LibraryLoader.load();
    }

    public MapRenderer(Context context, GlyphsRasterizationMode glyphsRasterizationMode, String string2) {
        this.nativeInitialize(this, context.getResources().getDisplayMetrics().density, glyphsRasterizationMode.ordinal(), string2);
    }

    private native void nativeInitialize(MapRenderer var1, float var2, int var3, String var4);

    private native void nativeOnSurfaceChanged(int var1, int var2);

    private native void nativeOnSurfaceCreated();

    private native void nativeOnSurfaceDestroyed();

    private native void nativeRender();

    private void updateFps() {
        long l = System.nanoTime();
        double d = 1.0E9 / (double)(l - this.timeElapsed);
        this.onFpsChangedListener.onFpsChanged(d);
        this.timeElapsed = l;
    }

    protected native void finalize() throws Throwable;

    protected native void nativeReset();

    public void onDestroy() {
    }

    protected void onDrawFrame(GL10 gL10) {
        long l = System.nanoTime();
        try {
            this.nativeRender();
        }
        catch (Error error) {
            Logger.e(TAG, error.getMessage());
        }
        double d = System.nanoTime() - l;
        double d2 = this.expectedRenderTime;
        if (d < d2) {
            l = (long)((d2 - d) / 1000000.0);
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                Logger.e(TAG, interruptedException.getMessage());
            }
        }
        if (this.onFpsChangedListener != null) {
            this.updateFps();
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStart() {
    }

    public void onStop() {
    }

    protected void onSurfaceChanged(GL10 gL10, int n, int n2) {
        gL10.glViewport(0, 0, n, n2);
        this.nativeOnSurfaceChanged(n, n2);
    }

    protected void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        this.nativeOnSurfaceCreated();
    }

    protected void onSurfaceDestroyed() {
        this.nativeOnSurfaceDestroyed();
    }

    void queueEvent(MapRendererRunnable mapRendererRunnable) {
        this.queueEvent((Runnable)mapRendererRunnable);
    }

    public void setMaximumFps(int n) {
        if (n <= 0) {
            return;
        }
        this.expectedRenderTime = 1.0E9 / (double)n;
    }

    public void setOnFpsChangedListener(MapboxMap.OnFpsChangedListener onFpsChangedListener) {
        this.onFpsChangedListener = onFpsChangedListener;
    }
}

