/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.renderer.egl;

import android.opengl.GLSurfaceView;
import android.os.Build;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.utils.Compare;
import java.util.ArrayList;
import java.util.Collections;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;

public class EGLConfigChooser
implements GLSurfaceView.EGLConfigChooser {
    private static final int EGL_CONFORMANT = 12354;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private static final String TAG = "Mbgl-EGLConfigChooser";
    private boolean translucentSurface;

    public EGLConfigChooser() {
        this(false);
    }

    public EGLConfigChooser(boolean bl) {
        this.translucentSurface = bl;
    }

    private EGLConfig chooseBestMatchConfig(EGL10 object, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
        ArrayList<1Config> arrayList = new ArrayList<1Config>();
        int n = eGLConfigArray.length;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            Object object2 = object;
            Object object3 = this;
            if (n3 >= n) break;
            EGLConfig eGLConfig = eGLConfigArray[n3];
            if (eGLConfig != null) {
                int n4 = n2 + 1;
                int n5 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12327);
                int n6 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12354);
                int n7 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12320);
                int n8 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12324);
                int n9 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12323);
                int n10 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12322);
                int n11 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12321);
                object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12350);
                int n12 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12325);
                int n13 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12326);
                int n14 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12338);
                int n15 = object3.getConfigAttr((EGL10)object2, eGLDisplay, eGLConfig, 12337);
                n2 = n12 != 24 && n12 != 16 ? 0 : 1;
                int n16 = n13 == 8 ? 1 : 0;
                n14 = n14 == 0 ? 1 : 0;
                n15 = n15 == 0 ? 1 : 0;
                if ((n2 & n16 & n14 & n15) != 0) {
                    object2 = n7 == 16 && n8 == 5 && n9 == 6 && n10 == 5 && n11 == 0 ? BufferFormat.Format16Bit : (n7 == 32 && n8 == 8 && n9 == 8 && n10 == 8 && n11 == 0 ? BufferFormat.Format32BitNoAlpha : (n7 == 32 && n8 == 8 && n9 == 8 && n10 == 8 && n11 == 8 ? BufferFormat.Format32BitAlpha : (n7 == 24 && n8 == 8 && n9 == 8 && n10 == 8 && n11 == 0 ? BufferFormat.Format24Bit : BufferFormat.Unknown)));
                    object3 = n12 == 16 && n13 == 8 ? DepthStencilFormat.Format16Depth8Stencil : DepthStencilFormat.Format24Depth8Stencil;
                    boolean bl = (n6 & 4) != 4;
                    boolean bl2 = n5 != 12344;
                    if (object2 != BufferFormat.Unknown) {
                        arrayList.add(new 1Config((BufferFormat)((Object)object2), (DepthStencilFormat)((Object)object3), bl, bl2, n4, eGLConfig));
                    }
                }
                n2 = n4;
            }
            ++n3;
        }
        Collections.sort(arrayList);
        if (arrayList.size() == 0) {
            Logger.e(TAG, "No matching configurations after filtering");
            return null;
        }
        object = (1Config)arrayList.get(0);
        if (((1Config)object).isCaveat) {
            Logger.w(TAG, "Chosen config has a caveat.");
        }
        if (((1Config)object).isNotConformant) {
            Logger.w(TAG, "Chosen config is not conformant.");
        }
        return ((1Config)object).config;
    }

    private int getConfigAttr(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n) {
        int[] nArray = new int[1];
        if (!eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, nArray)) {
            Logger.e(TAG, String.format(MapboxConstants.MAPBOX_LOCALE, "eglGetConfigAttrib(%d) returned error %d", n, eGL10.eglGetError()));
        }
        return nArray[0];
    }

    private int[] getConfigAttributes() {
        boolean bl = this.inEmulator();
        int n = 0;
        bl = bl || this.inGenymotion();
        Logger.i(TAG, String.format("In emulator: %s", bl));
        if (this.translucentSurface) {
            n = 8;
        }
        int n2 = bl ? 12344 : 12354;
        int n3 = bl ? 12344 : 12351;
        return new int[]{12327, 12344, 12339, 4, 12320, 16, 12324, 5, 12323, 6, 12322, 5, 12321, n, 12325, 16, 12326, 8, n2, 4, n3, 12430, 12352, 4, 12344};
    }

    private int[] getNumberOfConfigurations(EGL10 eGL10, EGLDisplay eGLDisplay, int[] nArray) {
        int[] nArray2 = new int[1];
        if (!eGL10.eglChooseConfig(eGLDisplay, nArray, null, 0, nArray2)) {
            Logger.e(TAG, String.format(MapboxConstants.MAPBOX_LOCALE, "eglChooseConfig(NULL) returned error %d", eGL10.eglGetError()));
        }
        return nArray2;
    }

    private EGLConfig[] getPossibleConfigurations(EGL10 eGL10, EGLDisplay eGLDisplay, int[] nArray, int[] nArray2) {
        EGLConfig[] eGLConfigArray = new EGLConfig[nArray2[0]];
        if (!eGL10.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, nArray2[0], nArray2)) {
            Logger.e(TAG, String.format(MapboxConstants.MAPBOX_LOCALE, "eglChooseConfig() returned error %d", eGL10.eglGetError()));
        }
        return eGLConfigArray;
    }

    private boolean inEmulator() {
        boolean bl = Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT) || System.getProperty("ro.kernel.qemu") != null;
        return bl;
    }

    private boolean inGenymotion() {
        return Build.MANUFACTURER.contains("Genymotion");
    }

    public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
        int[] nArray = this.getConfigAttributes();
        int[] nArray2 = this.getNumberOfConfigurations(eGL10, eGLDisplay, nArray);
        if (nArray2[0] < 1) {
            Logger.e(TAG, "eglChooseConfig() returned no configs.");
        }
        if ((eGL10 = this.chooseBestMatchConfig(eGL10, eGLDisplay, this.getPossibleConfigurations(eGL10, eGLDisplay, nArray, nArray2))) == null) {
            Logger.e(TAG, "No config chosen");
        }
        return eGL10;
    }

    class 1Config
    implements Comparable<1Config> {
        private final BufferFormat bufferFormat;
        private final EGLConfig config;
        private final DepthStencilFormat depthStencilFormat;
        private final int index;
        private final boolean isCaveat;
        private final boolean isNotConformant;

        public 1Config(BufferFormat bufferFormat, DepthStencilFormat depthStencilFormat, boolean bl, boolean bl2, int n, EGLConfig eGLConfig) {
            this.bufferFormat = bufferFormat;
            this.depthStencilFormat = depthStencilFormat;
            this.isNotConformant = bl;
            this.isCaveat = bl2;
            this.index = n;
            this.config = eGLConfig;
        }

        @Override
        public int compareTo(1Config config) {
            int n = Compare.compare(this.bufferFormat.value, config.bufferFormat.value);
            if (n != 0) {
                return n;
            }
            n = Compare.compare(this.depthStencilFormat.value, config.depthStencilFormat.value);
            if (n != 0) {
                return n;
            }
            n = Compare.compare(this.isNotConformant, config.isNotConformant);
            if (n != 0) {
                return n;
            }
            n = Compare.compare(this.isCaveat, config.isCaveat);
            if (n != 0) {
                return n;
            }
            n = Compare.compare(this.index, config.index);
            if (n != 0) {
                return n;
            }
            return 0;
        }
    }

    static final class BufferFormat
    extends Enum<BufferFormat> {
        private static final /* synthetic */ BufferFormat[] $VALUES;
        public static final /* enum */ BufferFormat Format16Bit;
        public static final /* enum */ BufferFormat Format24Bit;
        public static final /* enum */ BufferFormat Format32BitAlpha;
        public static final /* enum */ BufferFormat Format32BitNoAlpha;
        public static final /* enum */ BufferFormat Unknown;
        int value;

        static {
            BufferFormat bufferFormat;
            BufferFormat bufferFormat2;
            BufferFormat bufferFormat3;
            BufferFormat bufferFormat4;
            BufferFormat bufferFormat5;
            Format16Bit = bufferFormat5 = new BufferFormat(3);
            Format32BitNoAlpha = bufferFormat4 = new BufferFormat(1);
            Format32BitAlpha = bufferFormat3 = new BufferFormat(2);
            Format24Bit = bufferFormat2 = new BufferFormat(0);
            Unknown = bufferFormat = new BufferFormat(4);
            $VALUES = new BufferFormat[]{bufferFormat5, bufferFormat4, bufferFormat3, bufferFormat2, bufferFormat};
        }

        private BufferFormat(int n2) {
            this.value = n2;
        }

        public static BufferFormat valueOf(String string2) {
            return Enum.valueOf(BufferFormat.class, string2);
        }

        public static BufferFormat[] values() {
            return (BufferFormat[])$VALUES.clone();
        }
    }

    static final class DepthStencilFormat
    extends Enum<DepthStencilFormat> {
        private static final /* synthetic */ DepthStencilFormat[] $VALUES;
        public static final /* enum */ DepthStencilFormat Format16Depth8Stencil;
        public static final /* enum */ DepthStencilFormat Format24Depth8Stencil;
        int value;

        static {
            DepthStencilFormat depthStencilFormat;
            DepthStencilFormat depthStencilFormat2;
            Format16Depth8Stencil = depthStencilFormat2 = new DepthStencilFormat(1);
            Format24Depth8Stencil = depthStencilFormat = new DepthStencilFormat(0);
            $VALUES = new DepthStencilFormat[]{depthStencilFormat2, depthStencilFormat};
        }

        private DepthStencilFormat(int n2) {
            this.value = n2;
        }

        public static DepthStencilFormat valueOf(String string2) {
            return Enum.valueOf(DepthStencilFormat.class, string2);
        }

        public static DepthStencilFormat[] values() {
            return (DepthStencilFormat[])$VALUES.clone();
        }
    }
}

