/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.renderer.glsurfaceview;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.mapbox.mapboxsdk.maps.renderer.egl.EGLLogWrapper;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class MapboxGLSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback2 {
    private static final String TAG = "GLSurfaceView";
    private static final GLThreadManager glThreadManager = new GLThreadManager();
    private boolean detached;
    private OnGLSurfaceViewDetachedListener detachedListener;
    private GLSurfaceView.EGLConfigChooser eglConfigChooser;
    private GLSurfaceView.EGLContextFactory eglContextFactory;
    private GLSurfaceView.EGLWindowSurfaceFactory eglWindowSurfaceFactory;
    private GLThread glThread;
    private boolean preserveEGLContextOnPause;
    private GLSurfaceView.Renderer renderer;
    private final WeakReference<MapboxGLSurfaceView> viewWeakReference = new WeakReference<MapboxGLSurfaceView>(this);

    public MapboxGLSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public MapboxGLSurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    static /* synthetic */ boolean access$600(MapboxGLSurfaceView mapboxGLSurfaceView) {
        return mapboxGLSurfaceView.preserveEGLContextOnPause;
    }

    static /* synthetic */ GLSurfaceView.Renderer access$700(MapboxGLSurfaceView mapboxGLSurfaceView) {
        return mapboxGLSurfaceView.renderer;
    }

    private void checkRenderThreadState() {
        if (this.glThread == null) {
            return;
        }
        throw new IllegalStateException("setRenderer has already been called for this instance.");
    }

    private void init() {
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    protected void finalize() throws Throwable {
        block4: {
            GLThread gLThread = this.glThread;
            if (gLThread == null) break block4;
            gLThread.requestExitAndWait();
        }
        return;
        finally {
            super.finalize();
        }
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.preserveEGLContextOnPause;
    }

    public int getRenderMode() {
        return this.glThread.getRenderMode();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.detached && this.renderer != null) {
            GLThread gLThread = this.glThread;
            int n = gLThread != null ? gLThread.getRenderMode() : 1;
            this.glThread = gLThread = new GLThread(this.viewWeakReference);
            if (n != 1) {
                gLThread.setRenderMode(n);
            }
            this.glThread.start();
        }
        this.detached = false;
    }

    protected void onDetachedFromWindow() {
        Object object = this.detachedListener;
        if (object != null) {
            object.onGLSurfaceViewDetached();
        }
        if ((object = this.glThread) != null) {
            ((GLThread)object).requestExitAndWait();
        }
        this.detached = true;
        super.onDetachedFromWindow();
    }

    public void onPause() {
        this.glThread.onPause();
    }

    public void onResume() {
        this.glThread.onResume();
    }

    public void queueEvent(Runnable runnable) {
        this.glThread.queueEvent(runnable);
    }

    public void requestRender() {
        this.glThread.requestRender();
    }

    public void setDetachedListener(OnGLSurfaceViewDetachedListener onGLSurfaceViewDetachedListener) {
        if (this.detachedListener == null) {
            this.detachedListener = onGLSurfaceViewDetachedListener;
            return;
        }
        throw new IllegalArgumentException("Detached from window listener has been already set.");
    }

    public void setEGLConfigChooser(GLSurfaceView.EGLConfigChooser eGLConfigChooser) {
        this.checkRenderThreadState();
        this.eglConfigChooser = eGLConfigChooser;
    }

    public void setEGLContextFactory(GLSurfaceView.EGLContextFactory eGLContextFactory) {
        this.checkRenderThreadState();
        this.eglContextFactory = eGLContextFactory;
    }

    public void setEGLWindowSurfaceFactory(GLSurfaceView.EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        this.checkRenderThreadState();
        this.eglWindowSurfaceFactory = eGLWindowSurfaceFactory;
    }

    public void setPreserveEGLContextOnPause(boolean bl) {
        this.preserveEGLContextOnPause = bl;
    }

    public void setRenderMode(int n) {
        this.glThread.setRenderMode(n);
    }

    public void setRenderer(GLSurfaceView.Renderer object) {
        this.checkRenderThreadState();
        if (this.eglConfigChooser != null) {
            if (this.eglContextFactory != null) {
                if (this.eglWindowSurfaceFactory != null) {
                    this.renderer = object;
                    object = new GLThread(this.viewWeakReference);
                    this.glThread = object;
                    ((Thread)object).start();
                    return;
                }
                throw new IllegalStateException("No eglWindowSurfaceFactory provided");
            }
            throw new IllegalStateException("No eglContextFactory provided");
        }
        throw new IllegalStateException("No eglConfigChooser provided");
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        this.glThread.onWindowResize(n2, n3);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.glThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.glThread.surfaceDestroyed();
    }

    @Deprecated
    public void surfaceRedrawNeeded(SurfaceHolder surfaceHolder) {
    }

    public void surfaceRedrawNeededAsync(SurfaceHolder object, Runnable runnable) {
        object = this.glThread;
        if (object != null) {
            ((GLThread)object).requestRenderAndNotify(runnable);
        }
    }

    private static class EglHelper {
        EGL10 mEgl;
        EGLConfig mEglConfig;
        EGLContext mEglContext;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        private WeakReference<MapboxGLSurfaceView> mGLSurfaceViewWeakRef;

        private EglHelper(WeakReference<MapboxGLSurfaceView> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        private void destroySurfaceImp() {
            Object object = this.mEglSurface;
            if (object != null && object != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                object = (MapboxGLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (object != null) {
                    ((MapboxGLSurfaceView)((Object)object)).eglWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        static String formatEglError(String string2, int n) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(" failed: ");
            stringBuilder.append(EGLLogWrapper.getErrorString(n));
            return stringBuilder.toString();
        }

        static void logEglErrorAsWarning(String string2, String string3, int n) {
            Log.w((String)string2, (String)EglHelper.formatEglError(string3, n));
        }

        GL createGL() {
            return this.mEglContext.getGL();
        }

        boolean createSurface() {
            if (this.mEgl == null) {
                Log.e((String)MapboxGLSurfaceView.TAG, (String)"egl not initialized");
                return false;
            }
            if (this.mEglDisplay == null) {
                Log.e((String)MapboxGLSurfaceView.TAG, (String)"eglDisplay not initialized");
                return false;
            }
            if (this.mEglConfig == null) {
                Log.e((String)MapboxGLSurfaceView.TAG, (String)"mEglConfig not initialized");
                return false;
            }
            this.destroySurfaceImp();
            MapboxGLSurfaceView mapboxGLSurfaceView = (MapboxGLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
            this.mEglSurface = mapboxGLSurfaceView != null ? mapboxGLSurfaceView.eglWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, (Object)mapboxGLSurfaceView.getHolder()) : null;
            mapboxGLSurfaceView = this.mEglSurface;
            if (mapboxGLSurfaceView != null && mapboxGLSurfaceView != EGL10.EGL_NO_SURFACE) {
                mapboxGLSurfaceView = this.mEgl;
                EGLDisplay eGLDisplay = this.mEglDisplay;
                EGLSurface eGLSurface = this.mEglSurface;
                if (!mapboxGLSurfaceView.eglMakeCurrent(eGLDisplay, eGLSurface, eGLSurface, this.mEglContext)) {
                    EglHelper.logEglErrorAsWarning(MapboxGLSurfaceView.TAG, "eglMakeCurrent", this.mEgl.eglGetError());
                    return false;
                }
                return true;
            }
            if (this.mEgl.eglGetError() == 12299) {
                Log.e((String)MapboxGLSurfaceView.TAG, (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }

        void destroySurface() {
            this.destroySurfaceImp();
        }

        public void finish() {
            Object object;
            if (this.mEglContext != null) {
                object = (MapboxGLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (object != null) {
                    ((MapboxGLSurfaceView)((Object)object)).eglContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if ((object = this.mEglDisplay) != null) {
                this.mEgl.eglTerminate(object);
                this.mEglDisplay = null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void start() {
            try {
                EGLDisplay eGLDisplay;
                EGL10 eGL10;
                this.mEgl = eGL10 = (EGL10)EGLContext.getEGL();
                this.mEglDisplay = eGLDisplay = eGL10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
                if (eGLDisplay == EGL10.EGL_NO_DISPLAY) {
                    Log.e((String)MapboxGLSurfaceView.TAG, (String)"eglGetDisplay failed");
                    return;
                }
                int[] nArray = new int[2];
                if (!this.mEgl.eglInitialize(this.mEglDisplay, nArray)) {
                    Log.e((String)MapboxGLSurfaceView.TAG, (String)"eglInitialize failed");
                    return;
                }
                MapboxGLSurfaceView mapboxGLSurfaceView = (MapboxGLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (mapboxGLSurfaceView == null) {
                    this.mEglConfig = null;
                    this.mEglContext = null;
                } else {
                    this.mEglConfig = mapboxGLSurfaceView.eglConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
                    this.mEglContext = mapboxGLSurfaceView.eglContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
                }
                EGLContext eGLContext = this.mEglContext;
                if (eGLContext == null || eGLContext == EGL10.EGL_NO_CONTEXT) {
                    this.mEglContext = null;
                    Log.e((String)MapboxGLSurfaceView.TAG, (String)"createContext failed");
                    return;
                }
            }
            catch (Exception exception) {
                Log.e((String)MapboxGLSurfaceView.TAG, (String)"createContext failed: ", (Throwable)exception);
            }
            this.mEglSurface = null;
        }

        public int swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }
    }

    static class GLThread
    extends Thread {
        private EglHelper eglHelper;
        private ArrayList<Runnable> eventQueue = new ArrayList();
        private boolean exited;
        private Runnable finishDrawingRunnable = null;
        private boolean finishedCreatingEglSurface;
        private boolean hasSurface;
        private boolean haveEglContext;
        private boolean haveEglSurface;
        private int height = 0;
        private WeakReference<MapboxGLSurfaceView> mGLSurfaceViewWeakRef;
        private boolean paused;
        private boolean renderComplete;
        private int renderMode = 1;
        private boolean requestPaused;
        private boolean requestRender = true;
        private boolean shouldExit;
        private boolean shouldReleaseEglContext;
        private boolean sizeChanged = true;
        private boolean surfaceIsBad;
        private boolean waitingForSurface;
        private boolean wantRenderNotification = false;
        private int width = 0;

        GLThread(WeakReference<MapboxGLSurfaceView> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        static /* synthetic */ boolean access$802(GLThread gLThread, boolean bl) {
            gLThread.exited = bl;
            return bl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void guardedRun() throws InterruptedException {
            this.eglHelper = new EglHelper(this.mGLSurfaceViewWeakRef);
            this.haveEglContext = false;
            this.haveEglSurface = false;
            this.wantRenderNotification = false;
            var3_6 /* !! */  = var2_3 = (var1_1 /* !! */  = null);
            var4_7 = 0;
            var5_8 = 0;
            var6_9 = 0;
            var7_10 = 0;
            var8_11 = 0;
            var9_12 = 0;
            var10_13 = 0;
            var11_14 = 0;
            var12_15 = 0;
            var13_16 = 0;
            var14_17 = var2_3;
            var2_3 = var1_1 /* !! */ ;
            block27: while (true) {
                try {
                    var15_18 = MapboxGLSurfaceView.access$400();
                    synchronized (var15_18) {
                        var16_19 = var6_9;
                        var17_20 = var5_8;
                    }
                }
                catch (Throwable var1_2) {
                    var2_3 = MapboxGLSurfaceView.access$400();
                    synchronized (var2_3) {
                        this.stopEglSurfaceLocked();
                        this.stopEglContextLocked();
                        throw var1_2;
                    }
                }
                {
                    while (true) {
                        block67: {
                            block66: {
                                block62: {
                                    block63: {
                                        block65: {
                                            block64: {
                                                if (this.shouldExit) {
                                                    // MONITOREXIT @DISABLED, blocks:[18, 58, 27, 28] lbl34 : MonitorExitStatement: MONITOREXIT : var15_18
                                                    var1_1 /* !! */  = MapboxGLSurfaceView.access$400();
                                                    synchronized (var1_1 /* !! */ ) {
                                                        this.stopEglSurfaceLocked();
                                                        this.stopEglContextLocked();
                                                        return;
                                                    }
                                                }
                                                if (this.eventQueue.isEmpty()) break block64;
                                                var18_21 /* !! */  = this.eventQueue.remove(0);
                                                var5_8 = var17_20;
                                                var6_9 = var16_19;
                                                var19_22 = var12_15;
                                                var20_23 = var13_16;
                                                break block65;
                                            }
                                            var21_24 = this.paused;
                                            var22_25 = this.requestPaused;
                                            if (var21_24 != var22_25) {
                                                this.paused = var22_25;
                                                MapboxGLSurfaceView.access$400().notifyAll();
                                            } else {
                                                var22_25 = false;
                                            }
                                            var5_8 = var16_19;
                                            if (this.shouldReleaseEglContext) {
                                                this.stopEglSurfaceLocked();
                                                this.stopEglContextLocked();
                                                this.shouldReleaseEglContext = false;
                                                var5_8 = 1;
                                            }
                                            var23_26 = var4_7;
                                            if (var4_7 != 0) {
                                                this.stopEglSurfaceLocked();
                                                this.stopEglContextLocked();
                                                var23_26 = 0;
                                            }
                                            if (var22_25 && this.haveEglSurface) {
                                                this.stopEglSurfaceLocked();
                                            }
                                            if (var22_25 && this.haveEglContext && (var16_19 = (var1_1 /* !! */  = (MapboxGLSurfaceView)this.mGLSurfaceViewWeakRef.get()) != null && MapboxGLSurfaceView.access$600((MapboxGLSurfaceView)var1_1 /* !! */ ) != false ? 1 : 0) == 0) {
                                                this.stopEglContextLocked();
                                            }
                                            if (!this.hasSurface && !this.waitingForSurface) {
                                                if (this.haveEglSurface) {
                                                    this.stopEglSurfaceLocked();
                                                }
                                                this.waitingForSurface = true;
                                                this.surfaceIsBad = false;
                                                MapboxGLSurfaceView.access$400().notifyAll();
                                            }
                                            if (this.hasSurface && this.waitingForSurface) {
                                                this.waitingForSurface = false;
                                                MapboxGLSurfaceView.access$400().notifyAll();
                                            }
                                            var24_27 = var17_20;
                                            if (var17_20 != 0) {
                                                this.wantRenderNotification = false;
                                                this.renderComplete = true;
                                                MapboxGLSurfaceView.access$400().notifyAll();
                                                var24_27 = 0;
                                            }
                                            var18_21 /* !! */  = this.finishDrawingRunnable;
                                            var1_1 /* !! */  = var2_3;
                                            if (var18_21 /* !! */  != null) {
                                                this.finishDrawingRunnable = null;
                                                var1_1 /* !! */  = var18_21 /* !! */ ;
                                            }
                                            if (!this.readyToDraw()) break block66;
                                            var22_25 = this.haveEglContext;
                                            var16_19 = var5_8;
                                            var17_20 = var7_10;
                                            if (!var22_25) {
                                                if (var5_8 != 0) {
                                                    var16_19 = 0;
                                                    var17_20 = var7_10;
                                                } else {
                                                    try {
                                                        this.eglHelper.start();
                                                        this.haveEglContext = true;
                                                    }
                                                    catch (RuntimeException var2_4) {
                                                        MapboxGLSurfaceView.access$400().releaseEglContextLocked(this);
                                                        // MONITOREXIT @DISABLED, blocks:[18, 25, 59, 27, 28, 61] lbl105 : MonitorExitStatement: MONITOREXIT : var15_18
                                                        var2_5 = MapboxGLSurfaceView.access$400();
                                                        synchronized (var2_5) {
                                                            this.stopEglSurfaceLocked();
                                                            this.stopEglContextLocked();
                                                            return;
                                                        }
                                                    }
                                                    MapboxGLSurfaceView.access$400().notifyAll();
                                                    var17_20 = 1;
                                                    var16_19 = var5_8;
                                                }
                                            }
                                            var4_7 = var8_11;
                                            var25_28 = var9_12;
                                            var5_8 = var10_13;
                                            if (this.haveEglContext) {
                                                var4_7 = var8_11;
                                                var25_28 = var9_12;
                                                var5_8 = var10_13;
                                                if (!this.haveEglSurface) {
                                                    this.haveEglSurface = true;
                                                    var4_7 = 1;
                                                    var25_28 = 1;
                                                    var5_8 = 1;
                                                }
                                            }
                                            var6_9 = var16_19;
                                            var2_3 = var1_1 /* !! */ ;
                                            var19_22 = var17_20;
                                            var26_29 = var4_7;
                                            var20_23 = var25_28;
                                            var27_30 = var5_8;
                                            if (!this.haveEglSurface) break block67;
                                            if (this.sizeChanged) {
                                                var12_15 = this.width;
                                                var13_16 = this.height;
                                                this.wantRenderNotification = true;
                                                this.sizeChanged = false;
                                                var26_29 = 1;
                                                var27_30 = 1;
                                            } else {
                                                var27_30 = var5_8;
                                                var26_29 = var4_7;
                                            }
                                            this.requestRender = false;
                                            MapboxGLSurfaceView.access$400().notifyAll();
                                            var4_7 = var23_26;
                                            var5_8 = var24_27;
                                            var6_9 = var16_19;
                                            var2_3 = var1_1 /* !! */ ;
                                            var7_10 = var17_20;
                                            var8_11 = var26_29;
                                            var9_12 = var25_28;
                                            var10_13 = var27_30;
                                            var19_22 = var12_15;
                                            var20_23 = var13_16;
                                            var18_21 /* !! */  = var3_6 /* !! */ ;
                                            if (this.wantRenderNotification) {
                                                var11_14 = 1;
                                                var18_21 /* !! */  = var3_6 /* !! */ ;
                                                var20_23 = var13_16;
                                                var19_22 = var12_15;
                                                var10_13 = var27_30;
                                                var9_12 = var25_28;
                                                var8_11 = var26_29;
                                                var7_10 = var17_20;
                                                var2_3 = var1_1 /* !! */ ;
                                                var6_9 = var16_19;
                                                var5_8 = var24_27;
                                                var4_7 = var23_26;
                                            }
                                        }
                                        // MONITOREXIT @DISABLED, blocks:[18, 27, 28] lbl170 : MonitorExitStatement: MONITOREXIT : var15_18
                                        if (var18_21 /* !! */  == null) ** GOTO lbl178
                                        {
                                            var18_21 /* !! */ .run();
                                            var18_21 /* !! */  = null;
lbl173:
                                            // 2 sources

                                            while (true) {
                                                var12_15 = var19_22;
                                                var13_16 = var20_23;
                                                var3_6 /* !! */  = var18_21 /* !! */ ;
                                                continue block27;
                                                break;
                                            }
lbl178:
                                            // 1 sources

                                            var16_19 = var8_11;
                                            if (var8_11 == 0) break block62;
                                            if (!this.eglHelper.createSurface()) break block63;
                                            var1_1 /* !! */  = MapboxGLSurfaceView.access$400();
                                            synchronized (var1_1 /* !! */ ) {
                                                this.finishedCreatingEglSurface = true;
                                                MapboxGLSurfaceView.access$400().notifyAll();
                                            }
                                        }
                                        var16_19 = 0;
                                        break block62;
                                    }
                                    var1_1 /* !! */  = MapboxGLSurfaceView.access$400();
                                    synchronized (var1_1 /* !! */ ) {
                                        this.finishedCreatingEglSurface = true;
                                        this.surfaceIsBad = true;
                                        MapboxGLSurfaceView.access$400().notifyAll();
                                    }
                                    ** continue;
                                }
                                var17_20 = var9_12;
                                if (var9_12 != 0) {
                                    var14_17 = (GL10)this.eglHelper.createGL();
                                    var17_20 = 0;
                                }
                                var9_12 = var7_10;
                                if (var7_10 != 0) {
                                    var1_1 /* !! */  = (MapboxGLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                                    if (var1_1 /* !! */  != null) {
                                        MapboxGLSurfaceView.access$700((MapboxGLSurfaceView)var1_1 /* !! */ ).onSurfaceCreated((GL10)var14_17, this.eglHelper.mEglConfig);
                                    }
                                    var9_12 = 0;
                                }
                                var25_28 = var10_13;
                                if (var10_13 != 0) {
                                    var1_1 /* !! */  = (MapboxGLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                                    if (var1_1 /* !! */  != null) {
                                        MapboxGLSurfaceView.access$700((MapboxGLSurfaceView)var1_1 /* !! */ ).onSurfaceChanged((GL10)var14_17, var19_22, var20_23);
                                    }
                                    var25_28 = 0;
                                }
                                var3_6 /* !! */  = (MapboxGLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                                var1_1 /* !! */  = var2_3;
                                if (var3_6 /* !! */  != null) {
                                    MapboxGLSurfaceView.access$700((MapboxGLSurfaceView)var3_6 /* !! */ ).onDrawFrame((GL10)var14_17);
                                    var1_1 /* !! */  = var2_3;
                                    if (var2_3 != null) {
                                        var2_3.run();
                                        var1_1 /* !! */  = null;
                                    }
                                }
                                if ((var10_13 = this.eglHelper.swap()) != 12288) {
                                    if (var10_13 != 12302) {
                                        EglHelper.logEglErrorAsWarning("GLSurfaceView", "eglSwapBuffers", var10_13);
                                        var2_3 = MapboxGLSurfaceView.access$400();
                                        synchronized (var2_3) {
                                            this.surfaceIsBad = true;
                                            MapboxGLSurfaceView.access$400().notifyAll();
                                        }
                                    } else {
                                        var4_7 = 1;
                                    }
                                }
                                var12_15 = var11_14;
                                if (var11_14 != 0) {
                                    var5_8 = 1;
                                    var12_15 = 0;
                                }
                                var2_3 = var1_1 /* !! */ ;
                                var7_10 = var9_12;
                                var8_11 = var16_19;
                                var9_12 = var17_20;
                                var10_13 = var25_28;
                                var11_14 = var12_15;
                                var12_15 = var19_22;
                                var13_16 = var20_23;
                                var3_6 /* !! */  = var18_21 /* !! */ ;
                                continue block27;
                            }
                            var6_9 = var5_8;
                            var2_3 = var1_1 /* !! */ ;
                            var19_22 = var7_10;
                            var26_29 = var8_11;
                            var20_23 = var9_12;
                            var27_30 = var10_13;
                            if (var1_1 /* !! */  != null) {
                                Log.w((String)"GLSurfaceView", (String)"Warning, !readyToDraw() but waiting for draw finished! Early reporting draw finished.");
                                var1_1 /* !! */ .run();
                                var2_3 = null;
                                var27_30 = var10_13;
                                var20_23 = var9_12;
                                var26_29 = var8_11;
                                var19_22 = var7_10;
                                var6_9 = var5_8;
                            }
                        }
                        MapboxGLSurfaceView.access$400().wait();
                        var4_7 = var23_26;
                        var17_20 = var24_27;
                        var16_19 = var6_9;
                        var7_10 = var19_22;
                        var8_11 = var26_29;
                        var9_12 = var20_23;
                        var10_13 = var27_30;
                    }
                }
                break;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean readyToDraw() {
            boolean bl = this.paused;
            boolean bl2 = true;
            if (bl) return false;
            if (!this.hasSurface) return false;
            if (this.surfaceIsBad) return false;
            if (this.width <= 0) return false;
            if (this.height <= 0) return false;
            bl = bl2;
            if (this.requestRender) return bl;
            if (this.renderMode != 1) return false;
            return bl2;
        }

        private void stopEglContextLocked() {
            if (this.haveEglContext) {
                this.eglHelper.finish();
                this.haveEglContext = false;
                glThreadManager.releaseEglContextLocked(this);
            }
        }

        private void stopEglSurfaceLocked() {
            if (this.haveEglSurface) {
                this.haveEglSurface = false;
                this.eglHelper.destroySurface();
            }
        }

        public boolean ableToDraw() {
            boolean bl = this.haveEglContext && this.haveEglSurface && this.readyToDraw();
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                return this.renderMode;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onPause() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.requestPaused = true;
                glThreadManager.notifyAll();
                while (!this.exited && !(bl = this.paused)) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onResume() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.requestPaused = false;
                this.requestRender = true;
                this.renderComplete = false;
                glThreadManager.notifyAll();
                while (!this.exited && this.paused && !(bl = this.renderComplete)) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onWindowResize(int n, int n2) {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.width = n;
                this.height = n2;
                this.sizeChanged = true;
                this.requestRender = true;
                this.renderComplete = false;
                if (Thread.currentThread() == this) {
                    return;
                }
                glThreadManager.notifyAll();
                while (!this.exited && !this.paused && !this.renderComplete && (bl = this.ableToDraw())) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void queueEvent(Runnable runnable) {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.eventQueue.add(runnable);
                glThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.shouldExit = true;
                glThreadManager.notifyAll();
                boolean bl;
                while (!(bl = this.exited)) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                return;
            }
        }

        public void requestReleaseEglContextLocked() {
            this.shouldReleaseEglContext = true;
            glThreadManager.notifyAll();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.requestRender = true;
                glThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestRenderAndNotify(Runnable runnable) {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                if (Thread.currentThread() == this) {
                    return;
                }
                this.wantRenderNotification = true;
                this.requestRender = true;
                this.renderComplete = false;
                this.finishDrawingRunnable = runnable;
                glThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = new StringBuilder();
            var1_1.append("GLThread ");
            var1_1.append(this.getId());
            this.setName(var1_1.toString());
            try {
                this.guardedRun();
lbl9:
                // 2 sources

                while (true) {
                    MapboxGLSurfaceView.access$400().threadExiting(this);
                    break;
                }
            }
            catch (Throwable var1_2) {
                MapboxGLSurfaceView.access$400().threadExiting(this);
                throw var1_2;
            }
            return;
            catch (InterruptedException var1_3) {
                ** continue;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setRenderMode(int n) {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                this.renderMode = n;
                glThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.hasSurface = true;
                this.finishedCreatingEglSurface = false;
                glThreadManager.notifyAll();
                while (this.waitingForSurface && !this.finishedCreatingEglSurface && !(bl = this.exited)) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = glThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.hasSurface = false;
                glThreadManager.notifyAll();
                while (!this.waitingForSurface && !(bl = this.exited)) {
                    try {
                        glThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }
    }

    private static class GLThreadManager {
        private GLThreadManager() {
        }

        void releaseEglContextLocked(GLThread gLThread) {
            this.notifyAll();
        }

        void threadExiting(GLThread gLThread) {
            synchronized (this) {
                GLThread.access$802(gLThread, true);
                this.notifyAll();
                return;
            }
        }
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder = new StringBuilder();

        LogWriter() {
        }

        private void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                Log.v((String)MapboxGLSurfaceView.TAG, (String)this.mBuilder.toString());
                StringBuilder stringBuilder = this.mBuilder;
                stringBuilder.delete(0, stringBuilder.length());
            }
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                if (c == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c);
            }
        }
    }

    public static interface OnGLSurfaceViewDetachedListener {
        public void onGLSurfaceViewDetached();
    }
}

