/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.renderer.textureview;

import android.graphics.SurfaceTexture;
import android.view.TextureView;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.renderer.egl.EGLConfigChooser;
import com.mapbox.mapboxsdk.maps.renderer.textureview.TextureViewMapRenderer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;

class TextureViewRenderThread
extends Thread
implements TextureView.SurfaceTextureListener {
    private static final String TAG = "Mbgl-TextureViewRenderThread";
    private boolean destroyContext;
    private boolean destroySurface;
    private final EGLHolder eglHolder;
    private final ArrayList<Runnable> eventQueue;
    private boolean exited;
    private int height;
    private final Object lock = new Object();
    private final TextureViewMapRenderer mapRenderer;
    private boolean paused;
    private boolean requestRender;
    private boolean shouldExit;
    private boolean sizeChanged;
    private SurfaceTexture surface;
    private int width;

    TextureViewRenderThread(TextureView textureView, TextureViewMapRenderer textureViewMapRenderer) {
        this.eventQueue = new ArrayList();
        textureView.setOpaque(textureViewMapRenderer.isTranslucentSurface() ^ true);
        textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        this.mapRenderer = textureViewMapRenderer;
        this.eglHolder = new EGLHolder(new WeakReference<TextureView>(textureView), textureViewMapRenderer.isTranslucentSurface());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onDestroy() {
        Object object = this.lock;
        synchronized (object) {
            this.shouldExit = true;
            this.lock.notifyAll();
            boolean bl;
            while (!(bl = this.exited)) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onPause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            this.lock.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onResume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.lock.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.surface = surfaceTexture;
            this.width = n;
            this.height = n2;
            this.requestRender = true;
            this.lock.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
        object = this.lock;
        synchronized (object) {
            this.surface = null;
            this.destroySurface = true;
            this.requestRender = false;
            this.lock.notifyAll();
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSurfaceTextureSizeChanged(SurfaceTexture object, int n, int n2) {
        object = this.lock;
        synchronized (object) {
            this.width = n;
            this.height = n2;
            this.sizeChanged = true;
            this.requestRender = true;
            this.lock.notifyAll();
            return;
        }
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void queueEvent(Runnable runnable) {
        if (runnable != null) {
            Object object = this.lock;
            synchronized (object) {
                this.eventQueue.add(runnable);
                this.lock.notifyAll();
                return;
            }
        }
        throw new IllegalArgumentException("runnable must not be null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void requestRender() {
        Object object = this.lock;
        synchronized (object) {
            this.requestRender = true;
            this.lock.notifyAll();
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block32: while (true) {
            var1_1 = this.lock;
            // MONITORENTER : var1_1
            while (true) {
                block44: {
                    block38: {
                        block45: {
                            block43: {
                                block40: {
                                    block42: {
                                        block41: {
                                            block39: {
                                                if (this.shouldExit) {
                                                    // MONITOREXIT : var1_1
                                                    this.eglHolder.cleanup();
                                                    var1_1 = this.lock;
                                                    // MONITORENTER : var1_1
                                                    this.exited = true;
                                                    this.lock.notifyAll();
                                                    // MONITOREXIT : var1_1
                                                    return;
                                                }
                                                var3_6 = this.eventQueue.isEmpty();
                                                var4_7 = -1;
                                                if (var3_6) break block39;
                                                var2_3 = this.eventQueue.remove(0);
                                                break block40;
                                            }
                                            if (!this.destroySurface) break block41;
                                            EGLHolder.access$000(this.eglHolder);
                                            this.destroySurface = false;
                                            break block42;
                                        }
                                        if (!this.destroyContext) break block43;
                                        EGLHolder.access$100(this.eglHolder);
                                        this.destroyContext = false;
                                    }
                                    var2_3 = null;
                                }
                                var5_8 = -1;
                                ** GOTO lbl55
                            }
                            if (this.surface == null || this.paused || !this.requestRender) break block44;
                            var6_9 = this.width;
                            var5_8 = this.height;
                            if (EGLHolder.access$200(this.eglHolder) != EGL10.EGL_NO_CONTEXT) break block45;
                            var2_3 = null;
                            var7_10 = 1;
                            var4_7 = var6_9;
                            var6_9 = var7_10;
                            ** GOTO lbl56
                        }
                        if (EGLHolder.access$300(this.eglHolder) == EGL10.EGL_NO_SURFACE) {
                            var2_3 = null;
                            var8_11 = 0;
                            var7_10 = 1;
                            var4_7 = var6_9;
                            var6_9 = var8_11;
                        } else {
                            this.requestRender = false;
                            var2_3 = null;
                            var4_7 = var6_9;
lbl55:
                            // 2 sources

                            var6_9 = 0;
lbl56:
                            // 2 sources

                            var7_10 = 0;
                        }
                        // MONITOREXIT : var1_1
                        if (var2_3 == null) ** GOTO lbl62
                        var2_3.run();
                        continue block32;
lbl62:
                        // 1 sources

                        var1_1 = this.eglHolder.createGL();
                        if (var6_9 == 0) ** GOTO lbl-1000
                        this.eglHolder.prepare();
                        var2_3 = this.lock;
                        // MONITORENTER : var2_3
                        if (this.eglHolder.createSurface()) break block38;
                        this.destroySurface = true;
                        // MONITOREXIT : var2_3
                        continue block32;
                    }
                    // MONITOREXIT : var2_3
                    this.mapRenderer.onSurfaceCreated((GL10)var1_1, EGLHolder.access$400(this.eglHolder));
                    this.mapRenderer.onSurfaceChanged((GL10)var1_1, var4_7, var5_8);
                    continue block32;
lbl-1000:
                    // 1 sources

                    {
                        if (var7_10 == 0) ** GOTO lbl-1000
                        var2_3 = this.lock;
                        // MONITORENTER : var2_3
                    }
                    this.eglHolder.createSurface();
                    // MONITOREXIT : var2_3
                    this.mapRenderer.onSurfaceChanged((GL10)var1_1, var4_7, var5_8);
                    continue block32;
lbl-1000:
                    // 1 sources

                    {
                        if (this.sizeChanged) {
                            this.mapRenderer.onSurfaceChanged((GL10)var1_1, var4_7, var5_8);
                            this.sizeChanged = false;
                            continue block32;
                        }
                        if (EGLHolder.access$300(this.eglHolder) == EGL10.EGL_NO_SURFACE) continue block32;
                        this.mapRenderer.onDrawFrame((GL10)var1_1);
                        var6_9 = this.eglHolder.swap();
                        if (var6_9 == 12288) continue block32;
                        if (var6_9 == 12302) ** GOTO lbl-1000
                        Logger.w("Mbgl-TextureViewRenderThread", String.format("eglSwapBuffer error: %s. Waiting or new surface", new Object[]{var6_9}));
                        var1_1 = this.lock;
                        // MONITORENTER : var1_1
                    }
                    this.surface = null;
                    this.destroySurface = true;
                    // MONITOREXIT : var1_1
                    continue block32;
lbl-1000:
                    // 1 sources

                    {
                        Logger.w("Mbgl-TextureViewRenderThread", "Context lost. Waiting for re-aquire");
                        var2_3 = this.lock;
                        // MONITORENTER : var2_3
                    }
                    this.surface = null;
                    this.destroySurface = true;
                    this.destroyContext = true;
                    // MONITOREXIT : var2_3
                    continue block32;
                }
                this.lock.wait();
            }
            break;
        }
        catch (Throwable var1_2) {
            this.eglHolder.cleanup();
            var2_3 = this.lock;
            // MONITORENTER : var2_3
            this.exited = true;
            this.lock.notifyAll();
            // MONITOREXIT : var2_3
            throw var1_2;
        }
        catch (InterruptedException var2_4) {
            this.eglHolder.cleanup();
            var2_5 = this.lock;
            // MONITORENTER : var2_5
            this.exited = true;
            this.lock.notifyAll();
            // MONITOREXIT : var2_5
            return;
        }
    }

    private static class EGLHolder {
        private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
        private EGL10 egl;
        private EGLConfig eglConfig;
        private EGLContext eglContext;
        private EGLDisplay eglDisplay = EGL10.EGL_NO_DISPLAY;
        private EGLSurface eglSurface;
        private final WeakReference<TextureView> textureViewWeakRef;
        private boolean translucentSurface;

        EGLHolder(WeakReference<TextureView> weakReference, boolean bl) {
            this.eglContext = EGL10.EGL_NO_CONTEXT;
            this.eglSurface = EGL10.EGL_NO_SURFACE;
            this.textureViewWeakRef = weakReference;
            this.translucentSurface = bl;
        }

        static /* synthetic */ void access$000(EGLHolder eGLHolder) {
            eGLHolder.destroySurface();
        }

        static /* synthetic */ void access$100(EGLHolder eGLHolder) {
            eGLHolder.destroyContext();
        }

        static /* synthetic */ EGLContext access$200(EGLHolder eGLHolder) {
            return eGLHolder.eglContext;
        }

        static /* synthetic */ EGLSurface access$300(EGLHolder eGLHolder) {
            return eGLHolder.eglSurface;
        }

        static /* synthetic */ EGLConfig access$400(EGLHolder eGLHolder) {
            return eGLHolder.eglConfig;
        }

        private void destroyContext() {
            if (this.eglContext == EGL10.EGL_NO_CONTEXT) {
                return;
            }
            if (!this.egl.eglDestroyContext(this.eglDisplay, this.eglContext)) {
                Logger.w(TextureViewRenderThread.TAG, String.format("Could not destroy egl context. Display %s, Context %s", this.eglDisplay, this.eglContext));
            }
            this.eglContext = EGL10.EGL_NO_CONTEXT;
        }

        private void destroySurface() {
            if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
                return;
            }
            if (!this.egl.eglDestroySurface(this.eglDisplay, this.eglSurface)) {
                Logger.w(TextureViewRenderThread.TAG, String.format("Could not destroy egl surface. Display %s, Surface %s", this.eglDisplay, this.eglSurface));
            }
            this.eglSurface = EGL10.EGL_NO_SURFACE;
        }

        private void terminate() {
            if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
                return;
            }
            if (!this.egl.eglTerminate(this.eglDisplay)) {
                Logger.w(TextureViewRenderThread.TAG, String.format("Could not terminate egl. Display %s", this.eglDisplay));
            }
            this.eglDisplay = EGL10.EGL_NO_DISPLAY;
        }

        void cleanup() {
            this.destroySurface();
            this.destroyContext();
            this.terminate();
        }

        GL10 createGL() {
            return (GL10)this.eglContext.getGL();
        }

        boolean createSurface() {
            this.destroySurface();
            TextureView textureView = (TextureView)this.textureViewWeakRef.get();
            this.eglSurface = textureView != null && textureView.getSurfaceTexture() != null ? this.egl.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, (Object)textureView.getSurfaceTexture(), new int[]{12344}) : EGL10.EGL_NO_SURFACE;
            textureView = this.eglSurface;
            if (textureView != null && textureView != EGL10.EGL_NO_SURFACE) {
                return this.makeCurrent();
            }
            if (this.egl.eglGetError() == 12299) {
                Logger.e(TextureViewRenderThread.TAG, "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }

        boolean makeCurrent() {
            EGL10 eGL10 = this.egl;
            EGLDisplay eGLDisplay = this.eglDisplay;
            EGLSurface eGLSurface = this.eglSurface;
            if (!eGL10.eglMakeCurrent(eGLDisplay, eGLSurface, eGLSurface, this.eglContext)) {
                Logger.w(TextureViewRenderThread.TAG, String.format("eglMakeCurrent: %s", this.egl.eglGetError()));
                return false;
            }
            return true;
        }

        void prepare() {
            Object object;
            this.egl = (EGL10)EGLContext.getEGL();
            if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
                this.eglDisplay = object = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
                if (object != EGL10.EGL_NO_DISPLAY) {
                    object = new int[2];
                    if (!this.egl.eglInitialize(this.eglDisplay, (int[])object)) {
                        throw new RuntimeException("eglInitialize failed");
                    }
                } else {
                    throw new RuntimeException("eglGetDisplay failed");
                }
            }
            if (this.textureViewWeakRef == null) {
                this.eglConfig = null;
                this.eglContext = EGL10.EGL_NO_CONTEXT;
            } else if (this.eglContext == EGL10.EGL_NO_CONTEXT) {
                object = new EGLConfigChooser(this.translucentSurface).chooseConfig(this.egl, this.eglDisplay);
                this.eglConfig = object;
                this.eglContext = this.egl.eglCreateContext(this.eglDisplay, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, new int[]{12440, 2, 12344});
            }
            if (this.eglContext != EGL10.EGL_NO_CONTEXT) {
                return;
            }
            throw new RuntimeException("createContext");
        }

        int swap() {
            if (!this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface)) {
                return this.egl.eglGetError();
            }
            return 12288;
        }
    }
}

