/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.os.Bundle;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mapbox.mapboxsdk.module.telemetry.MapBaseEvent;
import com.mapbox.mapboxsdk.module.telemetry.PhoneState;
import java.util.ArrayList;
import java.util.List;

class PerformanceEvent
extends MapBaseEvent {
    private static final String PERFORMANCE_TRACE = "mobile.performance_trace";
    private final List<PerformanceAttribute<String>> attributes;
    private final List<PerformanceAttribute<Double>> counters;
    private final JsonObject metadata;
    private final String sessionId;

    PerformanceEvent(PhoneState phoneState, String string2, Bundle bundle) {
        super(phoneState);
        this.sessionId = string2;
        this.attributes = this.initList(bundle.getString("attributes"), new TypeToken<ArrayList<PerformanceAttribute<String>>>(){});
        this.counters = this.initList(bundle.getString("counters"), new TypeToken<ArrayList<PerformanceAttribute<Double>>>(){});
        this.metadata = this.initMetaData(bundle.getString("metadata"));
    }

    private <T> ArrayList<PerformanceAttribute<T>> initList(String string2, TypeToken typeToken) {
        if (string2 != null && !string2.isEmpty()) {
            return (ArrayList)new Gson().fromJson(string2, typeToken.getType());
        }
        return new ArrayList<PerformanceAttribute<T>>();
    }

    private JsonObject initMetaData(String string2) {
        if (string2 == null) {
            return new JsonObject();
        }
        return new Gson().fromJson(string2, JsonObject.class);
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (PerformanceEvent)object;
            List<PerformanceAttribute<Object>> list = this.sessionId;
            if (list != null ? !((String)((Object)list)).equals(((PerformanceEvent)object).sessionId) : ((PerformanceEvent)object).sessionId != null) {
                return false;
            }
            list = this.attributes;
            if (list != null ? !list.equals(((PerformanceEvent)object).attributes) : ((PerformanceEvent)object).attributes != null) {
                return false;
            }
            list = this.counters;
            if (list != null ? !list.equals(((PerformanceEvent)object).counters) : ((PerformanceEvent)object).counters != null) {
                return false;
            }
            list = this.metadata;
            object = ((PerformanceEvent)object).metadata;
            if (list != null) {
                bl = ((JsonObject)((Object)list)).equals(object);
            } else if (object != null) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    List<PerformanceAttribute<String>> getAttributes() {
        return this.attributes;
    }

    List<PerformanceAttribute<Double>> getCounters() {
        return this.counters;
    }

    @Override
    String getEventName() {
        return PERFORMANCE_TRACE;
    }

    JsonObject getMetadata() {
        return this.metadata;
    }

    String getSessionId() {
        return this.sessionId;
    }

    public int hashCode() {
        Object object = this.sessionId;
        int n = 0;
        int n2 = object != null ? ((String)object).hashCode() : 0;
        object = this.attributes;
        int n3 = object != null ? object.hashCode() : 0;
        object = this.counters;
        int n4 = object != null ? object.hashCode() : 0;
        object = this.metadata;
        if (object != null) {
            n = ((JsonObject)object).hashCode();
        }
        return ((n2 * 31 + n3) * 31 + n4) * 31 + n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PerformanceEvent{sessionId='");
        stringBuilder.append(this.sessionId);
        stringBuilder.append('\'');
        stringBuilder.append(", attributes=");
        stringBuilder.append(this.attributes);
        stringBuilder.append(", counters=");
        stringBuilder.append(this.counters);
        stringBuilder.append(", metadata=");
        stringBuilder.append(this.metadata);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static class PerformanceAttribute<T> {
        private final String name;
        private final T value;

        PerformanceAttribute(String string2, T t) {
            this.name = string2;
            this.value = t;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (PerformanceAttribute)object;
                String string2 = this.name;
                if (string2 != null ? !string2.equals(((PerformanceAttribute)object).name) : ((PerformanceAttribute)object).name != null) {
                    return false;
                }
                string2 = this.value;
                object = ((PerformanceAttribute)object).value;
                if (string2 != null) {
                    bl = string2.equals(object);
                } else if (object != null) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            String string2 = this.name;
            int n = 0;
            int n2 = string2 != null ? string2.hashCode() : 0;
            string2 = this.value;
            if (string2 != null) {
                n = string2.hashCode();
            }
            return n2 * 31 + n;
        }
    }
}

