/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.mapbox.android.telemetry.TelemetryUtils;

class PhoneState {
    private static final String NO_CARRIER = "EMPTY_CARRIER";
    private static final int NO_NETWORK = -1;
    private float accessibilityFontScale;
    private int batteryLevel;
    private String carrier;
    private String cellularNetworkType;
    private String created;
    private Orientation orientation;
    private boolean pluggedIn;
    private float resolution;
    private boolean wifi;

    PhoneState() {
    }

    PhoneState(Context context) {
        this.created = TelemetryUtils.obtainCurrentDate();
        this.batteryLevel = TelemetryUtils.obtainBatteryLevel(context);
        this.pluggedIn = TelemetryUtils.isPluggedIn(context);
        this.cellularNetworkType = TelemetryUtils.obtainCellularNetworkType(context);
        this.orientation = Orientation.getOrientation(context.getResources().getConfiguration().orientation);
        this.accessibilityFontScale = context.getResources().getConfiguration().fontScale;
        this.carrier = this.obtainCellularCarrier(context);
        this.resolution = this.obtainDisplayDensity(context);
        this.wifi = this.isConnectedToWifi(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConnectedToWifi(Context context) {
        WifiManager wifiManager;
        boolean bl;
        block4: {
            bl = false;
            try {
                wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
                if (wifiManager != null) break block4;
                return false;
            }
            catch (Exception exception) {
                return bl;
            }
        }
        context = wifiManager.getConnectionInfo();
        boolean bl2 = bl;
        if (!wifiManager.isWifiEnabled()) return bl2;
        int n = context.getNetworkId();
        bl2 = bl;
        if (n == -1) return bl2;
        return true;
    }

    private String obtainCellularCarrier(Context object) {
        if ((object = (TelephonyManager)object.getSystemService("phone")) == null) {
            return NO_CARRIER;
        }
        if (TextUtils.isEmpty((CharSequence)(object = object.getNetworkOperatorName()))) {
            return NO_CARRIER;
        }
        return object;
    }

    private float obtainDisplayDensity(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.density;
    }

    float getAccessibilityFontScale() {
        return this.accessibilityFontScale;
    }

    int getBatteryLevel() {
        return this.batteryLevel;
    }

    String getCarrier() {
        return this.carrier;
    }

    String getCellularNetworkType() {
        return this.cellularNetworkType;
    }

    String getCreated() {
        return this.created;
    }

    String getOrientation() {
        return this.orientation.getOrientation();
    }

    float getResolution() {
        return this.resolution;
    }

    boolean isPluggedIn() {
        return this.pluggedIn;
    }

    boolean isWifi() {
        return this.wifi;
    }

    void setAccessibilityFontScale(float f) {
        this.accessibilityFontScale = f;
    }

    void setBatteryLevel(int n) {
        this.batteryLevel = n;
    }

    void setCarrier(String string2) {
        this.carrier = string2;
    }

    void setCellularNetworkType(String string2) {
        this.cellularNetworkType = string2;
    }

    void setCreated(String string2) {
        this.created = string2;
    }

    void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    void setPluggedIn(boolean bl) {
        this.pluggedIn = bl;
    }

    void setResolution(float f) {
        this.resolution = f;
    }

    void setWifi(boolean bl) {
        this.wifi = bl;
    }

    static final class Orientation
    extends Enum<Orientation> {
        private static final /* synthetic */ Orientation[] $VALUES;
        public static final /* enum */ Orientation ORIENTATION_LANDSCAPE;
        public static final /* enum */ Orientation ORIENTATION_PORTRAIT;
        private String orientation;

        static {
            Orientation orientation;
            Orientation orientation2;
            ORIENTATION_PORTRAIT = orientation2 = new Orientation("Portrait");
            ORIENTATION_LANDSCAPE = orientation = new Orientation("Landscape");
            $VALUES = new Orientation[]{orientation2, orientation};
        }

        private Orientation(String string3) {
            this.orientation = string3;
        }

        public static Orientation getOrientation(int n) {
            if (1 == n) {
                return ORIENTATION_PORTRAIT;
            }
            return ORIENTATION_LANDSCAPE;
        }

        public static Orientation valueOf(String string2) {
            return Enum.valueOf(Orientation.class, string2);
        }

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public String getOrientation() {
            return this.orientation;
        }
    }
}

