/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.content.Context;
import android.os.Bundle;
import com.mapbox.android.telemetry.AppUserTurnstile;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.SessionInterval;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.module.telemetry.MapEventFactory;
import com.mapbox.mapboxsdk.module.telemetry.PhoneState;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import java.util.UUID;

public class TelemetryImpl
implements TelemetryDefinition {
    private final Context appContext;
    private final MapboxTelemetry telemetry;

    public TelemetryImpl() {
        Object object = Mapbox.getApplicationContext();
        this.appContext = object;
        object = new MapboxTelemetry((Context)object, Mapbox.getAccessToken(), "mapbox-maps-android/9.7.1");
        this.telemetry = object;
        TelemetryEnabler.State state = TelemetryEnabler.retrieveTelemetryStateFromPreferences();
        if (TelemetryEnabler.State.ENABLED.equals((Object)state)) {
            ((MapboxTelemetry)object).enable();
        }
    }

    @Override
    public void disableTelemetrySession() {
        this.telemetry.disable();
    }

    @Override
    public void onAppUserTurnstileEvent() {
        AppUserTurnstile appUserTurnstile = new AppUserTurnstile("mapbox-maps-android", "9.7.1");
        appUserTurnstile.setSkuId("00");
        this.telemetry.push(appUserTurnstile);
        this.telemetry.push(MapEventFactory.buildMapLoadEvent(new PhoneState(this.appContext)));
    }

    @Override
    public void onCreateOfflineRegion(OfflineRegionDefinition offlineRegionDefinition) {
        this.telemetry.push(MapEventFactory.buildOfflineDownloadStartEvent(new PhoneState(this.appContext), offlineRegionDefinition.getType(), offlineRegionDefinition.getMinZoom(), offlineRegionDefinition.getMaxZoom(), offlineRegionDefinition.getStyleURL()));
    }

    @Override
    @Deprecated
    public void onGestureInteraction(String string2, double d, double d2, double d3) {
    }

    @Override
    public void onPerformanceEvent(Bundle bundle) {
        Bundle bundle2 = bundle;
        if (bundle == null) {
            bundle2 = new Bundle();
        }
        this.telemetry.push(MapEventFactory.buildPerformanceEvent(new PhoneState(this.appContext), UUID.randomUUID().toString(), bundle2));
    }

    @Override
    public void setDebugLoggingEnabled(boolean bl) {
        this.telemetry.updateDebugLoggingEnabled(bl);
    }

    @Override
    public boolean setSessionIdRotationInterval(int n) {
        return this.telemetry.updateSessionIdRotationInterval(new SessionInterval(n));
    }

    @Override
    public void setUserTelemetryRequestState(boolean bl) {
        if (bl) {
            TelemetryEnabler.updateTelemetryState(TelemetryEnabler.State.ENABLED);
            this.telemetry.enable();
        } else {
            this.telemetry.disable();
            TelemetryEnabler.updateTelemetryState(TelemetryEnabler.State.DISABLED);
        }
    }
}

