/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.net.ConnectivityListener;
import com.mapbox.mapboxsdk.net.NativeConnectivityListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConnectivityReceiver
extends BroadcastReceiver {
    private static ConnectivityReceiver INSTANCE;
    private static final String LOG_CONNECTED = "connected - true";
    private static final String LOG_NOT_CONNECTED = "connected - false";
    private static final String TAG = "Mbgl-ConnectivityReceiver";
    private int activationCounter;
    private Boolean connected;
    private Context context;
    private List<ConnectivityListener> listeners = new CopyOnWriteArrayList<ConnectivityListener>();

    private ConnectivityReceiver(Context context) {
        this.context = context;
    }

    public static ConnectivityReceiver instance(Context object) {
        synchronized (ConnectivityReceiver.class) {
            if (INSTANCE == null) {
                ConnectivityReceiver connectivityReceiver;
                INSTANCE = connectivityReceiver = new ConnectivityReceiver(object.getApplicationContext());
                object = new NativeConnectivityListener();
                connectivityReceiver.addListener((ConnectivityListener)object);
            }
            object = INSTANCE;
            return object;
        }
    }

    private boolean isNetworkActive() {
        NetworkInfo networkInfo = ((ConnectivityManager)this.context.getSystemService("connectivity")).getActiveNetworkInfo();
        boolean bl = networkInfo != null && networkInfo.isConnected();
        return bl;
    }

    private void notifyListeners(boolean bl) {
        Object object = bl ? LOG_CONNECTED : LOG_NOT_CONNECTED;
        Logger.v(TAG, (String)object);
        object = this.listeners.iterator();
        while (object.hasNext()) {
            ((ConnectivityListener)object.next()).onNetworkStateChanged(bl);
        }
    }

    public void activate() {
        if (this.activationCounter == 0) {
            this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        ++this.activationCounter;
    }

    public void addListener(ConnectivityListener connectivityListener) {
        this.listeners.add(connectivityListener);
    }

    public void deactivate() {
        int n;
        this.activationCounter = n = this.activationCounter - 1;
        if (n == 0) {
            this.context.unregisterReceiver((BroadcastReceiver)INSTANCE);
        }
    }

    public boolean isConnected() {
        Boolean bl = this.connected;
        boolean bl2 = bl != null ? bl.booleanValue() : this.isNetworkActive();
        return bl2;
    }

    public void onReceive(Context context, Intent intent) {
        if (this.connected != null) {
            return;
        }
        this.notifyListeners(this.isNetworkActive());
    }

    public void removeListener(ConnectivityListener connectivityListener) {
        this.listeners.remove(connectivityListener);
    }

    public void setConnected(Boolean bl) {
        this.connected = bl;
        boolean bl2 = bl != null ? bl.booleanValue() : this.isNetworkActive();
        this.notifyListeners(bl2);
    }
}

