/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.turf.TurfMeasurement;

public class OfflineGeometryRegionDefinition
implements OfflineRegionDefinition {
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public OfflineGeometryRegionDefinition createFromParcel(Parcel parcel) {
            return new OfflineGeometryRegionDefinition(parcel);
        }

        public OfflineGeometryRegionDefinition[] newArray(int n) {
            return new OfflineGeometryRegionDefinition[n];
        }
    };
    private Geometry geometry;
    private boolean includeIdeographs;
    private double maxZoom;
    private double minZoom;
    private float pixelRatio;
    private String styleURL;

    public OfflineGeometryRegionDefinition(Parcel parcel) {
        this.styleURL = parcel.readString();
        this.geometry = Feature.fromJson(parcel.readString()).geometry();
        this.minZoom = parcel.readDouble();
        this.maxZoom = parcel.readDouble();
        this.pixelRatio = parcel.readFloat();
        boolean bl = parcel.readByte() != 0;
        this.includeIdeographs = bl;
    }

    public OfflineGeometryRegionDefinition(String string2, Geometry geometry, double d, double d2, float f) {
        this(string2, geometry, d, d2, f, false);
    }

    public OfflineGeometryRegionDefinition(String string2, Geometry geometry, double d, double d2, float f, boolean bl) {
        this.styleURL = string2;
        this.geometry = geometry;
        this.minZoom = d;
        this.maxZoom = d2;
        this.pixelRatio = f;
        this.includeIdeographs = bl;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public LatLngBounds getBounds() {
        Object object = this.geometry;
        if (object == null) {
            return null;
        }
        object = TurfMeasurement.bbox((Geometry)object);
        return LatLngBounds.from((double)object[3], (double)object[2], (double)object[1], (double)object[0]);
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public boolean getIncludeIdeographs() {
        return this.includeIdeographs;
    }

    @Override
    public double getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public double getMinZoom() {
        return this.minZoom;
    }

    @Override
    public float getPixelRatio() {
        return this.pixelRatio;
    }

    @Override
    public String getStyleURL() {
        return this.styleURL;
    }

    @Override
    public String getType() {
        return "shaperegion";
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.styleURL);
        parcel.writeString(Feature.fromGeometry(this.geometry).toJson());
        parcel.writeDouble(this.minZoom);
        parcel.writeDouble(this.maxZoom);
        parcel.writeFloat(this.pixelRatio);
        parcel.writeByte((byte)(this.includeIdeographs ? 1 : 0));
    }
}

