/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.offline.CacheAreaDefinition;
import com.mapbox.mapboxsdk.offline.OfflineRegion;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class OfflineManager {
    private static final String TAG = "Mbgl - OfflineManager";
    private static OfflineManager instance;
    private Context context;
    private final FileSource fileSource;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private long nativePtr;

    static {
        LibraryLoader.load();
    }

    private OfflineManager(Context object) {
        this.context = object = object.getApplicationContext();
        object = FileSource.getInstance(object);
        this.fileSource = object;
        this.initialize((FileSource)object);
        this.deleteAmbientDatabase(this.context);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyTempDatabaseFile(File object, File object2) throws IOException {
        Object object3;
        block12: {
            Object object4;
            block13: {
                block14: {
                    if (!((File)object2).exists() && !((File)object2).createNewFile()) {
                        throw new IOException("Unable to copy database file for merge.");
                    }
                    Object var2_2 = null;
                    FileOutputStream fileOutputStream = null;
                    Object var4_5 = null;
                    Object var5_6 = null;
                    try {
                        object3 = new FileInputStream((File)object);
                        object4 = ((FileInputStream)object3).getChannel();
                        object3 = var5_6;
                        object = var2_2;
                    }
                    catch (Throwable throwable) {
                        object2 = null;
                        object = var4_5;
                        break block12;
                    }
                    catch (IOException iOException) {
                        object2 = null;
                        object = fileOutputStream;
                        break block13;
                    }
                    try {
                        object3 = var5_6;
                        object = var2_2;
                        fileOutputStream = new FileOutputStream((File)object2);
                        object3 = var5_6;
                        object = var2_2;
                        object3 = object2 = fileOutputStream.getChannel();
                        object = object2;
                        ((FileChannel)object2).transferFrom((ReadableByteChannel)object4, 0L, ((FileChannel)object4).size());
                        if (object4 == null) break block14;
                    }
                    catch (Throwable throwable) {
                        object = object4;
                        object2 = object3;
                        object3 = throwable;
                        break block12;
                    }
                    catch (IOException iOException) {
                        object2 = object;
                        object = object4;
                        break block13;
                    }
                    ((AbstractInterruptibleChannel)object4).close();
                }
                if (object2 != null) {
                    ((AbstractInterruptibleChannel)object2).close();
                }
                return;
            }
            try {
                void var6_11;
                object4 = new IOException(String.format("Unable to copy database file for merge. %s", var6_11.getMessage()));
                throw object4;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object != null) {
            ((AbstractInterruptibleChannel)object).close();
        }
        if (object2 != null) {
            ((AbstractInterruptibleChannel)object2).close();
        }
        throw object3;
    }

    private native void createOfflineRegion(FileSource var1, OfflineRegionDefinition var2, byte[] var3, CreateOfflineRegionCallback var4);

    private void deleteAmbientDatabase(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FileSource.getInternalCachePath(context));
        stringBuilder.append(File.separator);
        stringBuilder.append("mbgl-cache.db");
        FileUtils.deleteFile(stringBuilder.toString());
    }

    public static OfflineManager getInstance(Context object) {
        synchronized (OfflineManager.class) {
            if (instance == null) {
                OfflineManager offlineManager;
                instance = offlineManager = new OfflineManager((Context)object);
            }
            object = instance;
            return object;
        }
    }

    private native void initialize(FileSource var1);

    private native void listOfflineRegions(FileSource var1, ListOfflineRegionsCallback var2);

    private void mergeOfflineDatabaseFiles(final File file, final MergeOfflineRegionsCallback mergeOfflineRegionsCallback, final boolean bl) {
        this.fileSource.activate();
        this.mergeOfflineRegions(this.fileSource, file.getAbsolutePath(), new MergeOfflineRegionsCallback(){

            @Override
            public void onError(final String string2) {
                if (bl) {
                    file.delete();
                }
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        mergeOfflineRegionsCallback.onError(string2);
                    }
                });
            }

            @Override
            public void onMerge(final OfflineRegion[] offlineRegionArray) {
                if (bl) {
                    file.delete();
                }
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        mergeOfflineRegionsCallback.onMerge(offlineRegionArray);
                    }
                });
            }
        });
    }

    private native void mergeOfflineRegions(FileSource var1, String var2, MergeOfflineRegionsCallback var3);

    private native void nativeCancelPrefetchAmbientCacheRequest(long var1);

    private native void nativeClearAmbientCache(FileSourceCallback var1);

    private native void nativeInvalidateAmbientCache(FileSourceCallback var1);

    private native void nativePackDatabase(FileSourceCallback var1);

    private native long nativePrefetchAmbientCache(CacheAreaDefinition var1, PrefetchAmbientCacheCallback var2);

    private native void nativeResetDatabase(FileSourceCallback var1);

    private native void nativeSetMaximumAmbientCacheSize(long var1, FileSourceCallback var3);

    public void cancelPrefetchAmbientCacheRequest(long l) {
        this.nativeCancelPrefetchAmbientCacheRequest(l);
    }

    public void clearAmbientCache(final FileSourceCallback fileSourceCallback) {
        this.fileSource.activate();
        this.nativeClearAmbientCache(new FileSourceCallback(){

            @Override
            public void onError(final String string2) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (fileSourceCallback != null) {
                            fileSourceCallback.onError(string2);
                        }
                    }
                });
            }

            @Override
            public void onSuccess() {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (fileSourceCallback != null) {
                            fileSourceCallback.onSuccess();
                        }
                    }
                });
            }
        });
    }

    public void createOfflineRegion(OfflineRegionDefinition offlineRegionDefinition, byte[] object, final CreateOfflineRegionCallback createOfflineRegionCallback) {
        ConnectivityReceiver.instance(this.context).activate();
        FileSource.getInstance(this.context).activate();
        this.createOfflineRegion(this.fileSource, offlineRegionDefinition, (byte[])object, new CreateOfflineRegionCallback(){

            @Override
            public void onCreate(final OfflineRegion offlineRegion) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectivityReceiver.instance(OfflineManager.this.context).deactivate();
                        FileSource.getInstance(OfflineManager.this.context).deactivate();
                        createOfflineRegionCallback.onCreate(offlineRegion);
                    }
                });
            }

            @Override
            public void onError(final String string2) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectivityReceiver.instance(OfflineManager.this.context).deactivate();
                        FileSource.getInstance(OfflineManager.this.context).deactivate();
                        createOfflineRegionCallback.onError(string2);
                    }
                });
            }
        });
        object = Mapbox.getTelemetry();
        if (object != null) {
            offlineRegionDefinition.getBounds();
            object.onCreateOfflineRegion(offlineRegionDefinition);
        }
    }

    protected native void finalize() throws Throwable;

    public void invalidateAmbientCache(final FileSourceCallback fileSourceCallback) {
        this.fileSource.activate();
        this.nativeInvalidateAmbientCache(new FileSourceCallback(){

            @Override
            public void onError(final String string2) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (fileSourceCallback != null) {
                            fileSourceCallback.onError(string2);
                        }
                    }
                });
            }

            @Override
            public void onSuccess() {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (fileSourceCallback != null) {
                            fileSourceCallback.onSuccess();
                        }
                    }
                });
            }
        });
    }

    public void listOfflineRegions(final ListOfflineRegionsCallback listOfflineRegionsCallback) {
        this.fileSource.activate();
        this.listOfflineRegions(this.fileSource, new ListOfflineRegionsCallback(){

            @Override
            public void onError(final String string2) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        listOfflineRegionsCallback.onError(string2);
                    }
                });
            }

            @Override
            public void onList(final OfflineRegion[] offlineRegionArray) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        listOfflineRegionsCallback.onList(offlineRegionArray);
                    }
                });
            }
        });
    }

    public void mergeOfflineRegions(String string2, MergeOfflineRegionsCallback mergeOfflineRegionsCallback) {
        new Thread(new Runnable(new File(string2), mergeOfflineRegionsCallback){
            final /* synthetic */ MergeOfflineRegionsCallback val$callback;
            final /* synthetic */ File val$src;
            {
                this.val$src = file;
                this.val$callback = mergeOfflineRegionsCallback;
            }

            @Override
            public void run() {
                boolean bl = this.val$src.canWrite();
                final String string2 = null;
                if (bl) {
                    OfflineManager.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            OfflineManager.this.mergeOfflineDatabaseFiles(val$src, val$callback, false);
                        }
                    });
                } else if (this.val$src.canRead()) {
                    final File file = new File(FileSource.getInternalCachePath(OfflineManager.this.context), this.val$src.getName());
                    try {
                        OfflineManager.copyTempDatabaseFile(this.val$src, file);
                        Handler handler = OfflineManager.this.handler;
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                OfflineManager.this.mergeOfflineDatabaseFiles(file, val$callback, true);
                            }
                        };
                        handler.post(runnable);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        string2 = iOException.getMessage();
                    }
                } else {
                    string2 = "Secondary database needs to be located in a readable path.";
                }
                if (string2 != null) {
                    OfflineManager.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            val$callback.onError(string2);
                        }
                    });
                }
            }
        }).start();
    }

    public void packDatabase(final FileSourceCallback fileSourceCallback) {
        this.fileSource.activate();
        this.nativePackDatabase(new FileSourceCallback(){

            @Override
            public void onError(final String string2) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (fileSourceCallback != null) {
                            fileSourceCallback.onError(string2);
                        }
                    }
                });
            }

            @Override
            public void onSuccess() {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (fileSourceCallback != null) {
                            fileSourceCallback.onSuccess();
                        }
                    }
                });
            }
        });
    }

    public long prefetchAmbientCache(CacheAreaDefinition cacheAreaDefinition, PrefetchAmbientCacheCallback prefetchAmbientCacheCallback) {
        return this.nativePrefetchAmbientCache(cacheAreaDefinition, prefetchAmbientCacheCallback);
    }

    public native void putResourceWithUrl(String var1, byte[] var2, long var3, long var5, String var7, boolean var8);

    public void resetDatabase(final FileSourceCallback fileSourceCallback) {
        this.fileSource.activate();
        this.nativeResetDatabase(new FileSourceCallback(){

            @Override
            public void onError(final String string2) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (fileSourceCallback != null) {
                            fileSourceCallback.onError(string2);
                        }
                    }
                });
            }

            @Override
            public void onSuccess() {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (fileSourceCallback != null) {
                            fileSourceCallback.onSuccess();
                        }
                    }
                });
            }
        });
    }

    public native void runPackDatabaseAutomatically(boolean var1);

    public void setMaximumAmbientCacheSize(long l, final FileSourceCallback fileSourceCallback) {
        this.fileSource.activate();
        this.nativeSetMaximumAmbientCacheSize(l, new FileSourceCallback(){

            @Override
            public void onError(final String string2) {
                OfflineManager.this.fileSource.activate();
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (fileSourceCallback != null) {
                            fileSourceCallback.onError(string2);
                        }
                    }
                });
            }

            @Override
            public void onSuccess() {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (fileSourceCallback != null) {
                            fileSourceCallback.onSuccess();
                        }
                    }
                });
            }
        });
    }

    public native void setOfflineMapboxTileCountLimit(long var1);

    public static interface CreateOfflineRegionCallback {
        public void onCreate(OfflineRegion var1);

        public void onError(String var1);
    }

    public static interface FileSourceCallback {
        public void onError(String var1);

        public void onSuccess();
    }

    public static interface ListOfflineRegionsCallback {
        public void onError(String var1);

        public void onList(OfflineRegion[] var1);
    }

    public static interface MergeOfflineRegionsCallback {
        public void onError(String var1);

        public void onMerge(OfflineRegion[] var1);
    }

    public static interface PrefetchAmbientCacheCallback {
        public void onError(long var1, String var3);

        public void onSuccess(long var1);
    }
}

