/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.maps.Projection;

public abstract class Annotation<T extends Geometry> {
    static final String ID_DATA = "custom_data";
    static final String ID_KEY = "id";
    protected T geometry;
    private boolean isDraggable;
    protected JsonObject jsonObject;

    Annotation(long l, JsonObject jsonObject, T t) {
        this.jsonObject = jsonObject;
        jsonObject.addProperty(ID_KEY, l);
        this.geometry = t;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (Annotation)object;
            if (this.isDraggable != ((Annotation)object).isDraggable) {
                return false;
            }
            if (!this.jsonObject.equals(((Annotation)object).jsonObject)) {
                return false;
            }
            return this.geometry.equals(((Annotation)object).geometry);
        }
        return false;
    }

    public JsonElement getData() {
        return this.jsonObject.get(ID_DATA);
    }

    JsonObject getFeature() {
        return this.jsonObject;
    }

    public T getGeometry() {
        T t = this.geometry;
        if (t != null) {
            return t;
        }
        throw new IllegalStateException();
    }

    public long getId() {
        return this.jsonObject.get(ID_KEY).getAsLong();
    }

    abstract String getName();

    abstract Geometry getOffsetGeometry(Projection var1, MoveDistancesObject var2, float var3, float var4);

    public int hashCode() {
        return (this.jsonObject.hashCode() * 31 + this.geometry.hashCode()) * 31 + this.isDraggable;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    public void setData(JsonElement jsonElement) {
        this.jsonObject.add(ID_DATA, jsonElement);
    }

    public void setDraggable(boolean bl) {
        this.isDraggable = bl;
    }

    public void setGeometry(T t) {
        this.geometry = t;
    }

    abstract void setUsedDataDrivenProperties();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        stringBuilder.append("{geometry=");
        stringBuilder.append(this.geometry);
        stringBuilder.append(", properties=");
        stringBuilder.append(this.jsonObject);
        stringBuilder.append(", isDraggable=");
        stringBuilder.append(this.isDraggable);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

