/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import androidx.collection.LongSparseArray;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.CoreElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.DraggableAnnotationController;
import com.mapbox.mapboxsdk.plugins.annotation.OnAnnotationClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnAnnotationDragListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnAnnotationLongClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.Options;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AnnotationManager<L extends Layer, T extends Annotation, S extends Options<T>, D extends OnAnnotationDragListener<T>, U extends OnAnnotationClickListener<T>, V extends OnAnnotationLongClickListener<T>> {
    private static final String TAG = "AnnotationManager";
    protected final LongSparseArray<T> annotations = new LongSparseArray();
    private String belowLayerId;
    private final List<U> clickListeners;
    final Map<String, PropertyValue> constantPropertyUsageMap;
    private CoreElementProvider<L> coreElementProvider;
    private long currentId;
    final Map<String, Boolean> dataDrivenPropertyUsageMap = new HashMap<String, Boolean>();
    private final List<D> dragListeners;
    private DraggableAnnotationController draggableAnnotationController;
    private GeoJsonSource geoJsonSource;
    protected L layer;
    Expression layerFilter;
    private final List<V> longClickListeners;
    private final MapClickResolver mapClickResolver;
    protected final MapboxMap mapboxMap;
    private Style style;

    protected AnnotationManager(MapView mapView, final MapboxMap mapboxMap, Style object, CoreElementProvider<L> coreElementProvider, DraggableAnnotationController draggableAnnotationController, String string2, final GeoJsonOptions geoJsonOptions) {
        this.constantPropertyUsageMap = new HashMap<String, PropertyValue>();
        this.dragListeners = new ArrayList<D>();
        this.clickListeners = new ArrayList<U>();
        this.longClickListeners = new ArrayList<V>();
        this.mapboxMap = mapboxMap;
        this.style = object;
        this.belowLayerId = string2;
        this.coreElementProvider = coreElementProvider;
        this.draggableAnnotationController = draggableAnnotationController;
        if (((Style)object).isFullyLoaded()) {
            this.mapClickResolver = object = new MapClickResolver();
            mapboxMap.addOnMapClickListener((MapboxMap.OnMapClickListener)object);
            mapboxMap.addOnMapLongClickListener((MapboxMap.OnMapLongClickListener)object);
            draggableAnnotationController.addAnnotationManager(this);
            this.initializeSourcesAndLayers(geoJsonOptions);
            mapView.addOnDidFinishLoadingStyleListener(new MapView.OnDidFinishLoadingStyleListener(){

                @Override
                public void onDidFinishLoadingStyle() {
                    mapboxMap.getStyle(new Style.OnStyleLoaded(){

                        @Override
                        public void onStyleLoaded(Style style2) {
                            AnnotationManager.access$102(AnnotationManager.this, style2);
                            AnnotationManager.this.initializeSourcesAndLayers(geoJsonOptions);
                        }
                    });
                }
            });
            return;
        }
        throw new RuntimeException("The style has to be non-null and fully loaded.");
    }

    static /* synthetic */ Style access$102(AnnotationManager annotationManager, Style style2) {
        annotationManager.style = style2;
        return style2;
    }

    private void initializeSourcesAndLayers(GeoJsonOptions object) {
        this.geoJsonSource = this.coreElementProvider.getSource((GeoJsonOptions)object);
        this.layer = this.coreElementProvider.getLayer();
        this.style.addSource(this.geoJsonSource);
        object = this.belowLayerId;
        if (object == null) {
            this.style.addLayer((Layer)this.layer);
        } else {
            this.style.addLayerBelow((Layer)this.layer, (String)object);
        }
        this.initializeDataDrivenPropertyMap();
        ((Layer)this.layer).setProperties(this.constantPropertyUsageMap.values().toArray(new PropertyValue[0]));
        object = this.layerFilter;
        if (object != null) {
            this.setFilter((Expression)object);
        }
        this.updateSource();
    }

    private T queryMapForFeatures(LatLng latLng) {
        return this.queryMapForFeatures(this.mapboxMap.getProjection().toScreenLocation(latLng));
    }

    public void addClickListener(U u) {
        this.clickListeners.add(u);
    }

    public void addDragListener(D d) {
        this.dragListeners.add(d);
    }

    public void addLongClickListener(V v) {
        this.longClickListeners.add(v);
    }

    public T create(S object) {
        object = ((Options)object).build(this.currentId, this);
        this.annotations.put(((Annotation)object).getId(), object);
        ++this.currentId;
        this.updateSource();
        return (T)object;
    }

    public List<T> create(List<S> list) {
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        Iterator<S> iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            list = ((Options)iterator2.next()).build(this.currentId, this);
            arrayList.add(list);
            this.annotations.put(((Annotation)((Object)list)).getId(), list);
            ++this.currentId;
        }
        this.updateSource();
        return arrayList;
    }

    public void delete(T t) {
        this.annotations.remove(((Annotation)t).getId());
        this.updateSource();
    }

    public void delete(List<T> object) {
        Iterator<T> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (Annotation)iterator2.next();
            this.annotations.remove(((Annotation)object).getId());
        }
        this.updateSource();
    }

    public void deleteAll() {
        this.annotations.clear();
        this.updateSource();
    }

    void enableDataDrivenProperty(String string2) {
        if (this.dataDrivenPropertyUsageMap.get(string2).equals(false)) {
            this.dataDrivenPropertyUsageMap.put(string2, true);
            this.setDataDrivenPropertyIsUsed(string2);
        }
    }

    abstract String getAnnotationIdKey();

    public LongSparseArray<T> getAnnotations() {
        return this.annotations;
    }

    List<U> getClickListeners() {
        return this.clickListeners;
    }

    List<D> getDragListeners() {
        return this.dragListeners;
    }

    public String getLayerId() {
        return ((Layer)this.layer).getId();
    }

    List<V> getLongClickListeners() {
        return this.longClickListeners;
    }

    abstract void initializeDataDrivenPropertyMap();

    void internalUpdateSource() {
        if (!this.style.isFullyLoaded()) {
            return;
        }
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.valueAt(i);
            arrayList.add(Feature.fromGeometry(annotation.getGeometry(), annotation.getFeature()));
            annotation.setUsedDataDrivenProperties();
        }
        this.geoJsonSource.setGeoJson(FeatureCollection.fromFeatures(arrayList));
    }

    public void onDestroy() {
        this.mapboxMap.removeOnMapClickListener(this.mapClickResolver);
        this.mapboxMap.removeOnMapLongClickListener(this.mapClickResolver);
        this.draggableAnnotationController.removeAnnotationManager(this);
        this.dragListeners.clear();
        this.clickListeners.clear();
        this.longClickListeners.clear();
    }

    T queryMapForFeatures(PointF object) {
        if (!(object = this.mapboxMap.queryRenderedFeatures((PointF)object, this.coreElementProvider.getLayerId())).isEmpty()) {
            long l = ((Feature)object.get(0)).getProperty(this.getAnnotationIdKey()).getAsLong();
            return (T)((Annotation)this.annotations.get(l));
        }
        return null;
    }

    public void removeClickListener(U u) {
        this.clickListeners.remove(u);
    }

    public void removeDragListener(D d) {
        this.dragListeners.remove(d);
    }

    public void removeLongClickListener(V v) {
        this.longClickListeners.remove(v);
    }

    protected abstract void setDataDrivenPropertyIsUsed(String var1);

    abstract void setFilter(Expression var1);

    public void update(T t) {
        if (this.annotations.containsValue(t)) {
            this.annotations.put(((Annotation)t).getId(), t);
            this.updateSource();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Can't update annotation: ");
            stringBuilder.append(((Annotation)t).toString());
            stringBuilder.append(", the annotation isn't active annotation.");
            Logger.e(TAG, stringBuilder.toString());
        }
    }

    public void update(List<T> object) {
        Iterator<T> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (Annotation)iterator2.next();
            this.annotations.put(((Annotation)object).getId(), object);
        }
        this.updateSource();
    }

    public void updateSource() {
        this.draggableAnnotationController.onSourceUpdated();
        this.internalUpdateSource();
    }

    private class MapClickResolver
    implements MapboxMap.OnMapClickListener,
    MapboxMap.OnMapLongClickListener {
        private MapClickResolver() {
        }

        @Override
        public boolean onMapClick(LatLng object) {
            if (AnnotationManager.this.clickListeners.isEmpty()) {
                return false;
            }
            if ((object = AnnotationManager.this.queryMapForFeatures((LatLng)object)) != null) {
                Iterator iterator2 = AnnotationManager.this.clickListeners.iterator();
                while (iterator2.hasNext()) {
                    if (!((OnAnnotationClickListener)iterator2.next()).onAnnotationClick(object)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean onMapLongClick(LatLng object) {
            if (AnnotationManager.this.longClickListeners.isEmpty()) {
                return false;
            }
            if ((object = AnnotationManager.this.queryMapForFeatures((LatLng)object)) != null) {
                Iterator iterator2 = AnnotationManager.this.longClickListeners.iterator();
                while (iterator2.hasNext()) {
                    if (!((OnAnnotationLongClickListener)iterator2.next()).onAnnotationLongClick(object)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

