/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Fill
extends Annotation<Polygon> {
    private final AnnotationManager<?, Fill, ?, ?, ?, ?> annotationManager;

    Fill(long l, AnnotationManager<?, Fill, ?, ?, ?, ?> annotationManager, JsonObject jsonObject, Polygon polygon) {
        super(l, jsonObject, polygon);
        this.annotationManager = annotationManager;
    }

    public String getFillColor() {
        return this.jsonObject.get("fill-color").getAsString();
    }

    public int getFillColorAsInt() {
        return ColorUtils.rgbaToColor(this.jsonObject.get("fill-color").getAsString());
    }

    public Float getFillOpacity() {
        return Float.valueOf(this.jsonObject.get("fill-opacity").getAsFloat());
    }

    public String getFillOutlineColor() {
        return this.jsonObject.get("fill-outline-color").getAsString();
    }

    public int getFillOutlineColorAsInt() {
        return ColorUtils.rgbaToColor(this.jsonObject.get("fill-outline-color").getAsString());
    }

    public String getFillPattern() {
        return this.jsonObject.get("fill-pattern").getAsString();
    }

    public List<List<LatLng>> getLatLngs() {
        Iterator iterator2 = (Polygon)this.geometry;
        ArrayList<List<LatLng>> arrayList = new ArrayList<List<LatLng>>();
        if ((iterator2 = ((Polygon)((Object)iterator2)).coordinates()) != null) {
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object object = (List)iterator2.next();
                ArrayList<LatLng> arrayList2 = new ArrayList<LatLng>();
                object = object.iterator();
                while (object.hasNext()) {
                    Point point = (Point)object.next();
                    arrayList2.add(new LatLng(point.latitude(), point.longitude()));
                }
                arrayList.add(arrayList2);
            }
        }
        return arrayList;
    }

    @Override
    String getName() {
        return "Fill";
    }

    @Override
    Geometry getOffsetGeometry(Projection projection, MoveDistancesObject moveDistancesObject, float f, float f2) {
        Iterator iterator2 = ((Polygon)this.geometry).coordinates();
        if (iterator2 != null) {
            ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>(iterator2.size());
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object object = (List)iterator2.next();
                ArrayList<Point> arrayList2 = new ArrayList<Point>();
                object = object.iterator();
                while (object.hasNext()) {
                    Object object2 = (Point)object.next();
                    object2 = projection.toScreenLocation(new LatLng(((Point)object2).latitude(), ((Point)object2).longitude()));
                    ((PointF)object2).x -= moveDistancesObject.getDistanceXSinceLast();
                    ((PointF)object2).y -= moveDistancesObject.getDistanceYSinceLast();
                    if (!(((LatLng)(object2 = projection.fromScreenLocation((PointF)object2))).getLatitude() > 85.05112877980659) && !(((LatLng)object2).getLatitude() < -85.05112877980659)) {
                        arrayList2.add(Point.fromLngLat(((LatLng)object2).getLongitude(), ((LatLng)object2).getLatitude()));
                        continue;
                    }
                    return null;
                }
                arrayList.add(arrayList2);
            }
            return Polygon.fromLngLats(arrayList);
        }
        return null;
    }

    public void setFillColor(int n) {
        this.jsonObject.addProperty("fill-color", ColorUtils.colorToRgbaString(n));
    }

    public void setFillColor(String string2) {
        this.jsonObject.addProperty("fill-color", string2);
    }

    public void setFillOpacity(Float f) {
        this.jsonObject.addProperty("fill-opacity", f);
    }

    public void setFillOutlineColor(int n) {
        this.jsonObject.addProperty("fill-outline-color", ColorUtils.colorToRgbaString(n));
    }

    public void setFillOutlineColor(String string2) {
        this.jsonObject.addProperty("fill-outline-color", string2);
    }

    public void setFillPattern(String string2) {
        this.jsonObject.addProperty("fill-pattern", string2);
    }

    public void setLatLngs(List<List<LatLng>> object) {
        ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (List)object.next();
            ArrayList<Point> arrayList2 = new ArrayList<Point>();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                LatLng latLng = (LatLng)object2.next();
                arrayList2.add(Point.fromLngLat(latLng.getLongitude(), latLng.getLatitude()));
            }
            arrayList.add(arrayList2);
        }
        this.geometry = Polygon.fromLngLats(arrayList);
    }

    @Override
    void setUsedDataDrivenProperties() {
        if (!(this.jsonObject.get("fill-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("fill-opacity");
        }
        if (!(this.jsonObject.get("fill-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("fill-color");
        }
        if (!(this.jsonObject.get("fill-outline-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("fill-outline-color");
        }
        if (!(this.jsonObject.get("fill-pattern") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("fill-pattern");
        }
    }
}

