/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.CoreElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.DraggableAnnotationController;
import com.mapbox.mapboxsdk.plugins.annotation.Fill;
import com.mapbox.mapboxsdk.plugins.annotation.FillElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.FillOptions;
import com.mapbox.mapboxsdk.plugins.annotation.OnFillClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnFillDragListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnFillLongClickListener;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.FillLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FillManager
extends AnnotationManager<FillLayer, Fill, FillOptions, OnFillDragListener, OnFillClickListener, OnFillLongClickListener> {
    private static final String PROPERTY_FILL_ANTIALIAS = "fill-antialias";
    private static final String PROPERTY_FILL_TRANSLATE = "fill-translate";
    private static final String PROPERTY_FILL_TRANSLATE_ANCHOR = "fill-translate-anchor";

    public FillManager(MapView mapView, MapboxMap mapboxMap, Style style2) {
        this(mapView, mapboxMap, style2, null, null);
    }

    FillManager(MapView mapView, MapboxMap mapboxMap, Style style2, CoreElementProvider<FillLayer> coreElementProvider, String string2, GeoJsonOptions geoJsonOptions, DraggableAnnotationController draggableAnnotationController) {
        super(mapView, mapboxMap, style2, coreElementProvider, draggableAnnotationController, string2, geoJsonOptions);
    }

    public FillManager(MapView mapView, MapboxMap mapboxMap, Style style2, String string2) {
        this(mapView, mapboxMap, style2, string2, null);
    }

    public FillManager(MapView mapView, MapboxMap mapboxMap, Style style2, String string2, GeoJsonOptions geoJsonOptions) {
        this(mapView, mapboxMap, style2, new FillElementProvider(), string2, geoJsonOptions, DraggableAnnotationController.getInstance(mapView, mapboxMap));
    }

    @Override
    public List<Fill> create(FeatureCollection serializable) {
        Object object = ((FeatureCollection)serializable).features();
        serializable = new ArrayList();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                FillOptions fillOptions = FillOptions.fromFeature((Feature)object.next());
                if (fillOptions == null) continue;
                serializable.add(fillOptions);
            }
        }
        return this.create(serializable);
    }

    @Override
    public List<Fill> create(String string2) {
        return this.create(FeatureCollection.fromJson(string2));
    }

    @Override
    String getAnnotationIdKey() {
        return "id";
    }

    public Boolean getFillAntialias() {
        return (Boolean)((FillLayer)this.layer).getFillAntialias().value;
    }

    public Float[] getFillTranslate() {
        return (Float[])((FillLayer)this.layer).getFillTranslate().value;
    }

    public String getFillTranslateAnchor() {
        return (String)((FillLayer)this.layer).getFillTranslateAnchor().value;
    }

    public Expression getFilter() {
        return ((FillLayer)this.layer).getFilter();
    }

    @Override
    void initializeDataDrivenPropertyMap() {
        Map map = this.dataDrivenPropertyUsageMap;
        Boolean bl = false;
        map.put("fill-opacity", bl);
        this.dataDrivenPropertyUsageMap.put("fill-color", bl);
        this.dataDrivenPropertyUsageMap.put("fill-outline-color", bl);
        this.dataDrivenPropertyUsageMap.put("fill-pattern", bl);
    }

    @Override
    protected void setDataDrivenPropertyIsUsed(String string2) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1201248078: {
                if (!string2.equals("fill-outline-color")) break;
                n2 = 3;
                break;
            }
            case -774008506: {
                if (!string2.equals("fill-pattern")) break;
                n2 = 2;
                break;
            }
            case -1250124351: {
                if (!string2.equals("fill-opacity")) break;
                n2 = 1;
                break;
            }
            case -1679439207: {
                if (!string2.equals("fill-color")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                ((FillLayer)this.layer).setProperties(PropertyFactory.fillOutlineColor(Expression.get("fill-outline-color")));
                break;
            }
            case 2: {
                ((FillLayer)this.layer).setProperties(PropertyFactory.fillPattern(Expression.get("fill-pattern")));
                break;
            }
            case 1: {
                ((FillLayer)this.layer).setProperties(PropertyFactory.fillOpacity(Expression.get("fill-opacity")));
                break;
            }
            case 0: {
                ((FillLayer)this.layer).setProperties(PropertyFactory.fillColor(Expression.get("fill-color")));
            }
        }
    }

    public void setFillAntialias(Boolean object) {
        object = PropertyFactory.fillAntialias((Boolean)object);
        this.constantPropertyUsageMap.put(PROPERTY_FILL_ANTIALIAS, object);
        ((FillLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    public void setFillTranslate(Float[] object) {
        object = PropertyFactory.fillTranslate(object);
        this.constantPropertyUsageMap.put(PROPERTY_FILL_TRANSLATE, object);
        ((FillLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    public void setFillTranslateAnchor(String object) {
        object = PropertyFactory.fillTranslateAnchor((String)object);
        this.constantPropertyUsageMap.put(PROPERTY_FILL_TRANSLATE_ANCHOR, object);
        ((FillLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    @Override
    public void setFilter(Expression expression) {
        this.layerFilter = expression;
        ((FillLayer)this.layer).setFilter(this.layerFilter);
    }
}

