/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.Fill;
import com.mapbox.mapboxsdk.plugins.annotation.Options;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FillOptions
extends Options<Fill> {
    static final String PROPERTY_FILL_COLOR = "fill-color";
    static final String PROPERTY_FILL_OPACITY = "fill-opacity";
    static final String PROPERTY_FILL_OUTLINE_COLOR = "fill-outline-color";
    static final String PROPERTY_FILL_PATTERN = "fill-pattern";
    private static final String PROPERTY_IS_DRAGGABLE = "is-draggable";
    private JsonElement data;
    private String fillColor;
    private Float fillOpacity;
    private String fillOutlineColor;
    private String fillPattern;
    private Polygon geometry;
    private boolean isDraggable;

    static FillOptions fromFeature(Feature feature) {
        if (feature.geometry() != null) {
            if (!(feature.geometry() instanceof Polygon)) {
                return null;
            }
            FillOptions fillOptions = new FillOptions();
            fillOptions.geometry = (Polygon)feature.geometry();
            if (feature.hasProperty(PROPERTY_FILL_OPACITY)) {
                fillOptions.fillOpacity = Float.valueOf(feature.getProperty(PROPERTY_FILL_OPACITY).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_FILL_COLOR)) {
                fillOptions.fillColor = feature.getProperty(PROPERTY_FILL_COLOR).getAsString();
            }
            if (feature.hasProperty(PROPERTY_FILL_OUTLINE_COLOR)) {
                fillOptions.fillOutlineColor = feature.getProperty(PROPERTY_FILL_OUTLINE_COLOR).getAsString();
            }
            if (feature.hasProperty(PROPERTY_FILL_PATTERN)) {
                fillOptions.fillPattern = feature.getProperty(PROPERTY_FILL_PATTERN).getAsString();
            }
            if (feature.hasProperty(PROPERTY_IS_DRAGGABLE)) {
                fillOptions.isDraggable = feature.getProperty(PROPERTY_IS_DRAGGABLE).getAsBoolean();
            }
            return fillOptions;
        }
        throw new RuntimeException("geometry field is required");
    }

    @Override
    Fill build(long l, AnnotationManager<?, Fill, ?, ?, ?, ?> object) {
        if (this.geometry != null) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(PROPERTY_FILL_OPACITY, this.fillOpacity);
            jsonObject.addProperty(PROPERTY_FILL_COLOR, this.fillColor);
            jsonObject.addProperty(PROPERTY_FILL_OUTLINE_COLOR, this.fillOutlineColor);
            jsonObject.addProperty(PROPERTY_FILL_PATTERN, this.fillPattern);
            object = new Fill(l, (AnnotationManager<?, Fill, ?, ?, ?, ?>)object, jsonObject, this.geometry);
            ((Annotation)object).setDraggable(this.isDraggable);
            ((Annotation)object).setData(this.data);
            return object;
        }
        throw new RuntimeException("geometry field is required");
    }

    public JsonElement getData() {
        return this.data;
    }

    public boolean getDraggable() {
        return this.isDraggable;
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public Float getFillOpacity() {
        return this.fillOpacity;
    }

    public String getFillOutlineColor() {
        return this.fillOutlineColor;
    }

    public String getFillPattern() {
        return this.fillPattern;
    }

    public Polygon getGeometry() {
        return this.geometry;
    }

    public List<List<LatLng>> getLatLngs() {
        ArrayList<List<LatLng>> arrayList = new ArrayList<List<LatLng>>();
        Object object = this.geometry;
        if (object != null) {
            object = ((Polygon)object).coordinates().iterator();
            while (object.hasNext()) {
                Object object2 = (List)object.next();
                ArrayList<LatLng> arrayList2 = new ArrayList<LatLng>();
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object2 = (Point)iterator2.next();
                    arrayList2.add(new LatLng(((Point)object2).latitude(), ((Point)object2).longitude()));
                }
                arrayList.add(arrayList2);
            }
        }
        return arrayList;
    }

    public FillOptions withData(JsonElement jsonElement) {
        this.data = jsonElement;
        return this;
    }

    public FillOptions withDraggable(boolean bl) {
        this.isDraggable = bl;
        return this;
    }

    public FillOptions withFillColor(String string2) {
        this.fillColor = string2;
        return this;
    }

    public FillOptions withFillOpacity(Float f) {
        this.fillOpacity = f;
        return this;
    }

    public FillOptions withFillOutlineColor(String string2) {
        this.fillOutlineColor = string2;
        return this;
    }

    public FillOptions withFillPattern(String string2) {
        this.fillPattern = string2;
        return this;
    }

    public FillOptions withGeometry(Polygon polygon) {
        this.geometry = polygon;
        return this;
    }

    public FillOptions withLatLngs(List<List<LatLng>> list) {
        ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>();
        for (List<LatLng> list2 : list) {
            list = new ArrayList<List<LatLng>>();
            for (LatLng latLng : list2) {
                list.add((List<LatLng>)((Object)Point.fromLngLat(latLng.getLongitude(), latLng.getLatitude())));
            }
            arrayList.add(list);
        }
        this.geometry = Polygon.fromLngLats(arrayList);
        return this;
    }
}

