/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.Line;
import com.mapbox.mapboxsdk.plugins.annotation.Options;
import java.util.ArrayList;
import java.util.List;

public class LineOptions
extends Options<Line> {
    private static final String PROPERTY_IS_DRAGGABLE = "is-draggable";
    static final String PROPERTY_LINE_BLUR = "line-blur";
    static final String PROPERTY_LINE_COLOR = "line-color";
    static final String PROPERTY_LINE_GAP_WIDTH = "line-gap-width";
    static final String PROPERTY_LINE_JOIN = "line-join";
    static final String PROPERTY_LINE_OFFSET = "line-offset";
    static final String PROPERTY_LINE_OPACITY = "line-opacity";
    static final String PROPERTY_LINE_PATTERN = "line-pattern";
    static final String PROPERTY_LINE_WIDTH = "line-width";
    private JsonElement data;
    private LineString geometry;
    private boolean isDraggable;
    private Float lineBlur;
    private String lineColor;
    private Float lineGapWidth;
    private String lineJoin;
    private Float lineOffset;
    private Float lineOpacity;
    private String linePattern;
    private Float lineWidth;

    static LineOptions fromFeature(Feature feature) {
        if (feature.geometry() != null) {
            if (!(feature.geometry() instanceof LineString)) {
                return null;
            }
            LineOptions lineOptions = new LineOptions();
            lineOptions.geometry = (LineString)feature.geometry();
            if (feature.hasProperty(PROPERTY_LINE_JOIN)) {
                lineOptions.lineJoin = feature.getProperty(PROPERTY_LINE_JOIN).getAsString();
            }
            if (feature.hasProperty(PROPERTY_LINE_OPACITY)) {
                lineOptions.lineOpacity = Float.valueOf(feature.getProperty(PROPERTY_LINE_OPACITY).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_LINE_COLOR)) {
                lineOptions.lineColor = feature.getProperty(PROPERTY_LINE_COLOR).getAsString();
            }
            if (feature.hasProperty(PROPERTY_LINE_WIDTH)) {
                lineOptions.lineWidth = Float.valueOf(feature.getProperty(PROPERTY_LINE_WIDTH).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_LINE_GAP_WIDTH)) {
                lineOptions.lineGapWidth = Float.valueOf(feature.getProperty(PROPERTY_LINE_GAP_WIDTH).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_LINE_OFFSET)) {
                lineOptions.lineOffset = Float.valueOf(feature.getProperty(PROPERTY_LINE_OFFSET).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_LINE_BLUR)) {
                lineOptions.lineBlur = Float.valueOf(feature.getProperty(PROPERTY_LINE_BLUR).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_LINE_PATTERN)) {
                lineOptions.linePattern = feature.getProperty(PROPERTY_LINE_PATTERN).getAsString();
            }
            if (feature.hasProperty(PROPERTY_IS_DRAGGABLE)) {
                lineOptions.isDraggable = feature.getProperty(PROPERTY_IS_DRAGGABLE).getAsBoolean();
            }
            return lineOptions;
        }
        throw new RuntimeException("geometry field is required");
    }

    @Override
    Line build(long l, AnnotationManager<?, Line, ?, ?, ?, ?> object) {
        if (this.geometry != null) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(PROPERTY_LINE_JOIN, this.lineJoin);
            jsonObject.addProperty(PROPERTY_LINE_OPACITY, this.lineOpacity);
            jsonObject.addProperty(PROPERTY_LINE_COLOR, this.lineColor);
            jsonObject.addProperty(PROPERTY_LINE_WIDTH, this.lineWidth);
            jsonObject.addProperty(PROPERTY_LINE_GAP_WIDTH, this.lineGapWidth);
            jsonObject.addProperty(PROPERTY_LINE_OFFSET, this.lineOffset);
            jsonObject.addProperty(PROPERTY_LINE_BLUR, this.lineBlur);
            jsonObject.addProperty(PROPERTY_LINE_PATTERN, this.linePattern);
            object = new Line(l, (AnnotationManager<?, Line, ?, ?, ?, ?>)object, jsonObject, this.geometry);
            ((Annotation)object).setDraggable(this.isDraggable);
            ((Annotation)object).setData(this.data);
            return object;
        }
        throw new RuntimeException("geometry field is required");
    }

    public JsonElement getData() {
        return this.data;
    }

    public boolean getDraggable() {
        return this.isDraggable;
    }

    public LineString getGeometry() {
        return this.geometry;
    }

    public List<LatLng> getLatLngs() {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        Object object = this.geometry;
        if (object != null) {
            object = ((LineString)object).coordinates().iterator();
            while (object.hasNext()) {
                Point point = (Point)object.next();
                arrayList.add(new LatLng(point.latitude(), point.longitude()));
            }
        }
        return arrayList;
    }

    public Float getLineBlur() {
        return this.lineBlur;
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public Float getLineGapWidth() {
        return this.lineGapWidth;
    }

    public String getLineJoin() {
        return this.lineJoin;
    }

    public Float getLineOffset() {
        return this.lineOffset;
    }

    public Float getLineOpacity() {
        return this.lineOpacity;
    }

    public String getLinePattern() {
        return this.linePattern;
    }

    public Float getLineWidth() {
        return this.lineWidth;
    }

    public LineOptions withData(JsonElement jsonElement) {
        this.data = jsonElement;
        return this;
    }

    public LineOptions withDraggable(boolean bl) {
        this.isDraggable = bl;
        return this;
    }

    public LineOptions withGeometry(LineString lineString) {
        this.geometry = lineString;
        return this;
    }

    public LineOptions withLatLngs(List<LatLng> object) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        object = object.iterator();
        while (object.hasNext()) {
            LatLng latLng = (LatLng)object.next();
            arrayList.add(Point.fromLngLat(latLng.getLongitude(), latLng.getLatitude()));
        }
        this.geometry = LineString.fromLngLats(arrayList);
        return this;
    }

    public LineOptions withLineBlur(Float f) {
        this.lineBlur = f;
        return this;
    }

    public LineOptions withLineColor(String string2) {
        this.lineColor = string2;
        return this;
    }

    public LineOptions withLineGapWidth(Float f) {
        this.lineGapWidth = f;
        return this;
    }

    public LineOptions withLineJoin(String string2) {
        this.lineJoin = string2;
        return this;
    }

    public LineOptions withLineOffset(Float f) {
        this.lineOffset = f;
        return this;
    }

    public LineOptions withLineOpacity(Float f) {
        this.lineOpacity = f;
        return this;
    }

    public LineOptions withLinePattern(String string2) {
        this.linePattern = string2;
        return this;
    }

    public LineOptions withLineWidth(Float f) {
        this.lineWidth = f;
        return this;
    }
}

