/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import com.google.gson.JsonArray;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class Symbol
extends Annotation<Point> {
    private final AnnotationManager<?, Symbol, ?, ?, ?, ?> annotationManager;

    Symbol(long l, AnnotationManager<?, Symbol, ?, ?, ?, ?> annotationManager, JsonObject jsonObject, Point point) {
        super(l, jsonObject, point);
        this.annotationManager = annotationManager;
    }

    public String getIconAnchor() {
        return this.jsonObject.get("icon-anchor").getAsString();
    }

    public String getIconColor() {
        return this.jsonObject.get("icon-color").getAsString();
    }

    public int getIconColorAsInt() {
        return ColorUtils.rgbaToColor(this.jsonObject.get("icon-color").getAsString());
    }

    public Float getIconHaloBlur() {
        return Float.valueOf(this.jsonObject.get("icon-halo-blur").getAsFloat());
    }

    public String getIconHaloColor() {
        return this.jsonObject.get("icon-halo-color").getAsString();
    }

    public int getIconHaloColorAsInt() {
        return ColorUtils.rgbaToColor(this.jsonObject.get("icon-halo-color").getAsString());
    }

    public Float getIconHaloWidth() {
        return Float.valueOf(this.jsonObject.get("icon-halo-width").getAsFloat());
    }

    public String getIconImage() {
        return this.jsonObject.get("icon-image").getAsString();
    }

    public PointF getIconOffset() {
        JsonArray jsonArray = this.jsonObject.getAsJsonArray("icon-offset");
        return new PointF(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat());
    }

    public Float getIconOpacity() {
        return Float.valueOf(this.jsonObject.get("icon-opacity").getAsFloat());
    }

    public Float getIconRotate() {
        return Float.valueOf(this.jsonObject.get("icon-rotate").getAsFloat());
    }

    public Float getIconSize() {
        return Float.valueOf(this.jsonObject.get("icon-size").getAsFloat());
    }

    public LatLng getLatLng() {
        return new LatLng(((Point)this.geometry).latitude(), ((Point)this.geometry).longitude());
    }

    @Override
    String getName() {
        return "Symbol";
    }

    @Override
    Geometry getOffsetGeometry(Projection object, MoveDistancesObject moveDistancesObject, float f, float f2) {
        if (!(((LatLng)(object = ((Projection)object).fromScreenLocation(new PointF(moveDistancesObject.getCurrentX() - f, moveDistancesObject.getCurrentY() - f2)))).getLatitude() > 85.05112877980659) && !(((LatLng)object).getLatitude() < -85.05112877980659)) {
            return Point.fromLngLat(((LatLng)object).getLongitude(), ((LatLng)object).getLatitude());
        }
        return null;
    }

    public Float getSymbolSortKey() {
        return Float.valueOf(this.jsonObject.get("symbol-sort-key").getAsFloat());
    }

    public String getTextAnchor() {
        return this.jsonObject.get("text-anchor").getAsString();
    }

    public String getTextColor() {
        return this.jsonObject.get("text-color").getAsString();
    }

    public int getTextColorAsInt() {
        return ColorUtils.rgbaToColor(this.jsonObject.get("text-color").getAsString());
    }

    public String getTextField() {
        return this.jsonObject.get("text-field").getAsString();
    }

    public String[] getTextFont() {
        JsonArray jsonArray = this.jsonObject.getAsJsonArray("text-font");
        String[] stringArray = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            stringArray[i] = jsonArray.get(i).getAsString();
        }
        return stringArray;
    }

    public Float getTextHaloBlur() {
        return Float.valueOf(this.jsonObject.get("text-halo-blur").getAsFloat());
    }

    public String getTextHaloColor() {
        return this.jsonObject.get("text-halo-color").getAsString();
    }

    public int getTextHaloColorAsInt() {
        return ColorUtils.rgbaToColor(this.jsonObject.get("text-halo-color").getAsString());
    }

    public Float getTextHaloWidth() {
        return Float.valueOf(this.jsonObject.get("text-halo-width").getAsFloat());
    }

    public String getTextJustify() {
        return this.jsonObject.get("text-justify").getAsString();
    }

    public Float getTextLetterSpacing() {
        return Float.valueOf(this.jsonObject.get("text-letter-spacing").getAsFloat());
    }

    public Float getTextMaxWidth() {
        return Float.valueOf(this.jsonObject.get("text-max-width").getAsFloat());
    }

    public PointF getTextOffset() {
        JsonArray jsonArray = this.jsonObject.getAsJsonArray("text-offset");
        return new PointF(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat());
    }

    public Float getTextOpacity() {
        return Float.valueOf(this.jsonObject.get("text-opacity").getAsFloat());
    }

    public Float getTextRadialOffset() {
        return Float.valueOf(this.jsonObject.get("text-radial-offset").getAsFloat());
    }

    public Float getTextRotate() {
        return Float.valueOf(this.jsonObject.get("text-rotate").getAsFloat());
    }

    public Float getTextSize() {
        return Float.valueOf(this.jsonObject.get("text-size").getAsFloat());
    }

    public String getTextTransform() {
        return this.jsonObject.get("text-transform").getAsString();
    }

    public void setIconAnchor(String string2) {
        this.jsonObject.addProperty("icon-anchor", string2);
    }

    public void setIconColor(int n) {
        this.jsonObject.addProperty("icon-color", ColorUtils.colorToRgbaString(n));
    }

    public void setIconColor(String string2) {
        this.jsonObject.addProperty("icon-color", string2);
    }

    public void setIconHaloBlur(Float f) {
        this.jsonObject.addProperty("icon-halo-blur", f);
    }

    public void setIconHaloColor(int n) {
        this.jsonObject.addProperty("icon-halo-color", ColorUtils.colorToRgbaString(n));
    }

    public void setIconHaloColor(String string2) {
        this.jsonObject.addProperty("icon-halo-color", string2);
    }

    public void setIconHaloWidth(Float f) {
        this.jsonObject.addProperty("icon-halo-width", f);
    }

    public void setIconImage(String string2) {
        this.jsonObject.addProperty("icon-image", string2);
    }

    public void setIconOffset(PointF pointF) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(Float.valueOf(pointF.x));
        jsonArray.add(Float.valueOf(pointF.y));
        this.jsonObject.add("icon-offset", jsonArray);
    }

    public void setIconOpacity(Float f) {
        this.jsonObject.addProperty("icon-opacity", f);
    }

    public void setIconRotate(Float f) {
        this.jsonObject.addProperty("icon-rotate", f);
    }

    public void setIconSize(Float f) {
        this.jsonObject.addProperty("icon-size", f);
    }

    public void setLatLng(LatLng latLng) {
        this.geometry = Point.fromLngLat(latLng.getLongitude(), latLng.getLatitude());
    }

    public void setSymbolSortKey(Float f) {
        this.jsonObject.addProperty("symbol-sort-key", f);
    }

    public void setTextAnchor(String string2) {
        this.jsonObject.addProperty("text-anchor", string2);
    }

    public void setTextColor(int n) {
        this.jsonObject.addProperty("text-color", ColorUtils.colorToRgbaString(n));
    }

    public void setTextColor(String string2) {
        this.jsonObject.addProperty("text-color", string2);
    }

    public void setTextField(String string2) {
        this.jsonObject.addProperty("text-field", string2);
    }

    public void setTextFont(String[] stringArray) {
        JsonArray jsonArray = new JsonArray();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            jsonArray.add(stringArray[i]);
        }
        this.jsonObject.add("text-font", jsonArray);
    }

    public void setTextHaloBlur(Float f) {
        this.jsonObject.addProperty("text-halo-blur", f);
    }

    public void setTextHaloColor(int n) {
        this.jsonObject.addProperty("text-halo-color", ColorUtils.colorToRgbaString(n));
    }

    public void setTextHaloColor(String string2) {
        this.jsonObject.addProperty("text-halo-color", string2);
    }

    public void setTextHaloWidth(Float f) {
        this.jsonObject.addProperty("text-halo-width", f);
    }

    public void setTextJustify(String string2) {
        this.jsonObject.addProperty("text-justify", string2);
    }

    public void setTextLetterSpacing(Float f) {
        this.jsonObject.addProperty("text-letter-spacing", f);
    }

    public void setTextMaxWidth(Float f) {
        this.jsonObject.addProperty("text-max-width", f);
    }

    public void setTextOffset(PointF pointF) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(Float.valueOf(pointF.x));
        jsonArray.add(Float.valueOf(pointF.y));
        this.jsonObject.add("text-offset", jsonArray);
    }

    public void setTextOpacity(Float f) {
        this.jsonObject.addProperty("text-opacity", f);
    }

    public void setTextRadialOffset(Float f) {
        this.jsonObject.addProperty("text-radial-offset", f);
    }

    public void setTextRotate(Float f) {
        this.jsonObject.addProperty("text-rotate", f);
    }

    public void setTextSize(Float f) {
        this.jsonObject.addProperty("text-size", f);
    }

    public void setTextTransform(String string2) {
        this.jsonObject.addProperty("text-transform", string2);
    }

    @Override
    void setUsedDataDrivenProperties() {
        if (!(this.jsonObject.get("symbol-sort-key") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("symbol-sort-key");
        }
        if (!(this.jsonObject.get("icon-size") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-size");
        }
        if (!(this.jsonObject.get("icon-image") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-image");
        }
        if (!(this.jsonObject.get("icon-rotate") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-rotate");
        }
        if (!(this.jsonObject.get("icon-offset") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-offset");
        }
        if (!(this.jsonObject.get("icon-anchor") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-anchor");
        }
        if (!(this.jsonObject.get("text-field") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-field");
        }
        if (!(this.jsonObject.get("text-font") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-font");
        }
        if (!(this.jsonObject.get("text-size") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-size");
        }
        if (!(this.jsonObject.get("text-max-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-max-width");
        }
        if (!(this.jsonObject.get("text-letter-spacing") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-letter-spacing");
        }
        if (!(this.jsonObject.get("text-justify") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-justify");
        }
        if (!(this.jsonObject.get("text-radial-offset") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-radial-offset");
        }
        if (!(this.jsonObject.get("text-anchor") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-anchor");
        }
        if (!(this.jsonObject.get("text-rotate") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-rotate");
        }
        if (!(this.jsonObject.get("text-transform") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-transform");
        }
        if (!(this.jsonObject.get("text-offset") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-offset");
        }
        if (!(this.jsonObject.get("icon-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-opacity");
        }
        if (!(this.jsonObject.get("icon-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-color");
        }
        if (!(this.jsonObject.get("icon-halo-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-halo-color");
        }
        if (!(this.jsonObject.get("icon-halo-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-halo-width");
        }
        if (!(this.jsonObject.get("icon-halo-blur") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-halo-blur");
        }
        if (!(this.jsonObject.get("text-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-opacity");
        }
        if (!(this.jsonObject.get("text-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-color");
        }
        if (!(this.jsonObject.get("text-halo-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-halo-color");
        }
        if (!(this.jsonObject.get("text-halo-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-halo-width");
        }
        if (!(this.jsonObject.get("text-halo-blur") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-halo-blur");
        }
    }
}

