/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.localization;

import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.localization.MapLocale;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.style.sources.VectorSource;
import com.mapbox.mapboxsdk.style.types.Formatted;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import timber.log.Timber;

public final class LocalizationPlugin {
    private static final String EXPRESSION_REGEX = "\\b(name|name_.{2,7})\\b";
    private static final String EXPRESSION_V8_REGEX_BASE = "\\[\"get\", \"name_en\"], \\[\"get\", \"name\"]";
    private static final String EXPRESSION_V8_REGEX_LOCALIZED = "\\[\"match\", \"(name|name_.{2,7})\", \"name_zh-Hant\", \\[\"coalesce\", \\[\"get\", \"name_zh-Hant\"], \\[\"get\", \"name_zh-Hans\"], \\[\"match\", \\[\"get\", \"name_script\"], \"Latin\", \\[\"get\", \"name\"], \\[\"get\", \"name_en\"]], \\[\"get\", \"name\"]], \\[\"coalesce\", \\[\"get\", \"(name|name_.{2,7})\"], \\[\"match\", \\[\"get\", \"name_script\"], \"Latin\", \\[\"get\", \"name\"], \\[\"get\", \"name_en\"]], \\[\"get\", \"name\"]]]";
    private static final String EXPRESSION_V8_TEMPLATE_BASE = "[\"get\", \"name_en\"], [\"get\", \"name\"]";
    private static final String EXPRESSION_V8_TEMPLATE_LOCALIZED = "[\"match\", \"%s\", \"name_zh-Hant\", [\"coalesce\", [\"get\", \"name_zh-Hant\"], [\"get\", \"name_zh-Hans\"], [\"match\", [\"get\", \"name_script\"], \"Latin\", [\"get\", \"name\"], [\"get\", \"name_en\"]], [\"get\", \"name\"]], [\"coalesce\", [\"get\", \"%s\"], [\"match\", [\"get\", \"name_script\"], \"Latin\", [\"get\", \"name\"], [\"get\", \"name_en\"]], [\"get\", \"name\"]]]";
    private static final String STEP_REGEX = "\\[\"zoom\"], ";
    private static final String STEP_TEMPLATE = "[\"zoom\"], \"\", ";
    private static final List<String> SUPPORTED_SOURCES;
    private MapLocale mapLocale;
    private final MapboxMap mapboxMap;
    private Style style;

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        SUPPORTED_SOURCES = arrayList;
        arrayList.add("mapbox.mapbox-streets-v6");
        arrayList.add("mapbox.mapbox-streets-v7");
        arrayList.add("mapbox.mapbox-streets-v8");
    }

    public LocalizationPlugin(MapView mapView, final MapboxMap mapboxMap, Style style2) {
        this.mapboxMap = mapboxMap;
        this.style = style2;
        if (style2.isFullyLoaded()) {
            mapView.addOnDidFinishLoadingStyleListener(new MapView.OnDidFinishLoadingStyleListener(){

                @Override
                public void onDidFinishLoadingStyle() {
                    mapboxMap.getStyle(new Style.OnStyleLoaded(){

                        @Override
                        public void onStyleLoaded(Style style2) {
                            LocalizationPlugin.access$002(LocalizationPlugin.this, style2);
                            if (LocalizationPlugin.this.mapLocale != null) {
                                LocalizationPlugin.this.setMapLanguage(LocalizationPlugin.this.mapLocale);
                            }
                        }
                    });
                }
            });
            return;
        }
        throw new RuntimeException("The style has to be non-null and fully loaded.");
    }

    static /* synthetic */ Style access$002(LocalizationPlugin localizationPlugin, Style style2) {
        localizationPlugin.style = style2;
        return style2;
    }

    private void convertExpression(MapLocale object, Layer layer, PropertyValue<?> object2, boolean bl) {
        Expression expression = ((PropertyValue)object2).getExpression();
        if (expression != null) {
            object2 = object;
            if (((MapLocale)object).getMapLanguage().startsWith("name_zh")) {
                object2 = this.getChineseMapLocale((MapLocale)object, bl);
                Timber.d((String)"reset mapLocale to: %s", (Object[])new Object[]{((MapLocale)object2).getMapLanguage()});
            }
            object = object2 = expression.toString().replaceAll(EXPRESSION_REGEX, ((MapLocale)object2).getMapLanguage());
            if (((String)object2).startsWith("[\"step")) {
                object = object2;
                if (expression.toArray().length % 2 == 0) {
                    object = ((String)object2).replaceAll(STEP_REGEX, STEP_TEMPLATE);
                }
            }
            layer.setProperties(PropertyFactory.textField(Expression.raw((String)object)));
        }
    }

    private void convertExpressionV8(MapLocale object, Layer layer, PropertyValue<?> object2) {
        if ((object2 = ((PropertyValue)object2).getExpression()) != null) {
            object2 = ((Expression)object2).toString().replaceAll(EXPRESSION_V8_REGEX_LOCALIZED, EXPRESSION_V8_TEMPLATE_BASE);
            String string2 = ((MapLocale)object).getMapLanguage();
            object = object2;
            if (!string2.equals("name_en")) {
                object = string2;
                if (string2.equals("name_zh")) {
                    object = "name_zh-Hans";
                }
                object = ((String)object2).replaceAll(EXPRESSION_V8_REGEX_BASE, String.format(Locale.US, EXPRESSION_V8_TEMPLATE_LOCALIZED, object, object));
            }
            layer.setProperties(PropertyFactory.textField(Expression.raw((String)object)));
        }
    }

    private MapLocale getChineseMapLocale(MapLocale mapLocale, boolean bl) {
        if (bl) {
            if (mapLocale.equals(MapLocale.CHINESE_HANS)) {
                return mapLocale;
            }
            return MapLocale.CHINA;
        }
        return MapLocale.CHINA;
    }

    private boolean sourceIsFromMapbox(Source object) {
        if (object instanceof VectorSource && (object = ((VectorSource)object).getUrl()) != null) {
            Iterator<String> iterator2 = SUPPORTED_SOURCES.iterator();
            while (iterator2.hasNext()) {
                if (!((String)object).contains(iterator2.next())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean sourceIsStreetsV7(Source object) {
        boolean bl;
        boolean bl2 = object instanceof VectorSource;
        boolean bl3 = bl = false;
        if (bl2) {
            object = ((VectorSource)object).getUrl();
            bl3 = bl;
            if (object != null) {
                bl3 = bl;
                if (((String)object).contains("mapbox.mapbox-streets-v7")) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    private boolean sourceIsStreetsV8(Source object) {
        boolean bl;
        boolean bl2 = object instanceof VectorSource;
        boolean bl3 = bl = false;
        if (bl2) {
            object = ((VectorSource)object).getUrl();
            bl3 = bl;
            if (object != null) {
                bl3 = bl;
                if (((String)object).contains("mapbox.mapbox-streets-v8")) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    public void matchMapLanguageWithDeviceDefault() {
        this.setMapLanguage(Locale.getDefault(), false);
    }

    public void matchMapLanguageWithDeviceDefault(boolean bl) {
        this.setMapLanguage(Locale.getDefault(), bl);
    }

    public void setCameraToLocaleCountry(int n) {
        this.setCameraToLocaleCountry(Locale.getDefault(), n);
    }

    public void setCameraToLocaleCountry(MapLocale object, int n) {
        object = ((MapLocale)object).getCountryBounds();
        Objects.requireNonNull(object, "Expected a LatLngBounds object but received null instead. Make sure your MapLocale instance also has a country bounding box defined.");
        this.mapboxMap.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)object, n));
    }

    public void setCameraToLocaleCountry(Locale locale, int n) {
        MapLocale mapLocale = MapLocale.getMapLocale(locale, false);
        if (mapLocale != null) {
            this.setCameraToLocaleCountry(mapLocale, n);
        } else {
            Timber.d((String)"Couldn't match Locale %s to a MapLocale", (Object[])new Object[]{locale.getDisplayName()});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMapLanguage(MapLocale mapLocale) {
        this.mapLocale = mapLocale;
        if (!this.style.isFullyLoaded()) {
            return;
        }
        List<Layer> list = this.style.getLayers();
        for (Source source : this.style.getSources()) {
            void var7_11;
            if (this.sourceIsFromMapbox(source)) {
                boolean bl = this.sourceIsStreetsV8(source);
                for (Layer layer : list) {
                    PropertyValue<Formatted> propertyValue;
                    if (!(layer instanceof SymbolLayer) || !(propertyValue = ((SymbolLayer)layer).getTextField()).isExpression()) continue;
                    if (bl) {
                        this.convertExpressionV8(mapLocale, layer, propertyValue);
                        continue;
                    }
                    this.convertExpression(mapLocale, layer, propertyValue, this.sourceIsStreetsV7(source));
                }
                continue;
            }
            Object object3 = null;
            if (source instanceof VectorSource) {
                object3 = ((VectorSource)source).getUrl();
            }
            Iterator<Layer> iterator2 = object3;
            if (object3 == null) {
                String string2 = "not found";
            }
            Timber.d((String)"The %s (%s) source is not based on Mapbox Vector Tiles. Supported sources:\n %s", (Object[])new Object[]{source.getId(), var7_11, SUPPORTED_SOURCES});
        }
    }

    public void setMapLanguage(String string2) {
        this.setMapLanguage(new MapLocale(string2));
    }

    public void setMapLanguage(Locale locale) {
        this.setMapLanguage(locale, false);
    }

    public void setMapLanguage(Locale locale, boolean bl) {
        MapLocale mapLocale = MapLocale.getMapLocale(locale, bl);
        if (mapLocale != null) {
            Timber.d((String)"Locale: %s, set MapLocale: %s", (Object[])new Object[]{locale.toString(), mapLocale.getMapLanguage()});
            this.setMapLanguage(mapLocale);
        } else {
            Timber.d((String)"Couldn't match Locale %s %s to a MapLocale", (Object[])new Object[]{locale.toString(), locale.getDisplayName()});
        }
    }
}

