/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.markerview;

import android.graphics.PointF;
import android.view.View;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.Projection;

public class MarkerView {
    private LatLng latLng;
    private OnPositionUpdateListener onPositionUpdateListener;
    private Projection projection;
    private final View view;

    public MarkerView(LatLng latLng, View view) {
        this.latLng = latLng;
        this.view = view;
    }

    View getView() {
        return this.view;
    }

    public void setLatLng(LatLng latLng) {
        this.latLng = latLng;
        this.update();
    }

    public void setOnPositionUpdateListener(OnPositionUpdateListener onPositionUpdateListener) {
        this.onPositionUpdateListener = onPositionUpdateListener;
    }

    void setProjection(Projection projection) {
        this.projection = projection;
    }

    void update() {
        PointF pointF = this.projection.toScreenLocation(this.latLng);
        OnPositionUpdateListener onPositionUpdateListener = this.onPositionUpdateListener;
        PointF pointF2 = pointF;
        if (onPositionUpdateListener != null) {
            pointF2 = onPositionUpdateListener.onUpdate(pointF);
        }
        this.view.setX(pointF2.x);
        this.view.setY(pointF2.y);
    }

    public static interface OnPositionUpdateListener {
        public PointF onUpdate(PointF var1);
    }
}

