/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.snapshotter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.os.Handler;
import android.text.Html;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.core.content.res.ResourcesCompat;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.attribution.AttributionLayout;
import com.mapbox.mapboxsdk.attribution.AttributionMeasure;
import com.mapbox.mapboxsdk.attribution.AttributionParser;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.GlyphsRasterizationMode;
import com.mapbox.mapboxsdk.maps.Image;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.snapshotter.MapSnapshot;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.FontUtils;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

public class MapSnapshotter {
    private static final int LOGO_MARGIN_DP = 4;
    private static final String TAG = "Mbgl-MapSnapshotter";
    private SnapshotReadyCallback callback;
    private final Context context;
    private ErrorHandler errorHandler;
    private boolean fullyLoaded = false;
    private long nativePtr = 0L;
    private Observer observer;
    private Options options;

    public MapSnapshotter(Context object, Options options) {
        this.checkThread();
        this.context = object.getApplicationContext();
        this.options = options;
        Object object2 = Mapbox.getTelemetry();
        if (object2 != null) {
            object2.onAppUserTurnstileEvent();
        }
        object2 = FileSource.getInstance(object);
        object = options.getApiBaseUrl();
        if (!TextUtils.isEmpty((CharSequence)object)) {
            ((FileSource)object2).setApiBaseUrl((String)object);
        }
        this.nativeInitialize(this, (FileSource)object2, options.pixelRatio, options.width, options.height, options.getStyleUri(), options.getStyleJson(), options.region, options.cameraPosition, options.showLogo, options.glyphsRasterizationMode.ordinal(), options.localIdeographFontFamily);
    }

    private void addLayerAbove(Layer layer, String string2) {
        this.nativeAddLayerAbove(layer.getNativePtr(), string2);
    }

    private void addLayerAt(Layer layer, int n) {
        this.nativeAddLayerAt(layer.getNativePtr(), n);
    }

    private void addLayerBelow(Layer layer, String string2) {
        this.nativeAddLayerBelow(layer.getNativePtr(), string2);
    }

    private void addSource(Source source) {
        this.nativeAddSource(source, source.getNativePtr());
    }

    private float calculateLogoScale(Bitmap bitmap, Bitmap bitmap2) {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        float f = displayMetrics.widthPixels / bitmap.getWidth();
        float f2 = displayMetrics.heightPixels / bitmap.getHeight();
        f = (float)bitmap2.getWidth() / f;
        f2 = (float)bitmap2.getHeight() / f2;
        if ((f = Math.min(f / (float)bitmap2.getWidth(), f2 / (float)bitmap2.getHeight()) * 2.0f) > 1.0f) {
            f2 = 1.0f;
        } else {
            f2 = f;
            if (f < 0.6f) {
                f2 = 0.6f;
            }
        }
        return f2;
    }

    private void checkThread() {
        ThreadUtils.checkThread(TAG);
    }

    private String createAttributionString(MapSnapshot mapSnapshot, boolean bl) {
        return new AttributionParser.Options(this.context).withAttributionData(mapSnapshot.getAttributions()).withCopyrightSign(false).withImproveMap(false).build().createAttributionString(bl);
    }

    private Logo createScaledLogo(Bitmap bitmap) {
        Bitmap bitmap2 = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.mapbox_logo_icon, null);
        float f = this.calculateLogoScale(bitmap, bitmap2);
        bitmap = new Matrix();
        bitmap.postScale(f, f);
        Bitmap bitmap3 = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.mapbox_logo_helmet, null);
        return new Logo(Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Matrix)bitmap, (boolean)true), Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)bitmap3.getWidth(), (int)bitmap3.getHeight(), (Matrix)bitmap, (boolean)true), f);
    }

    private TextView createTextView(MapSnapshot mapSnapshot, boolean bl, float f) {
        int n = ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.mapbox_gray_dark, (Resources.Theme)this.context.getTheme());
        int n2 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int n3 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        TextView textView = new TextView(this.context);
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        textView.setSingleLine(true);
        textView.setTextSize(f * 10.0f);
        textView.setTextColor(n);
        textView.setBackgroundResource(R.drawable.mapbox_rounded_corner);
        textView.setText((CharSequence)Html.fromHtml((String)this.createAttributionString(mapSnapshot, bl)));
        textView.measure(n2, n3);
        textView.layout(0, 0, textView.getMeasuredWidth(), textView.getMeasuredHeight());
        return textView;
    }

    private void drawAttribution(Canvas canvas, AttributionMeasure attributionMeasure, PointF pointF) {
        canvas.save();
        canvas.translate(pointF.x, pointF.y);
        attributionMeasure.getTextView().draw(canvas);
        canvas.restore();
    }

    private void drawAttribution(MapSnapshot mapSnapshot, Canvas canvas, AttributionMeasure attributionMeasure, AttributionLayout attributionLayout) {
        if ((attributionLayout = attributionLayout.getAnchorPoint()) != null) {
            this.drawAttribution(canvas, attributionMeasure, (PointF)attributionLayout);
        } else {
            canvas = mapSnapshot.getBitmap();
            Logger.e(TAG, String.format("Could not generate attribution for snapshot size: %s x %s. You are required to provide your own attribution for the used sources: %s", canvas.getWidth(), canvas.getHeight(), mapSnapshot.getAttributions()));
        }
    }

    private void drawLogo(Bitmap bitmap, Canvas canvas, int n, AttributionLayout attributionLayout) {
        if ((attributionLayout = attributionLayout.getLogo()) != null) {
            canvas.drawBitmap((Bitmap)attributionLayout, (float)n, (float)(bitmap.getHeight() - attributionLayout.getHeight() - n), null);
        }
    }

    private void drawLogo(MapSnapshot mapSnapshot, Canvas canvas, int n, AttributionLayout attributionLayout) {
        if (mapSnapshot.isShowLogo()) {
            this.drawLogo(mapSnapshot.getBitmap(), canvas, n, attributionLayout);
        }
    }

    private void drawOverlay(MapSnapshot mapSnapshot, Bitmap object, Canvas canvas, int n) {
        object = this.getAttributionMeasure(mapSnapshot, (Bitmap)object, n);
        AttributionLayout attributionLayout = ((AttributionMeasure)object).measure();
        this.drawLogo(mapSnapshot, canvas, n, attributionLayout);
        this.drawAttribution(mapSnapshot, canvas, (AttributionMeasure)object, attributionLayout);
    }

    private AttributionMeasure getAttributionMeasure(MapSnapshot mapSnapshot, Bitmap bitmap, int n) {
        Logo logo = this.createScaledLogo(bitmap);
        TextView textView = this.createTextView(mapSnapshot, false, logo.getScale());
        mapSnapshot = this.createTextView(mapSnapshot, true, logo.getScale());
        return new AttributionMeasure.Builder().setSnapshot(bitmap).setLogo(logo.getLarge()).setLogoSmall(logo.getSmall()).setTextView(textView).setTextViewShort((TextView)mapSnapshot).setMarginPadding(n).build();
    }

    private native void nativeAddImages(Image[] var1);

    private native void nativeAddLayerAbove(long var1, String var3);

    private native void nativeAddLayerAt(long var1, int var3);

    private native void nativeAddLayerBelow(long var1, String var3);

    private native void nativeAddSource(Source var1, long var2);

    private native Layer nativeGetLayer(String var1);

    private native Source nativeGetSource(String var1);

    public void addImage(String string2, Bitmap bitmap, boolean bl) {
        this.nativeAddImages(new Image[]{Style.toImage(new Style.Builder.ImageWrapper(string2, bitmap, bl))});
    }

    protected void addOverlay(MapSnapshot mapSnapshot) {
        Bitmap bitmap = mapSnapshot.getBitmap();
        this.drawOverlay(mapSnapshot, bitmap, new Canvas(bitmap), (int)this.context.getResources().getDisplayMetrics().density * 4);
    }

    public void cancel() {
        this.checkThread();
        this.reset();
        this.nativeCancel();
    }

    protected native void finalize() throws Throwable;

    public Layer getLayer(String object) {
        this.checkThread();
        object = this.fullyLoaded ? this.nativeGetLayer((String)object) : null;
        return object;
    }

    public Source getSource(String object) {
        this.checkThread();
        object = this.fullyLoaded ? this.nativeGetSource((String)object) : null;
        return object;
    }

    protected native void nativeCancel();

    protected native void nativeInitialize(MapSnapshotter var1, FileSource var2, float var3, int var4, int var5, String var6, String var7, LatLngBounds var8, CameraPosition var9, boolean var10, int var11, String var12);

    protected native void nativeStart();

    protected void onDidFailLoadingStyle(String string2) {
        this.onSnapshotFailed(string2);
    }

    protected void onDidFinishLoadingStyle() {
        Observer observer;
        if (!this.fullyLoaded) {
            this.fullyLoaded = true;
            Style.Builder object3 = this.options.getBuilder();
            if (object3 != null) {
                for (Source source : object3.getSources()) {
                    this.nativeAddSource(source, source.getNativePtr());
                }
                for (Style.Builder.LayerWrapper layerWrapper : object3.getLayers()) {
                    if (layerWrapper instanceof Style.Builder.LayerAtWrapper) {
                        this.addLayerAt(layerWrapper.getLayer(), ((Style.Builder.LayerAtWrapper)layerWrapper).getIndex());
                        continue;
                    }
                    if (layerWrapper instanceof Style.Builder.LayerAboveWrapper) {
                        this.addLayerAbove(layerWrapper.getLayer(), ((Style.Builder.LayerAboveWrapper)layerWrapper).getAboveLayer());
                        continue;
                    }
                    if (layerWrapper instanceof Style.Builder.LayerBelowWrapper) {
                        this.addLayerBelow(layerWrapper.getLayer(), ((Style.Builder.LayerBelowWrapper)layerWrapper).getBelowLayer());
                        continue;
                    }
                    this.addLayerBelow(layerWrapper.getLayer(), "com.mapbox.annotations.points");
                }
                for (Style.Builder.ImageWrapper imageWrapper : object3.getImages()) {
                    this.addImage(imageWrapper.getId(), imageWrapper.getBitmap(), imageWrapper.isSdf());
                }
            }
        }
        if ((observer = this.observer) != null) {
            observer.onDidFinishLoadingStyle();
        }
    }

    protected void onSnapshotFailed(final String string2) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                if (MapSnapshotter.this.errorHandler != null) {
                    MapSnapshotter.this.errorHandler.onError(string2);
                    MapSnapshotter.this.reset();
                }
            }
        });
    }

    protected void onSnapshotReady(final MapSnapshot mapSnapshot) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                if (MapSnapshotter.this.callback != null) {
                    MapSnapshotter.this.addOverlay(mapSnapshot);
                    MapSnapshotter.this.callback.onSnapshotReady(mapSnapshot);
                    MapSnapshotter.this.reset();
                }
            }
        });
    }

    protected void onStyleImageMissing(String string2) {
        Observer observer = this.observer;
        if (observer != null) {
            observer.onStyleImageMissing(string2);
        }
    }

    protected void reset() {
        this.callback = null;
        this.errorHandler = null;
    }

    public native void setCameraPosition(CameraPosition var1);

    public void setObserver(Observer observer) {
        this.checkThread();
        this.observer = observer;
    }

    public native void setRegion(LatLngBounds var1);

    public native void setSize(int var1, int var2);

    public native void setStyleJson(String var1);

    public native void setStyleUrl(String var1);

    public void start(SnapshotReadyCallback snapshotReadyCallback) {
        this.start(snapshotReadyCallback, null);
    }

    public void start(SnapshotReadyCallback snapshotReadyCallback, ErrorHandler errorHandler) {
        if (this.callback == null) {
            this.checkThread();
            this.callback = snapshotReadyCallback;
            this.errorHandler = errorHandler;
            this.nativeStart();
            return;
        }
        throw new IllegalStateException("Snapshotter was already started");
    }

    public static interface ErrorHandler {
        public void onError(String var1);
    }

    private class Logo {
        private Bitmap large;
        private float scale;
        private Bitmap small;

        Logo(Bitmap bitmap, Bitmap bitmap2, float f) {
            this.large = bitmap;
            this.small = bitmap2;
            this.scale = f;
        }

        public Bitmap getLarge() {
            return this.large;
        }

        public float getScale() {
            return this.scale;
        }

        public Bitmap getSmall() {
            return this.small;
        }
    }

    public static interface Observer {
        public void onDidFinishLoadingStyle();

        public void onStyleImageMissing(String var1);
    }

    public static class Options {
        private String apiBaseUrl;
        private Style.Builder builder;
        private CameraPosition cameraPosition;
        private GlyphsRasterizationMode glyphsRasterizationMode = GlyphsRasterizationMode.IDEOGRAPHS_RASTERIZED_LOCALLY;
        private int height;
        private String localIdeographFontFamily = "sans-serif";
        private float pixelRatio = 1.0f;
        private LatLngBounds region;
        private boolean showLogo = true;
        private int width;

        public Options(int n, int n2) {
            if (n != 0 && n2 != 0) {
                this.width = n;
                this.height = n2;
                return;
            }
            throw new IllegalArgumentException("Unable to create a snapshot with width or height set to 0");
        }

        public String getApiBaseUri() {
            return this.apiBaseUrl;
        }

        @Deprecated
        public String getApiBaseUrl() {
            return this.apiBaseUrl;
        }

        public Style.Builder getBuilder() {
            return this.builder;
        }

        public CameraPosition getCameraPosition() {
            return this.cameraPosition;
        }

        public int getHeight() {
            return this.height;
        }

        public String getLocalIdeographFontFamily() {
            return this.localIdeographFontFamily;
        }

        public float getPixelRatio() {
            return this.pixelRatio;
        }

        public LatLngBounds getRegion() {
            return this.region;
        }

        public String getStyleJson() {
            Object object = this.builder;
            object = object == null ? null : ((Style.Builder)object).getJson();
            return object;
        }

        public String getStyleUri() {
            Object object = this.builder;
            object = object == null ? "mapbox://styles/mapbox/streets-v11" : ((Style.Builder)object).getUri();
            return object;
        }

        @Deprecated
        public String getStyleUrl() {
            Object object = this.builder;
            object = object == null ? "mapbox://styles/mapbox/streets-v11" : ((Style.Builder)object).getUri();
            return object;
        }

        public int getWidth() {
            return this.width;
        }

        public Options withApiBaseUri(String string2) {
            this.apiBaseUrl = string2;
            return this;
        }

        @Deprecated
        public Options withApiBaseUrl(String string2) {
            this.apiBaseUrl = string2;
            return this;
        }

        public Options withCameraPosition(CameraPosition cameraPosition) {
            this.cameraPosition = cameraPosition;
            return this;
        }

        public Options withGlyphsRasterizationMode(GlyphsRasterizationMode glyphsRasterizationMode) {
            this.glyphsRasterizationMode = glyphsRasterizationMode;
            return this;
        }

        public Options withLocalIdeographFontFamily(String string2) {
            this.localIdeographFontFamily = FontUtils.extractValidFont(string2);
            return this;
        }

        public Options withLocalIdeographFontFamily(String ... stringArray) {
            this.localIdeographFontFamily = FontUtils.extractValidFont(stringArray);
            return this;
        }

        public Options withLogo(boolean bl) {
            this.showLogo = bl;
            return this;
        }

        public Options withPixelRatio(float f) {
            this.pixelRatio = f;
            return this;
        }

        public Options withRegion(LatLngBounds latLngBounds) {
            this.region = latLngBounds;
            return this;
        }

        public Options withStyle(String string2) {
            this.withStyleBuilder(new Style.Builder().fromUri(string2));
            return this;
        }

        public Options withStyleBuilder(Style.Builder builder) {
            this.builder = builder;
            return this;
        }

        public Options withStyleJson(String string2) {
            this.withStyleBuilder(new Style.Builder().fromJson(string2));
            return this;
        }
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(MapSnapshot var1);
    }
}

