/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.storage;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Environment;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.utils.FileUtils;
import com.mapbox.mapboxsdk.utils.ThreadUtils;
import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FileSource {
    private static FileSource INSTANCE;
    private static final String MAPBOX_SHARED_PREFERENCE_RESOURCES_CACHE_PATH = "fileSourceResourcesCachePath";
    private static final String TAG = "Mbgl-FileSource";
    private static String internalCachePath;
    private static final Lock internalCachePathLoaderLock;
    private static String resourcesCachePath;
    private static final Lock resourcesCachePathLoaderLock;
    private long nativePtr;

    static {
        resourcesCachePathLoaderLock = new ReentrantLock();
        internalCachePathLoaderLock = new ReentrantLock();
    }

    private FileSource(String string2) {
        this.initialize(Mapbox.getAccessToken(), string2);
    }

    static /* synthetic */ String access$302(String string2) {
        resourcesCachePath = string2;
        return string2;
    }

    static /* synthetic */ String access$402(String string2) {
        internalCachePath = string2;
        return string2;
    }

    private static String getCachePath(Context context) {
        String string2;
        String string3 = string2 = context.getSharedPreferences("MapboxSharedPreferences", 0).getString(MAPBOX_SHARED_PREFERENCE_RESOURCES_CACHE_PATH, null);
        if (!FileSource.isPathWritable(string2)) {
            string3 = FileSource.getDefaultCachePath(context);
            context.getSharedPreferences("MapboxSharedPreferences", 0).edit().remove(MAPBOX_SHARED_PREFERENCE_RESOURCES_CACHE_PATH).apply();
        }
        return string3;
    }

    private static String getDefaultCachePath(Context context) {
        File file;
        if (FileSource.isExternalStorageConfiguration(context) && FileSource.isExternalStorageReadable() && (file = context.getExternalFilesDir(null)) != null) {
            return file.getAbsolutePath();
        }
        return context.getFilesDir().getAbsolutePath();
    }

    public static FileSource getInstance(Context object) {
        synchronized (FileSource.class) {
            if (INSTANCE == null) {
                FileSource fileSource;
                INSTANCE = fileSource = new FileSource(FileSource.getResourcesCachePath(object));
            }
            object = INSTANCE;
            return object;
        }
    }

    public static String getInternalCachePath(Context object) {
        Lock lock = internalCachePathLoaderLock;
        lock.lock();
        try {
            if (internalCachePath == null) {
                internalCachePath = object.getCacheDir().getAbsolutePath();
            }
            object = internalCachePath;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            internalCachePathLoaderLock.unlock();
            throw throwable;
        }
    }

    public static String getResourcesCachePath(Context object) {
        Lock lock = resourcesCachePathLoaderLock;
        lock.lock();
        try {
            if (resourcesCachePath == null) {
                resourcesCachePath = FileSource.getCachePath(object);
            }
            object = resourcesCachePath;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            resourcesCachePathLoaderLock.unlock();
            throw throwable;
        }
    }

    private native void initialize(String var1, String var2);

    public static void initializeFileDirsPaths(Context context) {
        ThreadUtils.checkThread(TAG);
        FileSource.lockPathLoaders();
        if (resourcesCachePath == null || internalCachePath == null) {
            new FileDirsPathsTask().execute(new Context[]{context});
        }
    }

    private static void internalSetResourcesCachePath(Context object, String string2, ResourcesCachePathChangeCallback resourcesCachePathChangeCallback) {
        final boolean bl = ((FileSource)(object = FileSource.getInstance((Context)object))).isActivated();
        if (!bl) {
            ((FileSource)object).activate();
        }
        super.setResourceCachePath(string2, new ResourcesCachePathChangeCallback((FileSource)object, resourcesCachePathChangeCallback){
            final /* synthetic */ ResourcesCachePathChangeCallback val$callback;
            final /* synthetic */ FileSource val$fileSource;
            {
                this.val$fileSource = fileSource;
                this.val$callback = resourcesCachePathChangeCallback;
            }

            @Override
            public void onError(String string2) {
                if (!bl) {
                    this.val$fileSource.deactivate();
                }
                this.val$callback.onError(string2);
            }

            @Override
            public void onSuccess(String string2) {
                if (!bl) {
                    this.val$fileSource.deactivate();
                }
                resourcesCachePathLoaderLock.lock();
                FileSource.access$302(string2);
                resourcesCachePathLoaderLock.unlock();
                this.val$callback.onSuccess(string2);
            }
        });
    }

    private static boolean isExternalStorageConfiguration(Context context) {
        boolean bl = false;
        context = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        boolean bl2 = bl;
        try {
            if (context.metaData != null) {
                bl2 = context.metaData.getBoolean("com.mapbox.SetStorageExternal", false);
            }
        }
        catch (Exception exception) {
            Logger.e(TAG, "Failed to read the storage key: ", exception);
            MapStrictMode.strictModeViolation(exception);
            bl2 = bl;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Logger.e(TAG, "Failed to read the package metadata: ", nameNotFoundException);
            MapStrictMode.strictModeViolation(nameNotFoundException);
            bl2 = bl;
        }
        return bl2;
    }

    public static boolean isExternalStorageReadable() {
        String string2 = Environment.getExternalStorageState();
        if (!"mounted".equals(string2) && !"mounted_ro".equals(string2)) {
            Logger.w(TAG, "External storage was requested but it isn't readable. For API level < 18 make sure you've requested READ_EXTERNAL_STORAGE or WRITE_EXTERNAL_STORAGE permissions in your app Manifest (defaulting to internal storage).");
            return false;
        }
        return true;
    }

    private static boolean isPathWritable(String string2) {
        if (string2 != null && !string2.isEmpty()) {
            return new File(string2).canWrite();
        }
        return false;
    }

    private static void lockPathLoaders() {
        internalCachePathLoaderLock.lock();
        resourcesCachePathLoaderLock.lock();
    }

    private native void setResourceCachePath(String var1, ResourcesCachePathChangeCallback var2);

    @Deprecated
    public static void setResourcesCachePath(Context context, String string2, ResourcesCachePathChangeCallback resourcesCachePathChangeCallback) {
        FileSource.setResourcesCachePath(string2, resourcesCachePathChangeCallback);
    }

    public static void setResourcesCachePath(final String string2, final ResourcesCachePathChangeCallback resourcesCachePathChangeCallback) {
        final Context context = Mapbox.getApplicationContext();
        FileSource.getInstance(context);
        if (string2.equals(FileSource.getResourcesCachePath(context))) {
            resourcesCachePathChangeCallback.onSuccess(string2);
        } else {
            new FileUtils.CheckFileWritePermissionTask(new FileUtils.OnCheckFileWritePermissionListener(){

                @Override
                public void onError() {
                    CharSequence charSequence = new StringBuilder();
                    charSequence.append("Path is not writable: ");
                    charSequence.append(string2);
                    charSequence = charSequence.toString();
                    Logger.e(FileSource.TAG, (String)charSequence);
                    resourcesCachePathChangeCallback.onError((String)charSequence);
                }

                @Override
                public void onWritePermissionGranted() {
                    SharedPreferences.Editor editor = context.getSharedPreferences("MapboxSharedPreferences", 0).edit();
                    editor.putString(FileSource.MAPBOX_SHARED_PREFERENCE_RESOURCES_CACHE_PATH, string2);
                    editor.apply();
                    FileSource.internalSetResourcesCachePath(context, string2, resourcesCachePathChangeCallback);
                }
            }).execute(new File[]{new File(string2)});
        }
    }

    private static void unlockPathLoaders() {
        resourcesCachePathLoaderLock.unlock();
        internalCachePathLoaderLock.unlock();
    }

    public native void activate();

    public native void deactivate();

    protected native void finalize() throws Throwable;

    public native String getAccessToken();

    public native boolean isActivated();

    public native void setAccessToken(String var1);

    public native void setApiBaseUrl(String var1);

    public native void setResourceTransform(ResourceTransformCallback var1);

    private static class FileDirsPathsTask
    extends AsyncTask<Context, Void, String[]> {
        private FileDirsPathsTask() {
        }

        protected String[] doInBackground(Context ... contextArray) {
            return new String[]{FileSource.getCachePath(contextArray[0]), contextArray[0].getCacheDir().getAbsolutePath()};
        }

        protected void onCancelled() {
            FileSource.unlockPathLoaders();
        }

        protected void onPostExecute(String[] stringArray) {
            FileSource.access$302(stringArray[0]);
            FileSource.access$402(stringArray[1]);
            FileSource.unlockPathLoaders();
        }
    }

    public static interface ResourceTransformCallback {
        public String onURL(int var1, String var2);
    }

    public static interface ResourcesCachePathChangeCallback {
        public void onError(String var1);

        public void onSuccess(String var1);
    }
}

