/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import com.google.gson.JsonElement;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class CircleLayer
extends Layer {
    CircleLayer(long l) {
        super(l);
    }

    public CircleLayer(String string2, String string3) {
        this.initialize(string2, string3);
    }

    private native Object nativeGetCircleBlur();

    private native TransitionOptions nativeGetCircleBlurTransition();

    private native Object nativeGetCircleColor();

    private native TransitionOptions nativeGetCircleColorTransition();

    private native Object nativeGetCircleOpacity();

    private native TransitionOptions nativeGetCircleOpacityTransition();

    private native Object nativeGetCirclePitchAlignment();

    private native Object nativeGetCirclePitchScale();

    private native Object nativeGetCircleRadius();

    private native TransitionOptions nativeGetCircleRadiusTransition();

    private native Object nativeGetCircleSortKey();

    private native Object nativeGetCircleStrokeColor();

    private native TransitionOptions nativeGetCircleStrokeColorTransition();

    private native Object nativeGetCircleStrokeOpacity();

    private native TransitionOptions nativeGetCircleStrokeOpacityTransition();

    private native Object nativeGetCircleStrokeWidth();

    private native TransitionOptions nativeGetCircleStrokeWidthTransition();

    private native Object nativeGetCircleTranslate();

    private native Object nativeGetCircleTranslateAnchor();

    private native TransitionOptions nativeGetCircleTranslateTransition();

    private native void nativeSetCircleBlurTransition(long var1, long var3);

    private native void nativeSetCircleColorTransition(long var1, long var3);

    private native void nativeSetCircleOpacityTransition(long var1, long var3);

    private native void nativeSetCircleRadiusTransition(long var1, long var3);

    private native void nativeSetCircleStrokeColorTransition(long var1, long var3);

    private native void nativeSetCircleStrokeOpacityTransition(long var1, long var3);

    private native void nativeSetCircleStrokeWidthTransition(long var1, long var3);

    private native void nativeSetCircleTranslateTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;

    public PropertyValue<Float> getCircleBlur() {
        this.checkThread();
        return new PropertyValue<Object>("circle-blur", this.nativeGetCircleBlur());
    }

    public TransitionOptions getCircleBlurTransition() {
        this.checkThread();
        return this.nativeGetCircleBlurTransition();
    }

    public PropertyValue<String> getCircleColor() {
        this.checkThread();
        return new PropertyValue<Object>("circle-color", this.nativeGetCircleColor());
    }

    public int getCircleColorAsInt() {
        this.checkThread();
        PropertyValue<String> propertyValue = this.getCircleColor();
        if (propertyValue.isValue()) {
            return ColorUtils.rgbaToColor(propertyValue.getValue());
        }
        throw new RuntimeException("circle-color was set as a Function");
    }

    public TransitionOptions getCircleColorTransition() {
        this.checkThread();
        return this.nativeGetCircleColorTransition();
    }

    public PropertyValue<Float> getCircleOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("circle-opacity", this.nativeGetCircleOpacity());
    }

    public TransitionOptions getCircleOpacityTransition() {
        this.checkThread();
        return this.nativeGetCircleOpacityTransition();
    }

    public PropertyValue<String> getCirclePitchAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("circle-pitch-alignment", this.nativeGetCirclePitchAlignment());
    }

    public PropertyValue<String> getCirclePitchScale() {
        this.checkThread();
        return new PropertyValue<Object>("circle-pitch-scale", this.nativeGetCirclePitchScale());
    }

    public PropertyValue<Float> getCircleRadius() {
        this.checkThread();
        return new PropertyValue<Object>("circle-radius", this.nativeGetCircleRadius());
    }

    public TransitionOptions getCircleRadiusTransition() {
        this.checkThread();
        return this.nativeGetCircleRadiusTransition();
    }

    public PropertyValue<Float> getCircleSortKey() {
        this.checkThread();
        return new PropertyValue<Object>("circle-sort-key", this.nativeGetCircleSortKey());
    }

    public PropertyValue<String> getCircleStrokeColor() {
        this.checkThread();
        return new PropertyValue<Object>("circle-stroke-color", this.nativeGetCircleStrokeColor());
    }

    public int getCircleStrokeColorAsInt() {
        this.checkThread();
        PropertyValue<String> propertyValue = this.getCircleStrokeColor();
        if (propertyValue.isValue()) {
            return ColorUtils.rgbaToColor(propertyValue.getValue());
        }
        throw new RuntimeException("circle-stroke-color was set as a Function");
    }

    public TransitionOptions getCircleStrokeColorTransition() {
        this.checkThread();
        return this.nativeGetCircleStrokeColorTransition();
    }

    public PropertyValue<Float> getCircleStrokeOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("circle-stroke-opacity", this.nativeGetCircleStrokeOpacity());
    }

    public TransitionOptions getCircleStrokeOpacityTransition() {
        this.checkThread();
        return this.nativeGetCircleStrokeOpacityTransition();
    }

    public PropertyValue<Float> getCircleStrokeWidth() {
        this.checkThread();
        return new PropertyValue<Object>("circle-stroke-width", this.nativeGetCircleStrokeWidth());
    }

    public TransitionOptions getCircleStrokeWidthTransition() {
        this.checkThread();
        return this.nativeGetCircleStrokeWidthTransition();
    }

    public PropertyValue<Float[]> getCircleTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("circle-translate", this.nativeGetCircleTranslate());
    }

    public PropertyValue<String> getCircleTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("circle-translate-anchor", this.nativeGetCircleTranslateAnchor());
    }

    public TransitionOptions getCircleTranslateTransition() {
        this.checkThread();
        return this.nativeGetCircleTranslateTransition();
    }

    public Expression getFilter() {
        this.checkThread();
        JsonElement jsonElement = this.nativeGetFilter();
        if (jsonElement != null) {
            return Expression.Converter.convert(jsonElement);
        }
        return null;
    }

    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    protected native void initialize(String var1, String var2);

    public void setCircleBlurTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetCircleBlurTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setCircleColorTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetCircleColorTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setCircleOpacityTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetCircleOpacityTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setCircleRadiusTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetCircleRadiusTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setCircleStrokeColorTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetCircleStrokeColorTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setCircleStrokeOpacityTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetCircleStrokeOpacityTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setCircleStrokeWidthTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetCircleStrokeWidthTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setCircleTranslateTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetCircleTranslateTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setFilter(Expression expression) {
        this.checkThread();
        this.nativeSetFilter(expression.toArray());
    }

    public void setSourceLayer(String string2) {
        this.checkThread();
        this.nativeSetSourceLayer(string2);
    }

    public CircleLayer withFilter(Expression expression) {
        this.setFilter(expression);
        return this;
    }

    public CircleLayer withProperties(PropertyValue<?> ... propertyValueArray) {
        this.setProperties(propertyValueArray);
        return this;
    }

    public CircleLayer withSourceLayer(String string2) {
        this.setSourceLayer(string2);
        return this;
    }
}

