/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import com.google.gson.JsonElement;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class HeatmapLayer
extends Layer {
    HeatmapLayer(long l) {
        super(l);
    }

    public HeatmapLayer(String string2, String string3) {
        this.initialize(string2, string3);
    }

    private native Object nativeGetHeatmapColor();

    private native Object nativeGetHeatmapIntensity();

    private native TransitionOptions nativeGetHeatmapIntensityTransition();

    private native Object nativeGetHeatmapOpacity();

    private native TransitionOptions nativeGetHeatmapOpacityTransition();

    private native Object nativeGetHeatmapRadius();

    private native TransitionOptions nativeGetHeatmapRadiusTransition();

    private native Object nativeGetHeatmapWeight();

    private native void nativeSetHeatmapIntensityTransition(long var1, long var3);

    private native void nativeSetHeatmapOpacityTransition(long var1, long var3);

    private native void nativeSetHeatmapRadiusTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;

    public Expression getFilter() {
        this.checkThread();
        JsonElement jsonElement = this.nativeGetFilter();
        if (jsonElement != null) {
            return Expression.Converter.convert(jsonElement);
        }
        return null;
    }

    public PropertyValue<String> getHeatmapColor() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-color", this.nativeGetHeatmapColor());
    }

    public int getHeatmapColorAsInt() {
        this.checkThread();
        PropertyValue<String> propertyValue = this.getHeatmapColor();
        if (propertyValue.isValue()) {
            return ColorUtils.rgbaToColor(propertyValue.getValue());
        }
        throw new RuntimeException("heatmap-color was set as a Function");
    }

    public PropertyValue<Float> getHeatmapIntensity() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-intensity", this.nativeGetHeatmapIntensity());
    }

    public TransitionOptions getHeatmapIntensityTransition() {
        this.checkThread();
        return this.nativeGetHeatmapIntensityTransition();
    }

    public PropertyValue<Float> getHeatmapOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-opacity", this.nativeGetHeatmapOpacity());
    }

    public TransitionOptions getHeatmapOpacityTransition() {
        this.checkThread();
        return this.nativeGetHeatmapOpacityTransition();
    }

    public PropertyValue<Float> getHeatmapRadius() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-radius", this.nativeGetHeatmapRadius());
    }

    public TransitionOptions getHeatmapRadiusTransition() {
        this.checkThread();
        return this.nativeGetHeatmapRadiusTransition();
    }

    public PropertyValue<Float> getHeatmapWeight() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-weight", this.nativeGetHeatmapWeight());
    }

    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    protected native void initialize(String var1, String var2);

    public void setFilter(Expression expression) {
        this.checkThread();
        this.nativeSetFilter(expression.toArray());
    }

    public void setHeatmapIntensityTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetHeatmapIntensityTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setHeatmapOpacityTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetHeatmapOpacityTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setHeatmapRadiusTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetHeatmapRadiusTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setSourceLayer(String string2) {
        this.checkThread();
        this.nativeSetSourceLayer(string2);
    }

    public HeatmapLayer withFilter(Expression expression) {
        this.setFilter(expression);
        return this;
    }

    public HeatmapLayer withProperties(PropertyValue<?> ... propertyValueArray) {
        this.setProperties(propertyValueArray);
        return this;
    }

    public HeatmapLayer withSourceLayer(String string2) {
        this.setSourceLayer(string2);
        return this;
    }
}

