/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import com.google.gson.JsonArray;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.exceptions.ConversionException;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.Arrays;

public class PropertyValue<T> {
    private static final String TAG = "Mbgl-PropertyValue";
    public final String name;
    public final T value;

    public PropertyValue(String string2, T t) {
        this.name = string2;
        this.value = t;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            PropertyValue propertyValue = (PropertyValue)object;
            if (!this.name.equals(propertyValue.name)) {
                return false;
            }
            object = this.value;
            if (object != null) {
                if (object instanceof Object[]) {
                    return Arrays.deepEquals((Object[])object, (Object[])propertyValue.value);
                }
                return object.equals(propertyValue.value);
            }
            if (propertyValue.value != null) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public Integer getColorInt() {
        T t;
        if (this.isValue() && (t = this.value) instanceof String) {
            int n;
            try {
                n = ColorUtils.rgbaToColor((String)t);
            }
            catch (ConversionException conversionException) {
                Logger.e(TAG, String.format("%s could not be converted to a Color int: %s", this.name, conversionException.getMessage()));
                MapStrictMode.strictModeViolation(conversionException);
                return null;
            }
            return n;
        }
        Logger.e(TAG, String.format("%s is not a String value and can not be converted to a color it", this.name));
        return null;
    }

    public Expression getExpression() {
        if (this.isExpression()) {
            Object object = this.value;
            object = object instanceof JsonArray ? Expression.Converter.convert((JsonArray)object) : (Expression)object;
            return object;
        }
        Logger.w(TAG, String.format("%s not an expression, try PropertyValue#getValue()", this.name));
        return null;
    }

    public T getValue() {
        if (this.isValue()) {
            return this.value;
        }
        Logger.w(TAG, String.format("%s not a value, try PropertyValue#getExpression()", this.name));
        return null;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        T t = this.value;
        int n2 = t != null ? t.hashCode() : 0;
        return n * 31 + n2;
    }

    public boolean isExpression() {
        T t;
        boolean bl = !this.isNull() && ((t = this.value) instanceof JsonArray || t instanceof Expression);
        return bl;
    }

    public boolean isNull() {
        boolean bl = this.value == null;
        return bl;
    }

    public boolean isValue() {
        boolean bl = !this.isNull() && !this.isExpression();
        return bl;
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.value);
    }
}

