/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.sources.CustomGeometrySourceOptions;
import com.mapbox.mapboxsdk.style.sources.GeometryTileProvider;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CustomGeometrySource
extends Source {
    public static final int THREAD_POOL_LIMIT = 4;
    public static final String THREAD_PREFIX = "CustomGeom";
    private static final AtomicInteger poolCount = new AtomicInteger();
    private final Map<TileID, GeometryTileRequest> awaitingTasksMap;
    private ThreadPoolExecutor executor;
    private final Lock executorLock = new ReentrantLock();
    private final Map<TileID, AtomicBoolean> inProgressTasksMap;
    private GeometryTileProvider provider;

    public CustomGeometrySource(String string2, CustomGeometrySourceOptions customGeometrySourceOptions, GeometryTileProvider geometryTileProvider) {
        this.awaitingTasksMap = new HashMap<TileID, GeometryTileRequest>();
        this.inProgressTasksMap = new HashMap<TileID, AtomicBoolean>();
        this.provider = geometryTileProvider;
        this.initialize(string2, customGeometrySourceOptions);
    }

    public CustomGeometrySource(String string2, GeometryTileProvider geometryTileProvider) {
        this(string2, new CustomGeometrySourceOptions(), geometryTileProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelTile(int n, int n2, int n3) {
        TileID tileID = new TileID(n, n2, n3);
        Map<TileID, GeometryTileRequest> map = this.awaitingTasksMap;
        synchronized (map) {
            Map<TileID, AtomicBoolean> map2 = this.inProgressTasksMap;
            synchronized (map2) {
                Object object = this.inProgressTasksMap.get(tileID);
                if (object == null || !((AtomicBoolean)object).compareAndSet(false, true)) {
                    object = new GeometryTileRequest(tileID, null, null, null, null, null);
                    if (!this.executor.getQueue().remove(object)) {
                        this.awaitingTasksMap.remove(tileID);
                    }
                }
                return;
            }
        }
    }

    private void executeRequest(GeometryTileRequest geometryTileRequest) {
        block4: {
            this.executorLock.lock();
            ThreadPoolExecutor threadPoolExecutor = this.executor;
            if (threadPoolExecutor == null) break block4;
            if (threadPoolExecutor.isShutdown()) break block4;
            this.executor.execute(geometryTileRequest);
        }
        return;
        finally {
            this.executorLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchTile(int n, int n2, int n3) {
        Object object = new AtomicBoolean(false);
        TileID tileID = new TileID(n, n2, n3);
        GeometryTileRequest geometryTileRequest = new GeometryTileRequest(tileID, this.provider, this.awaitingTasksMap, this.inProgressTasksMap, this, (AtomicBoolean)object);
        object = this.awaitingTasksMap;
        synchronized (object) {
            Map<TileID, AtomicBoolean> map = this.inProgressTasksMap;
            synchronized (map) {
                if (this.executor.getQueue().contains(geometryTileRequest)) {
                    this.executor.remove(geometryTileRequest);
                    this.executeRequest(geometryTileRequest);
                } else if (this.inProgressTasksMap.containsKey(tileID)) {
                    this.awaitingTasksMap.put(tileID, geometryTileRequest);
                } else {
                    this.executeRequest(geometryTileRequest);
                }
                return;
            }
        }
    }

    private boolean isCancelled(int n, int n2, int n3) {
        return this.inProgressTasksMap.get(new TileID(n, n2, n3)).get();
    }

    private native void nativeInvalidateBounds(LatLngBounds var1);

    private native void nativeInvalidateTile(int var1, int var2, int var3);

    private native void nativeSetTileData(int var1, int var2, int var3, FeatureCollection var4);

    private native Feature[] querySourceFeatures(Object[] var1);

    private void releaseThreads() {
        this.executorLock.lock();
        try {
            this.executor.shutdownNow();
            return;
        }
        finally {
            this.executorLock.unlock();
        }
    }

    private void setTileData(TileID tileID, FeatureCollection featureCollection) {
        this.nativeSetTileData(tileID.z, tileID.x, tileID.y, featureCollection);
    }

    private void startThreads() {
        this.executorLock.lock();
        try {
            ThreadPoolExecutor threadPoolExecutor;
            ThreadFactory threadFactory = this.executor;
            if (threadFactory != null && !((ThreadPoolExecutor)((Object)threadFactory)).isShutdown()) {
                this.executor.shutdownNow();
            }
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
            threadFactory = new ThreadFactory(){
                final int poolId;
                final AtomicInteger threadCount = new AtomicInteger();
                {
                    this.poolId = poolCount.getAndIncrement();
                }

                @Override
                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, String.format(Locale.US, "%s-%d-%d", CustomGeometrySource.THREAD_PREFIX, this.poolId, this.threadCount.getAndIncrement()));
                }
            };
            this.executor = threadPoolExecutor = new ThreadPoolExecutor(4, 4, 0L, timeUnit, linkedBlockingQueue, threadFactory);
            return;
        }
        finally {
            this.executorLock.unlock();
        }
    }

    protected native void finalize() throws Throwable;

    protected native void initialize(String var1, Object var2);

    public void invalidateRegion(LatLngBounds latLngBounds) {
        this.nativeInvalidateBounds(latLngBounds);
    }

    public void invalidateTile(int n, int n2, int n3) {
        this.nativeInvalidateTile(n, n2, n3);
    }

    public List<Feature> querySourceFeatures(Expression object) {
        this.checkThread();
        object = object != null ? object.toArray() : null;
        object = this.querySourceFeatures((Object[])object);
        object = object != null ? Arrays.asList(object) : new ArrayList();
        return object;
    }

    public void setTileData(int n, int n2, int n3, FeatureCollection featureCollection) {
        this.nativeSetTileData(n, n2, n3, featureCollection);
    }

    static class GeometryTileRequest
    implements Runnable {
        private final Map<TileID, GeometryTileRequest> awaiting;
        private final AtomicBoolean cancelled;
        private final TileID id;
        private final Map<TileID, AtomicBoolean> inProgress;
        private final GeometryTileProvider provider;
        private final WeakReference<CustomGeometrySource> sourceRef;

        GeometryTileRequest(TileID tileID, GeometryTileProvider geometryTileProvider, Map<TileID, GeometryTileRequest> map, Map<TileID, AtomicBoolean> map2, CustomGeometrySource customGeometrySource, AtomicBoolean atomicBoolean) {
            this.id = tileID;
            this.provider = geometryTileProvider;
            this.awaiting = map;
            this.inProgress = map2;
            this.sourceRef = new WeakReference<CustomGeometrySource>(customGeometrySource);
            this.cancelled = atomicBoolean;
        }

        private Boolean isCancelled() {
            return this.cancelled.get();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (GeometryTileRequest)object;
                return this.id.equals(((GeometryTileRequest)object).id);
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Object object;
            Object object2 = this.awaiting;
            // MONITORENTER : object2
            Object object3 = this.inProgress;
            // MONITORENTER : object3
            if (this.inProgress.containsKey(this.id)) {
                if (!this.awaiting.containsKey(this.id)) {
                    this.awaiting.put(this.id, this);
                }
                // MONITOREXIT : object3
                // MONITOREXIT : object2
                return;
            }
            this.inProgress.put(this.id, this.cancelled);
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            if (!this.isCancelled().booleanValue()) {
                object2 = this.provider.getFeaturesForBounds(LatLngBounds.from(this.id.z, this.id.x, this.id.y), this.id.z);
                object = (CustomGeometrySource)this.sourceRef.get();
                if (!this.isCancelled().booleanValue() && object != null && object2 != null) {
                    ((CustomGeometrySource)object).setTileData(this.id, (FeatureCollection)object2);
                }
            }
            object2 = this.awaiting;
            // MONITORENTER : object2
            object = this.inProgress;
            // MONITORENTER : object
            this.inProgress.remove(this.id);
            if (this.awaiting.containsKey(this.id)) {
                object3 = this.awaiting.get(this.id);
                CustomGeometrySource customGeometrySource = (CustomGeometrySource)this.sourceRef.get();
                if (customGeometrySource != null && object3 != null) {
                    customGeometrySource.executor.execute((Runnable)object3);
                }
                this.awaiting.remove(this.id);
            }
            // MONITOREXIT : object
            // MONITOREXIT : object2
        }
    }

    static class TileID {
        public int x;
        public int y;
        public int z;

        TileID(int n, int n2, int n3) {
            this.z = n;
            this.x = n2;
            this.y = n3;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (object == this) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass() && object instanceof TileID) {
                object = (TileID)object;
                if (this.z != ((TileID)object).z || this.x != ((TileID)object).x || this.y != ((TileID)object).y) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(new int[]{this.z, this.x, this.y});
        }
    }
}

