/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GeoJsonSource
extends Source {
    GeoJsonSource(long l) {
        super(l);
    }

    public GeoJsonSource(String string2) {
        this.initialize(string2, null);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList<Feature>()));
    }

    public GeoJsonSource(String string2, Feature feature) {
        this.initialize(string2, null);
        this.setGeoJson(feature);
    }

    public GeoJsonSource(String string2, Feature feature, GeoJsonOptions geoJsonOptions) {
        this.initialize(string2, geoJsonOptions);
        this.setGeoJson(feature);
    }

    public GeoJsonSource(String string2, FeatureCollection featureCollection) {
        this.initialize(string2, null);
        this.setGeoJson(featureCollection);
    }

    public GeoJsonSource(String string2, FeatureCollection featureCollection, GeoJsonOptions geoJsonOptions) {
        this.initialize(string2, geoJsonOptions);
        this.setGeoJson(featureCollection);
    }

    public GeoJsonSource(String string2, Geometry geometry) {
        this.initialize(string2, null);
        this.setGeoJson(geometry);
    }

    public GeoJsonSource(String string2, Geometry geometry, GeoJsonOptions geoJsonOptions) {
        this.initialize(string2, geoJsonOptions);
        this.setGeoJson(geometry);
    }

    public GeoJsonSource(String string2, GeoJsonOptions geoJsonOptions) {
        this.initialize(string2, geoJsonOptions);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList<Feature>()));
    }

    public GeoJsonSource(String string2, String string3) {
        if (string3 != null && !string3.startsWith("http")) {
            this.initialize(string2, null);
            this.setGeoJson(string3);
            return;
        }
        throw new IllegalArgumentException("Expected a raw json body");
    }

    public GeoJsonSource(String string2, String string3, GeoJsonOptions geoJsonOptions) {
        if (!(string3 == null || string3.startsWith("http") || string3.startsWith("asset") || string3.startsWith("file"))) {
            this.initialize(string2, geoJsonOptions);
            this.setGeoJson(string3);
            return;
        }
        throw new IllegalArgumentException("Expected a raw json body");
    }

    public GeoJsonSource(String string2, URI uRI) {
        this.initialize(string2, null);
        this.nativeSetUrl(uRI.toString());
    }

    public GeoJsonSource(String string2, URI uRI, GeoJsonOptions geoJsonOptions) {
        this.initialize(string2, geoJsonOptions);
        this.nativeSetUrl(uRI.toString());
    }

    @Deprecated
    public GeoJsonSource(String string2, URL uRL) {
        this.initialize(string2, null);
        this.nativeSetUrl(uRL.toExternalForm());
    }

    @Deprecated
    public GeoJsonSource(String string2, URL uRL, GeoJsonOptions geoJsonOptions) {
        this.initialize(string2, geoJsonOptions);
        this.nativeSetUrl(uRL.toExternalForm());
    }

    private native Feature[] nativeGetClusterChildren(Feature var1);

    private native int nativeGetClusterExpansionZoom(Feature var1);

    private native Feature[] nativeGetClusterLeaves(Feature var1, long var2, long var4);

    private native void nativeSetFeature(Feature var1);

    private native void nativeSetFeatureCollection(FeatureCollection var1);

    private native void nativeSetGeoJsonString(String var1);

    private native void nativeSetGeometry(Geometry var1);

    private native Feature[] querySourceFeatures(Object[] var1);

    protected native void finalize() throws Throwable;

    public FeatureCollection getClusterChildren(Feature feature) {
        this.checkThread();
        return FeatureCollection.fromFeatures(this.nativeGetClusterChildren(feature));
    }

    public int getClusterExpansionZoom(Feature feature) {
        this.checkThread();
        return this.nativeGetClusterExpansionZoom(feature);
    }

    public FeatureCollection getClusterLeaves(Feature feature, long l, long l2) {
        this.checkThread();
        return FeatureCollection.fromFeatures(this.nativeGetClusterLeaves(feature, l, l2));
    }

    public String getUri() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    public String getUrl() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    protected native void initialize(String var1, Object var2);

    protected native String nativeGetUrl();

    protected native void nativeSetUrl(String var1);

    public List<Feature> querySourceFeatures(Expression object) {
        this.checkThread();
        object = object != null ? object.toArray() : null;
        object = this.querySourceFeatures((Object[])object);
        object = object != null ? Arrays.asList(object) : new ArrayList();
        return object;
    }

    public void setGeoJson(Feature feature) {
        if (this.detached) {
            return;
        }
        this.checkThread();
        this.nativeSetFeature(feature);
    }

    public void setGeoJson(FeatureCollection featureCollection) {
        if (this.detached) {
            return;
        }
        this.checkThread();
        if (featureCollection != null && featureCollection.features() != null) {
            this.nativeSetFeatureCollection(FeatureCollection.fromFeatures(new ArrayList<Feature>(featureCollection.features())));
        } else {
            this.nativeSetFeatureCollection(featureCollection);
        }
    }

    public void setGeoJson(Geometry geometry) {
        if (this.detached) {
            return;
        }
        this.checkThread();
        this.nativeSetGeometry(geometry);
    }

    public void setGeoJson(String string2) {
        if (this.detached) {
            return;
        }
        this.checkThread();
        this.nativeSetGeoJsonString(string2);
    }

    public void setUri(String string2) {
        this.checkThread();
        this.nativeSetUrl(string2);
    }

    public void setUri(URI uRI) {
        this.setUri(uRI.toString());
    }

    @Deprecated
    public void setUrl(String string2) {
        this.checkThread();
        this.nativeSetUrl(string2);
    }

    @Deprecated
    public void setUrl(URL uRL) {
        this.checkThread();
        this.setUrl(uRL.toExternalForm());
    }
}

