/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.geometry.LatLngQuad;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.net.URI;
import java.net.URL;

public class ImageSource
extends Source {
    ImageSource(long l) {
        super(l);
    }

    public ImageSource(String string2, LatLngQuad latLngQuad, int n) {
        this.initialize(string2, latLngQuad);
        this.setImage(n);
    }

    public ImageSource(String string2, LatLngQuad latLngQuad, Bitmap bitmap) {
        this.initialize(string2, latLngQuad);
        this.setImage(bitmap);
    }

    public ImageSource(String string2, LatLngQuad latLngQuad, URI uRI) {
        this.initialize(string2, latLngQuad);
        this.setUri(uRI);
    }

    @Deprecated
    public ImageSource(String string2, LatLngQuad latLngQuad, URL uRL) {
        this.initialize(string2, latLngQuad);
        this.setUrl(uRL);
    }

    protected native void finalize() throws Throwable;

    public String getUri() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    @Deprecated
    public String getUrl() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    protected native void initialize(String var1, LatLngQuad var2);

    protected native String nativeGetUrl();

    protected native void nativeSetCoordinates(LatLngQuad var1);

    protected native void nativeSetImage(Bitmap var1);

    protected native void nativeSetUrl(String var1);

    public void setCoordinates(LatLngQuad latLngQuad) {
        this.checkThread();
        this.nativeSetCoordinates(latLngQuad);
    }

    public void setImage(int n) throws IllegalArgumentException {
        this.checkThread();
        Drawable drawable2 = BitmapUtils.getDrawableFromRes(Mapbox.getApplicationContext(), n);
        if (drawable2 instanceof BitmapDrawable) {
            this.nativeSetImage(((BitmapDrawable)drawable2).getBitmap());
            return;
        }
        throw new IllegalArgumentException("Failed to decode image. The resource provided must be a Bitmap.");
    }

    public void setImage(Bitmap bitmap) {
        this.checkThread();
        this.nativeSetImage(bitmap);
    }

    public void setUri(String string2) {
        this.checkThread();
        this.nativeSetUrl(string2);
    }

    public void setUri(URI uRI) {
        this.checkThread();
        this.nativeSetUrl(uRI.toString());
    }

    @Deprecated
    public void setUrl(String string2) {
        this.checkThread();
        this.nativeSetUrl(string2);
    }

    @Deprecated
    public void setUrl(URL uRL) {
        this.setUrl(uRL.toExternalForm());
    }
}

