/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

public abstract class Source {
    private static final String TAG = "Mbgl-Source";
    protected boolean detached;
    private long nativePtr;

    static {
        LibraryLoader.load();
    }

    public Source() {
        this.checkThread();
    }

    protected Source(long l) {
        this.checkThread();
        this.nativePtr = l;
    }

    protected void checkThread() {
        ThreadUtils.checkThread(TAG);
    }

    public String getAttribution() {
        this.checkThread();
        return this.nativeGetAttribution();
    }

    public String getId() {
        this.checkThread();
        return this.nativeGetId();
    }

    public Integer getMaxOverscaleFactorForParentTiles() {
        return this.nativeGetMaxOverscaleFactorForParentTiles();
    }

    public Long getMinimumTileUpdateInterval() {
        return this.nativeGetMinimumTileUpdateInterval();
    }

    public long getNativePtr() {
        return this.nativePtr;
    }

    public Integer getPrefetchZoomDelta() {
        return this.nativeGetPrefetchZoomDelta();
    }

    public Boolean isVolatile() {
        return this.nativeIsVolatile();
    }

    protected native String nativeGetAttribution();

    protected native String nativeGetId();

    protected native Integer nativeGetMaxOverscaleFactorForParentTiles();

    protected native Long nativeGetMinimumTileUpdateInterval();

    protected native Integer nativeGetPrefetchZoomDelta();

    protected native Boolean nativeIsVolatile();

    protected native void nativeSetMaxOverscaleFactorForParentTiles(Integer var1);

    protected native void nativeSetMinimumTileUpdateInterval(Long var1);

    protected native void nativeSetPrefetchZoomDelta(Integer var1);

    protected native void nativeSetVolatile(Boolean var1);

    public void setDetached() {
        this.detached = true;
    }

    public void setMaxOverscaleFactorForParentTiles(Integer n) {
        this.nativeSetMaxOverscaleFactorForParentTiles(n);
    }

    public void setMinimumTileUpdateInterval(Long l) {
        this.nativeSetMinimumTileUpdateInterval(l);
    }

    public void setPrefetchZoomDelta(Integer n) {
        this.nativeSetPrefetchZoomDelta(n);
    }

    public void setVolatile(Boolean bl) {
        this.nativeSetVolatile(bl);
    }
}

