/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BitmapUtils {
    public static Bitmap createBitmapFromView(View view) {
        view.setDrawingCacheEnabled(true);
        view.setDrawingCacheQuality(524288);
        view.buildDrawingCache();
        if (view.getDrawingCache() == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        view.destroyDrawingCache();
        return bitmap;
    }

    public static boolean equals(Bitmap object, Bitmap bitmap) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(object.getHeight() * object.getRowBytes());
        object.copyPixelsToBuffer((Buffer)byteBuffer);
        object = ByteBuffer.allocate(bitmap.getHeight() * bitmap.getRowBytes());
        bitmap.copyPixelsToBuffer((Buffer)object);
        return Arrays.equals(byteBuffer.array(), ((ByteBuffer)object).array());
    }

    public static Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        if ((drawable2 = drawable2.getConstantState()) == null) {
            return null;
        }
        Drawable drawable3 = drawable2.newDrawable().mutate();
        Bitmap bitmap = Bitmap.createBitmap((int)drawable3.getIntrinsicWidth(), (int)drawable3.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        drawable2 = new Canvas(bitmap);
        drawable3.setBounds(0, 0, drawable2.getWidth(), drawable2.getHeight());
        drawable3.draw((Canvas)drawable2);
        return bitmap;
    }

    public static byte[] getByteArrayFromDrawable(Drawable object) {
        if (object == null) {
            return null;
        }
        Bitmap bitmap = BitmapUtils.getBitmapFromDrawable((Drawable)object);
        if (bitmap == null) {
            return null;
        }
        object = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public static Drawable getDrawableFromByteArray(Context context, byte[] object) {
        if (object == null) {
            return null;
        }
        object = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length);
        return new BitmapDrawable(context.getResources(), (Bitmap)object);
    }

    public static Drawable getDrawableFromRes(Context context, int n) {
        return BitmapUtils.getDrawableFromRes(context, n, null);
    }

    public static Drawable getDrawableFromRes(Context context, int n, Integer n2) {
        if ((context = context.getResources().getDrawable(n)) == null) {
            return null;
        }
        if (n2 == null) {
            return context;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            context.setTint(n2.intValue());
        } else {
            context.mutate().setColorFilter(n2.intValue(), PorterDuff.Mode.SRC_IN);
        }
        return context;
    }

    public static Bitmap mergeBitmap(Bitmap bitmap, Bitmap bitmap2) {
        return BitmapUtils.mergeBitmap(bitmap, bitmap2, 10.0f, 10.0f);
    }

    public static Bitmap mergeBitmap(Bitmap bitmap, Bitmap bitmap2, float f, float f2) {
        Bitmap bitmap3 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)bitmap.getConfig());
        Canvas canvas = new Canvas(bitmap3);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        canvas.drawBitmap(bitmap2, f, f2, null);
        return bitmap3;
    }
}

