/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.os.Build;
import android.util.TypedValue;
import android.widget.ImageView;
import androidx.core.widget.ImageViewCompat;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.exceptions.ConversionException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorUtils {
    public static float[] colorToGlRgbaArray(int n) {
        return new float[]{(float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f, (float)(n >> 24 & 0xFF) / 255.0f};
    }

    public static float[] colorToRgbaArray(int n) {
        return new float[]{n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, (float)(n >> 24 & 0xFF) / 255.0f};
    }

    public static String colorToRgbaString(int n) {
        Object object = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        ((DecimalFormat)object).applyPattern("#.###");
        object = ((NumberFormat)object).format((float)(n >> 24 & 0xFF) / 255.0f);
        return String.format(Locale.US, "rgba(%d, %d, %d, %s)", n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, object);
    }

    public static int getAccentColor(Context context) {
        try {
            TypedValue typedValue = new TypedValue();
            context.getTheme().resolveAttribute(context.getResources().getIdentifier("colorAccent", "attrs", context.getPackageName()), typedValue, true);
            int n = typedValue.data;
            return n;
        }
        catch (Exception exception) {
            return ColorUtils.getColorCompat(context, R.color.mapbox_gray);
        }
    }

    private static int getColorCompat(Context context, int n) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getResources().getColor(n, context.getTheme());
        }
        return context.getResources().getColor(n);
    }

    public static int getPrimaryColor(Context context) {
        try {
            TypedValue typedValue = new TypedValue();
            context.getTheme().resolveAttribute(context.getResources().getIdentifier("colorPrimary", "attrs", context.getPackageName()), typedValue, true);
            int n = typedValue.data;
            return n;
        }
        catch (Exception exception) {
            return ColorUtils.getColorCompat(context, R.color.mapbox_blue);
        }
    }

    public static int getPrimaryDarkColor(Context context) {
        try {
            TypedValue typedValue = new TypedValue();
            context.getTheme().resolveAttribute(context.getResources().getIdentifier("colorPrimaryDark", "attrs", context.getPackageName()), typedValue, true);
            int n = typedValue.data;
            return n;
        }
        catch (Exception exception) {
            return ColorUtils.getColorCompat(context, R.color.mapbox_blue);
        }
    }

    public static ColorStateList getSelector(int n) {
        return new ColorStateList((int[][])new int[][]{{16842919}, new int[0]}, new int[]{n, n});
    }

    public static int rgbaToColor(String object) {
        object = Pattern.compile("rgba?\\s*\\(\\s*(\\d+\\.?\\d*)\\s*,\\s*(\\d+\\.?\\d*)\\s*,\\s*(\\d+\\.?\\d*)\\s*,?\\s*(\\d+\\.?\\d*)?\\s*\\)").matcher((CharSequence)object);
        if (((Matcher)object).matches() && ((Matcher)object).groupCount() == 3) {
            return Color.rgb((int)((int)Float.parseFloat(((Matcher)object).group(1))), (int)((int)Float.parseFloat(((Matcher)object).group(2))), (int)((int)Float.parseFloat(((Matcher)object).group(3))));
        }
        if (((Matcher)object).matches() && ((Matcher)object).groupCount() == 4) {
            return Color.argb((int)((int)(Float.parseFloat(((Matcher)object).group(4)) * 255.0f)), (int)((int)Float.parseFloat(((Matcher)object).group(1))), (int)((int)Float.parseFloat(((Matcher)object).group(2))), (int)((int)Float.parseFloat(((Matcher)object).group(3))));
        }
        throw new ConversionException("Not a valid rgb/rgba value");
    }

    public static void setTintList(ImageView imageView, int n) {
        ImageViewCompat.setImageTintList((ImageView)imageView, (ColorStateList)ColorUtils.getSelector(n));
    }
}

