/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.os.AsyncTask;
import com.mapbox.mapboxsdk.log.Logger;
import java.io.File;

public class FileUtils {
    private static final String TAG = "Mbgl-FileUtils";

    public static void deleteFile(final String string2) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Comparable<File> comparable = new Comparable<File>(string2);
                    if (((File)comparable).exists()) {
                        if (((File)comparable).delete()) {
                            comparable = new Comparable<File>();
                            ((StringBuilder)comparable).append("File deleted to save space: ");
                            ((StringBuilder)comparable).append(string2);
                            Logger.d(FileUtils.TAG, ((StringBuilder)comparable).toString());
                        } else {
                            comparable = new Comparable<File>();
                            ((StringBuilder)comparable).append("Failed to delete file: ");
                            ((StringBuilder)comparable).append(string2);
                            Logger.e(FileUtils.TAG, ((StringBuilder)comparable).toString());
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.e(FileUtils.TAG, "Failed to delete file: ", exception);
                }
            }
        }).start();
    }

    public static class CheckFileReadPermissionTask
    extends AsyncTask<File, Void, Boolean> {
        private final OnCheckFileReadPermissionListener listener;

        public CheckFileReadPermissionTask(OnCheckFileReadPermissionListener onCheckFileReadPermissionListener) {
            this.listener = onCheckFileReadPermissionListener;
        }

        protected Boolean doInBackground(File ... fileArray) {
            boolean bl;
            try {
                bl = fileArray[0].canRead();
            }
            catch (Exception exception) {
                return false;
            }
            return bl;
        }

        protected void onCancelled() {
            this.listener.onError();
        }

        protected void onPostExecute(Boolean bl) {
            if (bl.booleanValue()) {
                this.listener.onReadPermissionGranted();
            } else {
                this.listener.onError();
            }
        }
    }

    public static class CheckFileWritePermissionTask
    extends AsyncTask<File, Void, Boolean> {
        private final OnCheckFileWritePermissionListener listener;

        public CheckFileWritePermissionTask(OnCheckFileWritePermissionListener onCheckFileWritePermissionListener) {
            this.listener = onCheckFileWritePermissionListener;
        }

        protected Boolean doInBackground(File ... fileArray) {
            boolean bl;
            try {
                bl = fileArray[0].canWrite();
            }
            catch (Exception exception) {
                return false;
            }
            return bl;
        }

        protected void onCancelled() {
            this.listener.onError();
        }

        protected void onPostExecute(Boolean bl) {
            if (bl.booleanValue()) {
                this.listener.onWritePermissionGranted();
            } else {
                this.listener.onError();
            }
        }
    }

    public static interface OnCheckFileReadPermissionListener {
        public void onError();

        public void onReadPermissionGranted();
    }

    public static interface OnCheckFileWritePermissionListener {
        public void onError();

        public void onWritePermissionGranted();
    }
}

