/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.MultiPolygon;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import java.util.ArrayList;
import java.util.List;

public final class TurfJoins {
    private TurfJoins() {
    }

    private static boolean inRing(Point point, List<Point> list) {
        int n = list.size() - 1;
        int n2 = 0;
        boolean bl = false;
        while (n2 < list.size()) {
            double d = list.get(n2).longitude();
            double d2 = list.get(n2).latitude();
            double d3 = list.get(n).longitude();
            double d4 = list.get(n).latitude();
            n = d2 > point.latitude() ? 1 : 0;
            int n3 = d4 > point.latitude() ? 1 : 0;
            n = n != n3 && point.longitude() < (d3 - d) * (point.latitude() - d2) / (d4 - d2) + d ? 1 : 0;
            boolean bl2 = bl;
            if (n != 0) {
                bl2 = bl ^ true;
            }
            n = n2++;
            bl = bl2;
        }
        return bl;
    }

    public static boolean inside(Point point, MultiPolygon object) {
        object = ((MultiPolygon)object).coordinates();
        boolean bl = false;
        for (int i = 0; i < object.size() && !bl; ++i) {
            boolean bl2 = bl;
            if (TurfJoins.inRing(point, (List)((List)object.get(i)).get(0))) {
                boolean bl3 = false;
                for (int j = 1; j < ((List)object.get(i)).size() && !bl3; ++j) {
                    if (!TurfJoins.inRing(point, (List)((List)object.get(i)).get(j))) continue;
                    bl3 = true;
                }
                bl2 = bl;
                if (!bl3) {
                    bl2 = true;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    public static boolean inside(Point point, Polygon serializable) {
        Object object = ((Polygon)serializable).coordinates();
        serializable = new ArrayList();
        serializable.add(object);
        return TurfJoins.inside(point, MultiPolygon.fromLngLats((List<List<List<Point>>>)((Object)serializable)));
    }

    public static FeatureCollection pointsWithinPolygon(FeatureCollection featureCollection, FeatureCollection featureCollection2) {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        for (int i = 0; i < featureCollection2.features().size(); ++i) {
            for (int j = 0; j < featureCollection.features().size(); ++j) {
                Point point = (Point)featureCollection.features().get(j).geometry();
                if (!TurfJoins.inside(point, (Polygon)featureCollection2.features().get(i).geometry())) continue;
                arrayList.add(Feature.fromGeometry(point));
            }
        }
        return FeatureCollection.fromFeatures(arrayList);
    }
}

