/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.GeometryCollection;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.MultiLineString;
import com.mapbox.geojson.MultiPoint;
import com.mapbox.geojson.MultiPolygon;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.turf.TurfException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class TurfMeta {
    private TurfMeta() {
    }

    private static List<Point> addCoordAll(List<Point> list, Feature feature, boolean bl) {
        return TurfMeta.coordAllFromSingleGeometry(list, feature.geometry(), bl);
    }

    public static List<Point> coordAll(Feature feature, boolean bl) {
        return TurfMeta.addCoordAll(new ArrayList<Point>(), feature, bl);
    }

    public static List<Point> coordAll(FeatureCollection object, boolean bl) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        object = ((FeatureCollection)object).features().iterator();
        while (object.hasNext()) {
            TurfMeta.addCoordAll(arrayList, (Feature)object.next(), bl);
        }
        return arrayList;
    }

    public static List<Point> coordAll(LineString lineString) {
        return TurfMeta.coordAll(new ArrayList<Point>(), lineString);
    }

    public static List<Point> coordAll(MultiLineString multiLineString) {
        return TurfMeta.coordAll(new ArrayList<Point>(), multiLineString);
    }

    public static List<Point> coordAll(MultiPoint multiPoint) {
        return TurfMeta.coordAll(new ArrayList<Point>(), multiPoint);
    }

    public static List<Point> coordAll(MultiPolygon multiPolygon, boolean bl) {
        return TurfMeta.coordAll(new ArrayList<Point>(), multiPolygon, bl);
    }

    public static List<Point> coordAll(Point point) {
        return TurfMeta.coordAll(new ArrayList<Point>(), point);
    }

    public static List<Point> coordAll(Polygon polygon, boolean bl) {
        return TurfMeta.coordAll(new ArrayList<Point>(), polygon, bl);
    }

    private static List<Point> coordAll(List<Point> list, LineString lineString) {
        list.addAll((Collection<Point>)lineString.coordinates());
        return list;
    }

    private static List<Point> coordAll(List<Point> list, MultiLineString multiLineString) {
        for (int i = 0; i < multiLineString.coordinates().size(); ++i) {
            list.addAll((Collection)multiLineString.coordinates().get(i));
        }
        return list;
    }

    private static List<Point> coordAll(List<Point> list, MultiPoint multiPoint) {
        list.addAll((Collection<Point>)multiPoint.coordinates());
        return list;
    }

    private static List<Point> coordAll(List<Point> list, MultiPolygon multiPolygon, boolean bl) {
        for (int i = 0; i < multiPolygon.coordinates().size(); ++i) {
            for (int j = 0; j < ((List)multiPolygon.coordinates().get(i)).size(); ++j) {
                for (int k = 0; k < ((List)((List)multiPolygon.coordinates().get(i)).get(j)).size() - bl; ++k) {
                    list.add((Point)((List)((List)multiPolygon.coordinates().get(i)).get(j)).get(k));
                }
            }
        }
        return list;
    }

    private static List<Point> coordAll(List<Point> list, Point point) {
        list.add(point);
        return list;
    }

    private static List<Point> coordAll(List<Point> list, Polygon polygon, boolean bl) {
        for (int i = 0; i < polygon.coordinates().size(); ++i) {
            for (int j = 0; j < ((List)polygon.coordinates().get(i)).size() - bl; ++j) {
                list.add((Point)((List)polygon.coordinates().get(i)).get(j));
            }
        }
        return list;
    }

    private static List<Point> coordAllFromSingleGeometry(List<Point> list, Geometry object, boolean bl) {
        if (object instanceof Point) {
            list.add((Point)object);
        } else if (object instanceof MultiPoint) {
            list.addAll((Collection<Point>)((MultiPoint)object).coordinates());
        } else if (object instanceof LineString) {
            list.addAll((Collection<Point>)((LineString)object).coordinates());
        } else if (object instanceof MultiLineString) {
            TurfMeta.coordAll(list, (MultiLineString)object);
        } else if (object instanceof Polygon) {
            TurfMeta.coordAll(list, (Polygon)object, bl);
        } else if (object instanceof MultiPolygon) {
            TurfMeta.coordAll(list, (MultiPolygon)object, bl);
        } else if (object instanceof GeometryCollection) {
            object = ((GeometryCollection)object).geometries().iterator();
            while (object.hasNext()) {
                TurfMeta.coordAllFromSingleGeometry(list, (Geometry)object.next(), bl);
            }
        }
        return list;
    }

    public static Point getCoord(Feature feature) {
        if (feature.geometry() instanceof Point) {
            return (Point)feature.geometry();
        }
        throw new TurfException("A Feature with a Point geometry is required.");
    }
}

