/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import com.mapbox.geojson.Feature;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.turf.TurfException;
import com.mapbox.turf.TurfMeasurement;
import com.mapbox.turf.models.LineIntersectsResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TurfMisc {
    private static final String INDEX_KEY = "index";

    private TurfMisc() {
        throw new AssertionError((Object)"No Instances.");
    }

    private static LineIntersectsResult lineIntersects(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        LineIntersectsResult lineIntersectsResult;
        LineIntersectsResult lineIntersectsResult2 = LineIntersectsResult.builder().onLine1(false).onLine2(false).build();
        double d9 = (d8 -= d6) * (d3 -= d) - (d7 -= d5) * (d4 -= d2);
        if (d9 == 0.0) {
            if (lineIntersectsResult2.horizontalIntersection() != null && lineIntersectsResult2.verticalIntersection() != null) {
                return lineIntersectsResult2;
            }
            return null;
        }
        d6 = d2 - d6;
        d5 = d - d5;
        d7 = (d7 * d6 - d8 * d5) / d9;
        d5 = (d6 * d3 - d5 * d4) / d9;
        lineIntersectsResult2 = lineIntersectsResult = lineIntersectsResult2.toBuilder().horizontalIntersection(d + d3 * d7).build().toBuilder().verticalIntersection(d2 + d4 * d7).build();
        if (d7 > 0.0) {
            lineIntersectsResult2 = lineIntersectsResult;
            if (d7 < 1.0) {
                lineIntersectsResult2 = lineIntersectsResult.toBuilder().onLine1(true).build();
            }
        }
        lineIntersectsResult = lineIntersectsResult2;
        if (d5 > 0.0) {
            lineIntersectsResult = lineIntersectsResult2;
            if (d5 < 1.0) {
                lineIntersectsResult = lineIntersectsResult2.toBuilder().onLine2(true).build();
            }
        }
        if (lineIntersectsResult.onLine1() && lineIntersectsResult.onLine2()) {
            return lineIntersectsResult;
        }
        return null;
    }

    public static LineString lineSlice(Point point, Point point2, Feature feature) {
        Objects.requireNonNull(feature.geometry(), "Feature.geometry() == null");
        if (feature.geometry().type().equals("LineString")) {
            return TurfMisc.lineSlice(point, point2, (LineString)feature.geometry());
        }
        throw new TurfException("input must be a LineString Feature or Geometry");
    }

    public static LineString lineSlice(Point serializable, Point serializable2, LineString object) {
        if ((object = ((LineString)object).coordinates()).size() >= 2) {
            if (!((Point)serializable).equals(serializable2)) {
                Feature feature = TurfMisc.nearestPointOnLine((Point)serializable, (List<Point>)object);
                serializable2 = TurfMisc.nearestPointOnLine((Point)serializable2, (List<Point>)object);
                serializable = new ArrayList();
                if ((Integer)feature.getNumberProperty(INDEX_KEY) <= (Integer)((Feature)serializable2).getNumberProperty(INDEX_KEY)) {
                    serializable.add(feature);
                    serializable.add(serializable2);
                } else {
                    serializable.add(serializable2);
                    serializable.add(feature);
                }
                serializable2 = new ArrayList();
                serializable2.add((Point)((Feature)serializable.get(0)).geometry());
                for (int i = (Integer)((Feature)serializable.get(0)).getNumberProperty(INDEX_KEY) + 1; i < (Integer)((Feature)serializable.get(1)).getNumberProperty(INDEX_KEY) + 1; ++i) {
                    serializable2.add(object.get(i));
                }
                serializable2.add((Point)((Feature)serializable.get(1)).geometry());
                return LineString.fromLngLats((List<Point>)((Object)serializable2));
            }
            throw new TurfException("Start and stop points in Turf lineSlice cannot equal each other.");
        }
        throw new TurfException("Turf lineSlice requires a LineString made up of at least 2 coordinates.");
    }

    public static LineString lineSliceAlong(Feature feature, double d, double d2, String string2) {
        Objects.requireNonNull(feature.geometry(), "Feature.geometry() == null");
        if (feature.geometry().type().equals("LineString")) {
            return TurfMisc.lineSliceAlong((LineString)feature.geometry(), d, d2, string2);
        }
        throw new TurfException("input must be a LineString Feature or Geometry");
    }

    public static LineString lineSliceAlong(LineString object, double d, double d2, String charSequence) {
        if ((object = ((LineString)object).coordinates()).size() >= 2) {
            if (d != d2) {
                double d3;
                Point point;
                ArrayList<Point> arrayList = new ArrayList<Point>(2);
                int n = 0;
                for (d3 = 0.0; !(n >= object.size() || d >= d3 && n == object.size() - 1); d3 += TurfMeasurement.distance(point, (Point)object.get(++n), (String)charSequence)) {
                    double d4 = d3 == d ? 0 : (d3 > d ? 1 : -1);
                    if (d4 > 0 && arrayList.size() == 0) {
                        double d5 = d - d3;
                        if (d5 == 0.0) {
                            arrayList.add((Point)object.get(n));
                            return LineString.fromLngLats(arrayList);
                        }
                        double d6 = TurfMeasurement.bearing((Point)object.get(n), (Point)object.get(n - 1));
                        arrayList.add(TurfMeasurement.destination((Point)object.get(n), d5, d6 - 180.0, (String)charSequence));
                    }
                    if (d3 >= d2) {
                        if ((d2 -= d3) == 0.0) {
                            arrayList.add((Point)object.get(n));
                            return LineString.fromLngLats(arrayList);
                        }
                        d = TurfMeasurement.bearing((Point)object.get(n), (Point)object.get(n - 1));
                        arrayList.add(TurfMeasurement.destination((Point)object.get(n), d2, d - 180.0, (String)charSequence));
                        return LineString.fromLngLats(arrayList);
                    }
                    if (d4 >= 0) {
                        arrayList.add((Point)object.get(n));
                    }
                    if (n == object.size() - 1) {
                        return LineString.fromLngLats(arrayList);
                    }
                    point = (Point)object.get(n);
                }
                if (!(d3 < d)) {
                    return LineString.fromLngLats(arrayList);
                }
                throw new TurfException("Start position is beyond line");
            }
            throw new TurfException("Start and stop distance in Turf lineSliceAlong cannot equal each other.");
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Turf lineSlice requires a LineString Geometry made up of at least 2 coordinates. The LineString passed in only contains ");
        ((StringBuilder)charSequence).append(object.size());
        ((StringBuilder)charSequence).append(".");
        throw new TurfException(((StringBuilder)charSequence).toString());
    }

    public static Feature nearestPointOnLine(Point point, List<Point> list) {
        return TurfMisc.nearestPointOnLine(point, list, null);
    }

    public static Feature nearestPointOnLine(Point point, List<Point> list, String object) {
        if (list.size() >= 2) {
            Object object2 = object == null ? "kilometers" : object;
            object = Feature.fromGeometry(Point.fromLngLat(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
            ((Feature)object).addNumberProperty("dist", Double.POSITIVE_INFINITY);
            int n = 0;
            while (n < list.size() - 1) {
                Feature feature = Feature.fromGeometry(list.get(n));
                int n2 = n + 1;
                Feature feature2 = Feature.fromGeometry(list.get(n2));
                feature.addNumberProperty("dist", TurfMeasurement.distance(point, (Point)feature.geometry(), (String)object2));
                feature2.addNumberProperty("dist", TurfMeasurement.distance(point, (Point)feature2.geometry(), (String)object2));
                double d = Math.max(feature.properties().get("dist").getAsDouble(), feature2.properties().get("dist").getAsDouble());
                double d2 = TurfMeasurement.bearing((Point)feature.geometry(), (Point)feature2.geometry());
                Feature feature3 = Feature.fromGeometry(TurfMeasurement.destination(point, d, d2 + 90.0, (String)object2));
                Object object3 = Feature.fromGeometry(TurfMeasurement.destination(point, d, d2 - 90.0, (String)object2));
                object3 = TurfMisc.lineIntersects(((Point)feature3.geometry()).longitude(), ((Point)feature3.geometry()).latitude(), ((Point)((Feature)object3).geometry()).longitude(), ((Point)((Feature)object3).geometry()).latitude(), ((Point)feature.geometry()).longitude(), ((Point)feature.geometry()).latitude(), ((Point)feature2.geometry()).longitude(), ((Point)feature2.geometry()).latitude());
                feature3 = null;
                if (object3 != null) {
                    feature3 = Feature.fromGeometry(Point.fromLngLat(((LineIntersectsResult)object3).horizontalIntersection(), ((LineIntersectsResult)object3).verticalIntersection()));
                    feature3.addNumberProperty("dist", TurfMeasurement.distance(point, (Point)feature3.geometry(), (String)object2));
                }
                object3 = object;
                if ((Double)feature.getNumberProperty("dist") < (Double)((Feature)object).getNumberProperty("dist")) {
                    feature.addNumberProperty(INDEX_KEY, n);
                    object3 = feature;
                }
                if ((Double)feature2.getNumberProperty("dist") < (Double)((Feature)object3).getNumberProperty("dist")) {
                    feature2.addNumberProperty(INDEX_KEY, n);
                    object = feature2;
                } else {
                    object = object3;
                }
                if (feature3 != null && (Double)feature3.getNumberProperty("dist") < (Double)((Feature)object).getNumberProperty("dist")) {
                    feature3.addNumberProperty(INDEX_KEY, n);
                    object = feature3;
                }
                n = n2;
            }
            return object;
        }
        throw new TurfException("Turf nearestPointOnLine requires a List of Points made up of at least 2 coordinates.");
    }
}

