/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson;

import com.qb.gson.JsonDeserializationContext;
import com.qb.gson.JsonDeserializer;
import com.qb.gson.JsonElement;
import com.qb.gson.JsonParseException;
import com.qb.gson.JsonPrimitive;
import com.qb.gson.JsonSerializationContext;
import com.qb.gson.JsonSerializer;
import com.qb.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class DefaultDateTypeAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private final DateFormat enUsFormat;
    private final DateFormat iso8601Format;
    private final DateFormat localFormat;

    DefaultDateTypeAdapter() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    DefaultDateTypeAdapter(int n) {
        this(DateFormat.getDateInstance(n, Locale.US), DateFormat.getDateInstance(n));
    }

    public DefaultDateTypeAdapter(int n, int n2) {
        this(DateFormat.getDateTimeInstance(n, n2, Locale.US), DateFormat.getDateTimeInstance(n, n2));
    }

    DefaultDateTypeAdapter(String string2) {
        this(new SimpleDateFormat(string2, Locale.US), new SimpleDateFormat(string2));
    }

    DefaultDateTypeAdapter(DateFormat dateFormat, DateFormat dateFormat2) {
        this.enUsFormat = dateFormat;
        this.localFormat = dateFormat2;
        this.iso8601Format = dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date deserializeToDate(JsonElement jsonElement) {
        DateFormat dateFormat = this.localFormat;
        synchronized (dateFormat) {
            try {
                try {
                    return this.localFormat.parse(jsonElement.getAsString());
                }
                catch (ParseException parseException) {
                    try {
                        return this.enUsFormat.parse(jsonElement.getAsString());
                    }
                    catch (ParseException parseException2) {
                        try {
                            return this.iso8601Format.parse(jsonElement.getAsString());
                        }
                        catch (ParseException parseException3) {
                            JsonSyntaxException jsonSyntaxException = new JsonSyntaxException(jsonElement.getAsString(), parseException3);
                            throw jsonSyntaxException;
                        }
                    }
                }
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    @Override
    public Date deserialize(JsonElement object, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (object instanceof JsonPrimitive) {
            object = this.deserializeToDate((JsonElement)object);
            if (type == Date.class) {
                return object;
            }
            if (type == Timestamp.class) {
                return new Timestamp(((Date)object).getTime());
            }
            if (type == java.sql.Date.class) {
                return new java.sql.Date(((Date)object).getTime());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(this.getClass());
            ((StringBuilder)object).append(" cannot deserialize to ");
            ((StringBuilder)object).append(type);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        throw new JsonParseException("The date should be a string value");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonElement serialize(Date object, Type object2, JsonSerializationContext object3) {
        object2 = this.localFormat;
        synchronized (object2) {
            object = this.enUsFormat.format((Date)object);
            return new JsonPrimitive((String)object);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DefaultDateTypeAdapter");
        stringBuilder.append('(');
        stringBuilder.append(this.localFormat.getClass().getSimpleName());
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

