/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson;

import com.qb.gson.FieldNamingPolicy;
import com.qb.gson.FieldNamingStrategy;
import com.qb.gson.InstanceCreator;
import com.qb.gson.JsonDeserializationContext;
import com.qb.gson.JsonElement;
import com.qb.gson.JsonIOException;
import com.qb.gson.JsonNull;
import com.qb.gson.JsonParseException;
import com.qb.gson.JsonSerializationContext;
import com.qb.gson.JsonSyntaxException;
import com.qb.gson.LongSerializationPolicy;
import com.qb.gson.TypeAdapter;
import com.qb.gson.TypeAdapterFactory;
import com.qb.gson.internal.ConstructorConstructor;
import com.qb.gson.internal.Excluder;
import com.qb.gson.internal.Primitives;
import com.qb.gson.internal.Streams;
import com.qb.gson.internal.bind.ArrayTypeAdapter;
import com.qb.gson.internal.bind.CollectionTypeAdapterFactory;
import com.qb.gson.internal.bind.DateTypeAdapter;
import com.qb.gson.internal.bind.JsonTreeReader;
import com.qb.gson.internal.bind.JsonTreeWriter;
import com.qb.gson.internal.bind.MapTypeAdapterFactory;
import com.qb.gson.internal.bind.ObjectTypeAdapter;
import com.qb.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.qb.gson.internal.bind.SqlDateTypeAdapter;
import com.qb.gson.internal.bind.TimeTypeAdapter;
import com.qb.gson.internal.bind.TypeAdapters;
import com.qb.gson.reflect.TypeToken;
import com.qb.gson.stream.JsonReader;
import com.qb.gson.stream.JsonToken;
import com.qb.gson.stream.JsonWriter;
import com.qb.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Gson {
    static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    private static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    private final ThreadLocal<Map<TypeToken<?>, FutureTypeAdapter<?>>> calls = new ThreadLocal<Map<TypeToken<?>, FutureTypeAdapter<?>>>(){

        @Override
        protected Map<TypeToken<?>, FutureTypeAdapter<?>> initialValue() {
            return new HashMap();
        }
    };
    private final ConstructorConstructor constructorConstructor;
    final JsonDeserializationContext deserializationContext;
    private final List<TypeAdapterFactory> factories;
    private final boolean generateNonExecutableJson;
    private final boolean htmlSafe;
    private final boolean prettyPrinting;
    final JsonSerializationContext serializationContext;
    private final boolean serializeNulls;
    private final Map<TypeToken<?>, TypeAdapter<?>> typeTokenCache = Collections.synchronizedMap(new HashMap());

    public Gson() {
        this(Excluder.DEFAULT, FieldNamingPolicy.IDENTITY, Collections.emptyMap(), false, false, false, true, false, false, LongSerializationPolicy.DEFAULT, Collections.emptyList());
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingStrategy, Map<Type, InstanceCreator<?>> object, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, LongSerializationPolicy longSerializationPolicy, List<TypeAdapterFactory> list) {
        this.deserializationContext = new JsonDeserializationContext(){

            @Override
            public <T> T deserialize(JsonElement jsonElement, Type type) throws JsonParseException {
                return Gson.this.fromJson(jsonElement, type);
            }
        };
        this.serializationContext = new JsonSerializationContext(){

            @Override
            public JsonElement serialize(Object object) {
                return Gson.this.toJsonTree(object);
            }

            @Override
            public JsonElement serialize(Object object, Type type) {
                return Gson.this.toJsonTree(object, type);
            }
        };
        this.constructorConstructor = object = new ConstructorConstructor((Map<Type, InstanceCreator<?>>)object);
        this.serializeNulls = bl;
        this.generateNonExecutableJson = bl3;
        this.htmlSafe = bl4;
        this.prettyPrinting = bl5;
        ArrayList<TypeAdapterFactory> arrayList = new ArrayList<TypeAdapterFactory>();
        arrayList.add(TypeAdapters.STRING_FACTORY);
        arrayList.add(TypeAdapters.INTEGER_FACTORY);
        arrayList.add(TypeAdapters.BOOLEAN_FACTORY);
        arrayList.add(TypeAdapters.BYTE_FACTORY);
        arrayList.add(TypeAdapters.SHORT_FACTORY);
        arrayList.add(TypeAdapters.newFactory(Long.TYPE, Long.class, this.longAdapter(longSerializationPolicy)));
        arrayList.add(TypeAdapters.newFactory(Double.TYPE, Double.class, this.doubleAdapter(bl6)));
        arrayList.add(TypeAdapters.newFactory(Float.TYPE, Float.class, this.floatAdapter(bl6)));
        arrayList.add(excluder);
        arrayList.add(TypeAdapters.NUMBER_FACTORY);
        arrayList.add(TypeAdapters.CHARACTER_FACTORY);
        arrayList.add(TypeAdapters.STRING_BUILDER_FACTORY);
        arrayList.add(TypeAdapters.STRING_BUFFER_FACTORY);
        arrayList.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        arrayList.add(ObjectTypeAdapter.FACTORY);
        arrayList.addAll(list);
        arrayList.add(TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        arrayList.add(TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        arrayList.add(new CollectionTypeAdapterFactory((ConstructorConstructor)object));
        arrayList.add(TypeAdapters.URL_FACTORY);
        arrayList.add(TypeAdapters.URI_FACTORY);
        arrayList.add(TypeAdapters.UUID_FACTORY);
        arrayList.add(TypeAdapters.LOCALE_FACTORY);
        arrayList.add(TypeAdapters.INET_ADDRESS_FACTORY);
        arrayList.add(TypeAdapters.BIT_SET_FACTORY);
        arrayList.add(DateTypeAdapter.FACTORY);
        arrayList.add(TypeAdapters.CALENDAR_FACTORY);
        arrayList.add(TimeTypeAdapter.FACTORY);
        arrayList.add(SqlDateTypeAdapter.FACTORY);
        arrayList.add(TypeAdapters.TIMESTAMP_FACTORY);
        arrayList.add(new MapTypeAdapterFactory((ConstructorConstructor)object, bl2));
        arrayList.add(ArrayTypeAdapter.FACTORY);
        arrayList.add(TypeAdapters.ENUM_FACTORY);
        arrayList.add(TypeAdapters.CLASS_FACTORY);
        arrayList.add(new ReflectiveTypeAdapterFactory((ConstructorConstructor)object, fieldNamingStrategy, excluder));
        this.factories = Collections.unmodifiableList(arrayList);
    }

    private static void assertFullConsumption(Object object, JsonReader jsonReader) {
        if (object != null) {
            try {
                if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                    object = new JsonIOException("JSON document was not fully consumed.");
                    throw object;
                }
            }
            catch (IOException iOException) {
                throw new JsonIOException(iOException);
            }
            catch (MalformedJsonException malformedJsonException) {
                throw new JsonSyntaxException(malformedJsonException);
            }
        }
    }

    private void checkValidFloatingPoint(double d) {
        if (!Double.isNaN(d) && !Double.isInfinite(d)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(d);
        stringBuilder.append(" is not a valid double value as per JSON specification. To override this");
        stringBuilder.append(" behavior, use GsonBuilder.serializeSpecialDoubleValues() method.");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private TypeAdapter<Number> doubleAdapter(boolean bl) {
        if (bl) {
            return TypeAdapters.DOUBLE;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Double read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextDouble();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                double d = number.doubleValue();
                Gson.this.checkValidFloatingPoint(d);
                jsonWriter.value(number);
            }
        };
    }

    private TypeAdapter<Number> floatAdapter(boolean bl) {
        if (bl) {
            return TypeAdapters.FLOAT;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Float read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Float.valueOf((float)jsonReader.nextDouble());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                float f = number.floatValue();
                Gson.this.checkValidFloatingPoint(f);
                jsonWriter.value(number);
            }
        };
    }

    private TypeAdapter<Number> longAdapter(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return TypeAdapters.LONG;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextLong();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.value(number.toString());
            }
        };
    }

    private JsonWriter newJsonWriter(Writer closeable) throws IOException {
        if (this.generateNonExecutableJson) {
            ((Writer)closeable).write(JSON_NON_EXECUTABLE_PREFIX);
        }
        closeable = new JsonWriter((Writer)closeable);
        if (this.prettyPrinting) {
            ((JsonWriter)closeable).setIndent("  ");
        }
        ((JsonWriter)closeable).setSerializeNulls(this.serializeNulls);
        return closeable;
    }

    public <T> T fromJson(JsonElement jsonElement, Class<T> clazz) throws JsonSyntaxException {
        jsonElement = this.fromJson(jsonElement, (Type)clazz);
        return Primitives.wrap(clazz).cast(jsonElement);
    }

    public <T> T fromJson(JsonElement jsonElement, Type type) throws JsonSyntaxException {
        if (jsonElement == null) {
            return null;
        }
        return this.fromJson(new JsonTreeReader(jsonElement), type);
    }

    /*
     * Exception decompiling
     */
    public <T> T fromJson(JsonReader var1_1, Type var2_2) throws JsonIOException, JsonSyntaxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [8 : 46->60)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> T fromJson(Reader closeable, Class<T> clazz) throws JsonSyntaxException, JsonIOException {
        closeable = new JsonReader((Reader)closeable);
        T t = this.fromJson((JsonReader)closeable, clazz);
        Gson.assertFullConsumption(t, (JsonReader)closeable);
        return Primitives.wrap(clazz).cast(t);
    }

    public <T> T fromJson(Reader closeable, Type type) throws JsonIOException, JsonSyntaxException {
        closeable = new JsonReader((Reader)closeable);
        type = this.fromJson((JsonReader)closeable, type);
        Gson.assertFullConsumption(type, (JsonReader)closeable);
        return (T)type;
    }

    public <T> T fromJson(String string2, Class<T> clazz) throws JsonSyntaxException {
        string2 = this.fromJson(string2, (Type)clazz);
        return Primitives.wrap(clazz).cast(string2);
    }

    public <T> T fromJson(String string2, Type type) throws JsonSyntaxException {
        if (string2 == null) {
            return null;
        }
        return this.fromJson((Reader)new StringReader(string2), type);
    }

    public <T> TypeAdapter<T> getAdapter(TypeToken<T> typeToken) {
        Object object = this.typeTokenCache.get(typeToken);
        if (object != null) {
            return object;
        }
        object = this.calls.get();
        FutureTypeAdapter futureTypeAdapter = (FutureTypeAdapter)object.get(typeToken);
        if (futureTypeAdapter != null) {
            return futureTypeAdapter;
        }
        FutureTypeAdapter<T> futureTypeAdapter2 = new FutureTypeAdapter<T>();
        object.put(typeToken, futureTypeAdapter2);
        try {
            Object object2 = this.factories.iterator();
            while (object2.hasNext()) {
                futureTypeAdapter = object2.next().create(this, typeToken);
                if (futureTypeAdapter == null) continue;
                futureTypeAdapter2.setDelegate(futureTypeAdapter);
                this.typeTokenCache.put(typeToken, futureTypeAdapter);
                return futureTypeAdapter;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("GSON cannot handle ");
            ((StringBuilder)object2).append(typeToken);
            futureTypeAdapter = new FutureTypeAdapter(((StringBuilder)object2).toString());
            throw futureTypeAdapter;
        }
        finally {
            object.remove(typeToken);
        }
    }

    public <T> TypeAdapter<T> getAdapter(Class<T> clazz) {
        return this.getAdapter(TypeToken.get(clazz));
    }

    public <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory object, TypeToken<T> typeToken) {
        Iterator<TypeAdapterFactory> iterator2 = this.factories.iterator();
        boolean bl = false;
        while (iterator2.hasNext()) {
            Object object2 = iterator2.next();
            if (!bl) {
                if (object2 != object) continue;
                bl = true;
                continue;
            }
            if ((object2 = object2.create(this, typeToken)) == null) continue;
            return object2;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("GSON cannot serialize ");
        ((StringBuilder)object).append(typeToken);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public String toJson(JsonElement jsonElement) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(jsonElement, (Appendable)stringWriter);
        return stringWriter.toString();
    }

    public String toJson(Object object) {
        if (object == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        return this.toJson(object, object.getClass());
    }

    public String toJson(Object object, Type type) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, type, stringWriter);
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toJson(JsonElement jsonElement, JsonWriter jsonWriter) throws JsonIOException {
        Throwable throwable2222222;
        boolean bl = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl2 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        boolean bl3 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.serializeNulls);
        Streams.write(jsonElement, jsonWriter);
        jsonWriter.setLenient(bl);
        jsonWriter.setHtmlSafe(bl2);
        jsonWriter.setSerializeNulls(bl3);
        return;
        {
            catch (Throwable throwable2222222) {
            }
            catch (IOException iOException) {}
            {
                JsonIOException jsonIOException = new JsonIOException(iOException);
                throw jsonIOException;
            }
        }
        jsonWriter.setLenient(bl);
        jsonWriter.setHtmlSafe(bl2);
        jsonWriter.setSerializeNulls(bl3);
        throw throwable2222222;
    }

    public void toJson(JsonElement jsonElement, Appendable appendable) throws JsonIOException {
        try {
            this.toJson(jsonElement, this.newJsonWriter(Streams.writerForAppendable(appendable)));
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void toJson(Object object, Appendable appendable) throws JsonIOException {
        if (object != null) {
            this.toJson(object, object.getClass(), appendable);
        } else {
            this.toJson((JsonElement)JsonNull.INSTANCE, appendable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toJson(Object object, Type object2, JsonWriter jsonWriter) throws JsonIOException {
        Throwable throwable2222222;
        object2 = this.getAdapter(TypeToken.get((Type)object2));
        boolean bl = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl2 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        boolean bl3 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.serializeNulls);
        ((TypeAdapter)object2).write(jsonWriter, object);
        jsonWriter.setLenient(bl);
        jsonWriter.setHtmlSafe(bl2);
        jsonWriter.setSerializeNulls(bl3);
        return;
        {
            catch (Throwable throwable2222222) {
            }
            catch (IOException iOException) {}
            {
                object2 = new JsonIOException(iOException);
                throw object2;
            }
        }
        jsonWriter.setLenient(bl);
        jsonWriter.setHtmlSafe(bl2);
        jsonWriter.setSerializeNulls(bl3);
        throw throwable2222222;
    }

    public void toJson(Object object, Type type, Appendable appendable) throws JsonIOException {
        try {
            this.toJson(object, type, this.newJsonWriter(Streams.writerForAppendable(appendable)));
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public JsonElement toJsonTree(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        return this.toJsonTree(object, object.getClass());
    }

    public JsonElement toJsonTree(Object object, Type type) {
        JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
        this.toJson(object, type, jsonTreeWriter);
        return jsonTreeWriter.get();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("serializeNulls:");
        stringBuilder.append(this.serializeNulls);
        stringBuilder.append("factories:");
        stringBuilder.append(this.factories);
        stringBuilder.append(",instanceCreators:");
        stringBuilder.append(this.constructorConstructor);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static class FutureTypeAdapter<T>
    extends TypeAdapter<T> {
        private TypeAdapter<T> delegate;

        FutureTypeAdapter() {
        }

        @Override
        public T read(JsonReader jsonReader) throws IOException {
            TypeAdapter<T> typeAdapter = this.delegate;
            if (typeAdapter != null) {
                return typeAdapter.read(jsonReader);
            }
            throw new IllegalStateException();
        }

        public void setDelegate(TypeAdapter<T> typeAdapter) {
            if (this.delegate == null) {
                this.delegate = typeAdapter;
                return;
            }
            throw new AssertionError();
        }

        @Override
        public void write(JsonWriter jsonWriter, T t) throws IOException {
            TypeAdapter<T> typeAdapter = this.delegate;
            if (typeAdapter != null) {
                typeAdapter.write(jsonWriter, t);
                return;
            }
            throw new IllegalStateException();
        }
    }
}

