/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson;

import com.qb.gson.JsonElement;
import com.qb.gson.JsonIOException;
import com.qb.gson.JsonNull;
import com.qb.gson.JsonParseException;
import com.qb.gson.JsonSyntaxException;
import com.qb.gson.internal.Streams;
import com.qb.gson.stream.JsonReader;
import com.qb.gson.stream.JsonToken;
import com.qb.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public JsonElement parse(JsonReader jsonReader) throws JsonIOException, JsonSyntaxException {
        Throwable throwable22;
        boolean bl = jsonReader.isLenient();
        jsonReader.setLenient(true);
        JsonElement jsonElement = Streams.parse(jsonReader);
        jsonReader.setLenient(bl);
        return jsonElement;
        {
            catch (Throwable throwable22) {
            }
            catch (JsonParseException jsonParseException) {}
            {
                if (!(jsonParseException.getCause() instanceof EOFException)) throw jsonParseException;
                JsonNull jsonNull = JsonNull.INSTANCE;
                jsonReader.setLenient(bl);
                return jsonNull;
            }
        }
        {
            catch (OutOfMemoryError outOfMemoryError) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Failed parsing JSON source: ");
                stringBuilder.append(jsonReader);
                stringBuilder.append(" to Json");
                JsonParseException jsonParseException = new JsonParseException(stringBuilder.toString(), outOfMemoryError);
                throw jsonParseException;
            }
            catch (StackOverflowError stackOverflowError) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Failed parsing JSON source: ");
                stringBuilder.append(jsonReader);
                stringBuilder.append(" to Json");
                JsonParseException jsonParseException = new JsonParseException(stringBuilder.toString(), stackOverflowError);
                throw jsonParseException;
            }
        }
        jsonReader.setLenient(bl);
        throw throwable22;
    }

    public JsonElement parse(Reader object) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader((Reader)object);
            object = this.parse(jsonReader);
            if (!((JsonElement)object).isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                object = new JsonSyntaxException("Did not consume the entire document.");
                throw object;
            }
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException(numberFormatException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
    }

    public JsonElement parse(String string2) throws JsonSyntaxException {
        return this.parse(new StringReader(string2));
    }
}

