/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson;

import com.qb.gson.JsonElement;
import com.qb.gson.JsonIOException;
import com.qb.gson.internal.bind.JsonTreeReader;
import com.qb.gson.internal.bind.JsonTreeWriter;
import com.qb.gson.stream.JsonReader;
import com.qb.gson.stream.JsonToken;
import com.qb.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public abstract class TypeAdapter<T> {
    public final T fromJson(Reader reader) throws IOException {
        return this.read(new JsonReader(reader));
    }

    public final T fromJson(String string2) throws IOException {
        return this.fromJson(new StringReader(string2));
    }

    public final T fromJsonTree(JsonElement jsonElement) {
        try {
            JsonTreeReader jsonTreeReader = new JsonTreeReader(jsonElement);
            jsonElement = this.read(jsonTreeReader);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        return (T)jsonElement;
    }

    public final TypeAdapter<T> nullSafe() {
        return new TypeAdapter<T>(){

            @Override
            public T read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return TypeAdapter.this.read(jsonReader);
            }

            @Override
            public void write(JsonWriter jsonWriter, T t) throws IOException {
                if (t == null) {
                    jsonWriter.nullValue();
                } else {
                    TypeAdapter.this.write(jsonWriter, t);
                }
            }
        };
    }

    public abstract T read(JsonReader var1) throws IOException;

    public final String toJson(T t) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.toJson(stringWriter, t);
        return stringWriter.toString();
    }

    public final void toJson(Writer writer, T t) throws IOException {
        this.write(new JsonWriter(writer), t);
    }

    public final JsonElement toJsonTree(T object) {
        try {
            JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
            this.write(jsonTreeWriter, object);
            object = jsonTreeWriter.get();
            return object;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public abstract void write(JsonWriter var1, T var2) throws IOException;
}

