/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson.internal;

import com.qb.gson.InstanceCreator;
import com.qb.gson.internal.ObjectConstructor;
import com.qb.gson.internal.UnsafeAllocator;
import com.qb.gson.reflect.TypeToken;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ConstructorConstructor {
    private final Map<Type, InstanceCreator<?>> instanceCreators;

    public ConstructorConstructor() {
        this(Collections.emptyMap());
    }

    public ConstructorConstructor(Map<Type, InstanceCreator<?>> map) {
        this.instanceCreators = map;
    }

    private <T> ObjectConstructor<T> newDefaultConstructor(Class<? super T> object) {
        try {
            object = ((Class)object).getDeclaredConstructor(new Class[0]);
            if (!((AccessibleObject)object).isAccessible()) {
                ((Constructor)object).setAccessible(true);
            }
            object = new ObjectConstructor<T>((Constructor)object){
                final /* synthetic */ Constructor val$constructor;
                {
                    this.val$constructor = constructor;
                }

                @Override
                public T construct() {
                    Object t;
                    try {
                        t = this.val$constructor.newInstance(null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Failed to invoke ");
                        stringBuilder.append(this.val$constructor);
                        stringBuilder.append(" with no args");
                        throw new RuntimeException(stringBuilder.toString(), invocationTargetException.getTargetException());
                    }
                    catch (InstantiationException instantiationException) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Failed to invoke ");
                        stringBuilder.append(this.val$constructor);
                        stringBuilder.append(" with no args");
                        throw new RuntimeException(stringBuilder.toString(), instantiationException);
                    }
                    return t;
                }
            };
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <T> ObjectConstructor<T> newDefaultImplementationConstructor(Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeSet();
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedList();
                    }
                };
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new LinkedHashMap();
                }
            };
        }
        return null;
    }

    private <T> ObjectConstructor<T> newUnsafeAllocator(final Type type, final Class<? super T> clazz) {
        return new ObjectConstructor<T>(){
            private final UnsafeAllocator unsafeAllocator = UnsafeAllocator.create();

            @Override
            public T construct() {
                Object t;
                try {
                    t = this.unsafeAllocator.newInstance(clazz);
                }
                catch (Exception exception) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unable to invoke no-args constructor for ");
                    stringBuilder.append(type);
                    stringBuilder.append(". ");
                    stringBuilder.append("Register an InstanceCreator with Gson for this type may fix this problem.");
                    throw new RuntimeException(stringBuilder.toString(), exception);
                }
                return t;
            }
        };
    }

    public <T> ObjectConstructor<T> get(TypeToken<T> object) {
        Type type = ((TypeToken)object).getType();
        object = ((TypeToken)object).getRawType();
        ObjectConstructor<T> objectConstructor = this.instanceCreators.get(type);
        if (objectConstructor != null) {
            return new ObjectConstructor<T>((InstanceCreator)objectConstructor, type){
                final /* synthetic */ InstanceCreator val$creator;
                final /* synthetic */ Type val$type;
                {
                    this.val$creator = instanceCreator;
                    this.val$type = type;
                }

                @Override
                public T construct() {
                    return this.val$creator.createInstance(this.val$type);
                }
            };
        }
        objectConstructor = this.newDefaultConstructor((Class<? super T>)object);
        if (objectConstructor != null) {
            return objectConstructor;
        }
        objectConstructor = this.newDefaultImplementationConstructor((Class<? super T>)object);
        if (objectConstructor != null) {
            return objectConstructor;
        }
        return this.newUnsafeAllocator(type, (Class<? super T>)object);
    }

    public String toString() {
        return this.instanceCreators.toString();
    }
}

