/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson.internal.bind;

import com.qb.gson.Gson;
import com.qb.gson.TypeAdapter;
import com.qb.gson.TypeAdapterFactory;
import com.qb.gson.internal.StringMap;
import com.qb.gson.reflect.TypeToken;
import com.qb.gson.stream.JsonReader;
import com.qb.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class ObjectTypeAdapter
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.getRawType() == Object.class) {
                return new ObjectTypeAdapter(gson);
            }
            return null;
        }
    };
    private final Gson gson;

    private ObjectTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Object read(JsonReader jsonReader) throws IOException {
        Object object = jsonReader.peek();
        switch (2.$SwitchMap$com$google$gson$stream$JsonToken[((Enum)object).ordinal()]) {
            default: {
                throw new IllegalStateException();
            }
            case 6: {
                jsonReader.nextNull();
                return null;
            }
            case 5: {
                return jsonReader.nextBoolean();
            }
            case 4: {
                return jsonReader.nextDouble();
            }
            case 3: {
                return jsonReader.nextString();
            }
            case 2: {
                object = new StringMap();
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    object.put(jsonReader.nextName(), this.read(jsonReader));
                }
                jsonReader.endObject();
                return object;
            }
            case 1: 
        }
        object = new ArrayList();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            object.add(this.read(jsonReader));
        }
        jsonReader.endArray();
        return object;
    }

    @Override
    public void write(JsonWriter jsonWriter, Object object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        TypeAdapter<?> typeAdapter = this.gson.getAdapter(object.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            jsonWriter.beginObject();
            jsonWriter.endObject();
            return;
        }
        typeAdapter.write(jsonWriter, object);
    }
}

