/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson.internal.bind;

import com.qb.gson.FieldNamingStrategy;
import com.qb.gson.Gson;
import com.qb.gson.JsonSyntaxException;
import com.qb.gson.TypeAdapter;
import com.qb.gson.TypeAdapterFactory;
import com.qb.gson.annotations.SerializedName;
import com.qb.gson.internal.$Gson$Types;
import com.qb.gson.internal.ConstructorConstructor;
import com.qb.gson.internal.Excluder;
import com.qb.gson.internal.ObjectConstructor;
import com.qb.gson.internal.Primitives;
import com.qb.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.qb.gson.reflect.TypeToken;
import com.qb.gson.stream.JsonReader;
import com.qb.gson.stream.JsonToken;
import com.qb.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final Excluder excluder;
    private final FieldNamingStrategy fieldNamingPolicy;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
    }

    private BoundField createBoundField(final Gson gson, final Field field, String string2, final TypeToken<?> typeToken, boolean bl, boolean bl2) {
        return new BoundField(string2, bl, bl2, Primitives.isPrimitive(typeToken.getRawType())){
            final TypeAdapter<?> typeAdapter;
            final /* synthetic */ boolean val$isPrimitive;
            {
                this.val$isPrimitive = bl3;
                super(string2, bl, bl2);
                this.typeAdapter = gson2.getAdapter(typeToken2);
            }

            @Override
            void read(JsonReader jsonReader, Object object) throws IOException, IllegalAccessException {
                if ((jsonReader = this.typeAdapter.read(jsonReader)) != null || !this.val$isPrimitive) {
                    field.set(object, jsonReader);
                }
            }

            @Override
            void write(JsonWriter jsonWriter, Object object) throws IOException, IllegalAccessException {
                object = field.get(object);
                ((TypeAdapter)new TypeAdapterRuntimeTypeWrapper(gson, this.typeAdapter, typeToken.getType())).write(jsonWriter, object);
            }
        };
    }

    private Map<String, BoundField> getBoundFields(Gson object, TypeToken<?> clazz, Class<?> typeToken) {
        LinkedHashMap<String, BoundField> linkedHashMap = new LinkedHashMap<String, BoundField>();
        if (((Class)((Object)typeToken)).isInterface()) {
            return linkedHashMap;
        }
        Type type = ((TypeToken)((Object)clazz)).getType();
        Field[] fieldArray = clazz;
        clazz = typeToken;
        typeToken = fieldArray;
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                boolean bl = this.excludeField(field, true);
                boolean bl2 = this.excludeField(field, false);
                if (!bl && !bl2) continue;
                field.setAccessible(true);
                Object object2 = $Gson$Types.resolve(typeToken.getType(), clazz, field.getGenericType());
                object2 = this.createBoundField((Gson)object, field, this.getFieldName(field), TypeToken.get((Type)object2), bl, bl2);
                object2 = linkedHashMap.put(((BoundField)object2).name, (BoundField)object2);
                if (object2 == null) {
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append(type);
                ((StringBuilder)object).append(" declares multiple JSON fields named ");
                ((StringBuilder)object).append(((BoundField)object2).name);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            typeToken = TypeToken.get($Gson$Types.resolve(typeToken.getType(), clazz, clazz.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return linkedHashMap;
    }

    private String getFieldName(Field object) {
        SerializedName serializedName = ((Field)object).getAnnotation(SerializedName.class);
        object = serializedName == null ? this.fieldNamingPolicy.translateName((Field)object) : serializedName.value();
        return object;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class<T> clazz = typeToken.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        return new Adapter(this.constructorConstructor.get(typeToken), this.getBoundFields(gson, typeToken, clazz));
    }

    public boolean excludeField(Field field, boolean bl) {
        bl = !this.excluder.excludeClass(field.getType(), bl) && !this.excluder.excludeField(field, bl);
        return bl;
    }

    public final class Adapter<T>
    extends TypeAdapter<T> {
        private final Map<String, BoundField> boundFields;
        private final ObjectConstructor<T> constructor;

        private Adapter(ObjectConstructor<T> objectConstructor, Map<String, BoundField> map) {
            this.constructor = objectConstructor;
            this.boundFields = map;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            T t = this.constructor.construct();
            try {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    Object object = jsonReader.nextName();
                    if ((object = this.boundFields.get(object)) != null && ((BoundField)object).deserialized) {
                        ((BoundField)object).read(jsonReader, t);
                        continue;
                    }
                    jsonReader.skipValue();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (IllegalStateException illegalStateException) {
                throw new JsonSyntaxException(illegalStateException);
            }
            jsonReader.endObject();
            return t;
        }

        @Override
        public void write(JsonWriter jsonWriter, T t) throws IOException {
            if (t == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            try {
                for (BoundField boundField : this.boundFields.values()) {
                    if (!boundField.serialized) continue;
                    jsonWriter.name(boundField.name);
                    boundField.write(jsonWriter, t);
                }
                jsonWriter.endObject();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
    }

    static abstract class BoundField {
        final boolean deserialized;
        final String name;
        final boolean serialized;

        protected BoundField(String string2, boolean bl, boolean bl2) {
            this.name = string2;
            this.serialized = bl;
            this.deserialized = bl2;
        }

        abstract void read(JsonReader var1, Object var2) throws IOException, IllegalAccessException;

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;
    }
}

