/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson.stream;

import com.qb.gson.internal.JsonReaderInternalAccess;
import com.qb.gson.internal.bind.JsonTreeReader;
import com.qb.gson.stream.JsonScope;
import com.qb.gson.stream.JsonToken;
import com.qb.gson.stream.MalformedJsonException;
import com.qb.gson.stream.StringPool;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;

public class JsonReader
implements Closeable {
    private static final String FALSE = "false";
    private static final char[] NON_EXECUTE_PREFIX = ")]}'\n".toCharArray();
    private static final String TRUE = "true";
    private final char[] buffer;
    private int bufferStartColumn = 1;
    private int bufferStartLine = 1;
    private final Reader in;
    private boolean lenient = false;
    private int limit = 0;
    private String name;
    private int pos = 0;
    private boolean skipping;
    private JsonScope[] stack;
    private int stackSize = 0;
    private final StringPool stringPool = new StringPool();
    private JsonToken token;
    private String value;
    private int valueLength;
    private int valuePos;

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            @Override
            public void promoteNameToValue(JsonReader jsonReader) throws IOException {
                if (jsonReader instanceof JsonTreeReader) {
                    ((JsonTreeReader)jsonReader).promoteNameToValue();
                    return;
                }
                jsonReader.peek();
                if (jsonReader.token == JsonToken.NAME) {
                    JsonReader.access$302(jsonReader, jsonReader.name);
                    JsonReader.access$402(jsonReader, null);
                    JsonReader.access$002(jsonReader, JsonToken.STRING);
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected a name but was ");
                stringBuilder.append((Object)jsonReader.peek());
                stringBuilder.append(" ");
                stringBuilder.append(" at line ");
                stringBuilder.append(jsonReader.getLineNumber());
                stringBuilder.append(" column ");
                stringBuilder.append(jsonReader.getColumnNumber());
                throw new IllegalStateException(stringBuilder.toString());
            }
        };
    }

    public JsonReader(Reader reader) {
        this.buffer = new char[1024];
        this.stack = new JsonScope[32];
        this.push(JsonScope.EMPTY_DOCUMENT);
        this.skipping = false;
        Objects.requireNonNull(reader, "in == null");
        this.in = reader;
    }

    static /* synthetic */ JsonToken access$002(JsonReader jsonReader, JsonToken jsonToken) {
        jsonReader.token = jsonToken;
        return jsonToken;
    }

    static /* synthetic */ String access$302(JsonReader jsonReader, String string2) {
        jsonReader.value = string2;
        return string2;
    }

    static /* synthetic */ String access$402(JsonReader jsonReader, String string2) {
        jsonReader.name = string2;
        return string2;
    }

    private JsonToken advance() throws IOException {
        this.peek();
        JsonToken jsonToken = this.token;
        this.token = null;
        this.value = null;
        this.name = null;
        return jsonToken;
    }

    private void checkLenient() throws IOException {
        if (this.lenient) {
            return;
        }
        throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
    }

    private void consumeNonExecutePrefix() throws IOException {
        int n;
        this.nextNonWhitespace(true);
        this.pos = n = this.pos - 1;
        char[] cArray = NON_EXECUTE_PREFIX;
        if (n + cArray.length > this.limit && !this.fillBuffer(cArray.length)) {
            return;
        }
        for (n = 0; n < (cArray = NON_EXECUTE_PREFIX).length; ++n) {
            if (this.buffer[this.pos + n] == cArray[n]) continue;
            return;
        }
        this.pos += cArray.length;
    }

    private JsonToken decodeLiteral() throws IOException {
        char[] cArray;
        int n = this.valuePos;
        if (n == -1) {
            return JsonToken.STRING;
        }
        int n2 = this.valueLength;
        if (!(n2 != 4 || 'n' != (cArray = this.buffer)[n] && 'N' != cArray[n] || 'u' != cArray[n + 1] && 'U' != cArray[n + 1] || 'l' != cArray[n + 2] && 'L' != cArray[n + 2] || 'l' != cArray[n + 3] && 'L' != cArray[n + 3])) {
            this.value = "null";
            return JsonToken.NULL;
        }
        if (!(n2 != 4 || 't' != (cArray = this.buffer)[n] && 'T' != cArray[n] || 'r' != cArray[n + 1] && 'R' != cArray[n + 1] || 'u' != cArray[n + 2] && 'U' != cArray[n + 2] || 'e' != cArray[n + 3] && 'E' != cArray[n + 3])) {
            this.value = TRUE;
            return JsonToken.BOOLEAN;
        }
        if (!(n2 != 5 || 'f' != (cArray = this.buffer)[n] && 'F' != cArray[n] || 'a' != cArray[n + 1] && 'A' != cArray[n + 1] || 'l' != cArray[n + 2] && 'L' != cArray[n + 2] || 's' != cArray[n + 3] && 'S' != cArray[n + 3] || 'e' != cArray[n + 4] && 'E' != cArray[n + 4])) {
            this.value = FALSE;
            return JsonToken.BOOLEAN;
        }
        this.value = this.stringPool.get(this.buffer, n, n2);
        return this.decodeNumber(this.buffer, this.valuePos, this.valueLength);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonToken decodeNumber(char[] cArray, int n, int n2) {
        int n3;
        block12: {
            int n4;
            int n5;
            block14: {
                int n6;
                block13: {
                    block11: {
                        n3 = cArray[n];
                        if (n3 == 45) {
                            n5 = n + 1;
                            n3 = cArray[n5];
                        } else {
                            n5 = n;
                        }
                        if (n3 == 48) {
                            n4 = n5 + 1;
                            n3 = cArray[n4];
                        } else {
                            if (n3 < 49 || n3 > 57) return JsonToken.STRING;
                            n6 = cArray[++n5];
                            while (true) {
                                n3 = n6;
                                n4 = n5;
                                if (n6 < 48) break;
                                n3 = n6;
                                n4 = n5++;
                                if (n6 > 57) break;
                                n6 = cArray[n5];
                            }
                        }
                        n6 = n3;
                        n5 = n4;
                        if (n3 == 46) {
                            n3 = n4 + 1;
                            n4 = cArray[n3];
                            while (true) {
                                n6 = n4;
                                n5 = n3;
                                if (n4 < 48) break;
                                n6 = n4;
                                n5 = n3++;
                                if (n4 > 57) break;
                                n4 = cArray[n3];
                            }
                        }
                        if (n6 == 101) break block11;
                        n3 = n5;
                        if (n6 != 69) break block12;
                    }
                    if ((n4 = cArray[n6 = n5 + 1]) == 43) break block13;
                    n3 = n4;
                    n5 = n6;
                    if (n4 != 45) break block14;
                }
                n5 = n6 + 1;
                n3 = cArray[n5];
            }
            if (n3 < 48 || n3 > 57) return JsonToken.STRING;
            n4 = cArray[++n5];
            while (true) {
                n3 = n5;
                if (n4 < 48) break;
                n3 = n5++;
                if (n4 > 57) break;
                n4 = cArray[n5];
            }
        }
        if (n3 != n + n2) return JsonToken.STRING;
        return JsonToken.NUMBER;
    }

    private void expect(JsonToken jsonToken) throws IOException {
        this.peek();
        if (this.token == jsonToken) {
            this.advance();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected ");
        stringBuilder.append((Object)jsonToken);
        stringBuilder.append(" but was ");
        stringBuilder.append((Object)this.peek());
        stringBuilder.append(" at line ");
        stringBuilder.append(this.getLineNumber());
        stringBuilder.append(" column ");
        stringBuilder.append(this.getColumnNumber());
        throw new IllegalStateException(stringBuilder.toString());
    }

    private boolean fillBuffer(int n) throws IOException {
        block5: {
            int n2;
            char[] cArray = this.buffer;
            int n3 = this.bufferStartLine;
            int n4 = this.bufferStartColumn;
            int n5 = this.pos;
            for (n2 = 0; n2 < n5; ++n2) {
                if (cArray[n2] == '\n') {
                    ++n3;
                    n4 = 1;
                    continue;
                }
                ++n4;
            }
            this.bufferStartLine = n3;
            this.bufferStartColumn = n4;
            n2 = this.limit;
            n4 = this.pos;
            if (n2 != n4) {
                this.limit = n2 -= n4;
                System.arraycopy(cArray, n4, cArray, 0, n2);
            } else {
                this.limit = 0;
            }
            this.pos = 0;
            do {
                Reader reader = this.in;
                n4 = this.limit;
                if ((n4 = reader.read(cArray, n4, cArray.length - n4)) == -1) break block5;
                this.limit = n2 = this.limit + n4;
                if (this.bufferStartLine != 1 || (n4 = this.bufferStartColumn) != 1 || n2 <= 0 || cArray[0] != '\ufeff') continue;
                ++this.pos;
                this.bufferStartColumn = n4 - 1;
            } while (n2 < n);
            return true;
        }
        return false;
    }

    private int getColumnNumber() {
        int n = this.bufferStartColumn;
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] == '\n') {
                n = 1;
                continue;
            }
            ++n;
        }
        return n;
    }

    private int getLineNumber() {
        int n = this.bufferStartLine;
        for (int i = 0; i < this.pos; ++i) {
            int n2 = n;
            if (this.buffer[i] == '\n') {
                n2 = n + 1;
            }
            n = n2;
        }
        return n;
    }

    private JsonToken nextInArray(boolean bl) throws IOException {
        JsonToken jsonToken;
        int n;
        if (bl) {
            this.stack[this.stackSize - 1] = JsonScope.NONEMPTY_ARRAY;
        } else {
            n = this.nextNonWhitespace(true);
            if (n != 44) {
                if (n != 59) {
                    if (n == 93) {
                        JsonToken jsonToken2;
                        --this.stackSize;
                        this.token = jsonToken2 = JsonToken.END_ARRAY;
                        return jsonToken2;
                    }
                    throw this.syntaxError("Unterminated array");
                }
                this.checkLenient();
            }
        }
        n = this.nextNonWhitespace(true);
        if (n != 44 && n != 59) {
            if (n != 93) {
                --this.pos;
                return this.nextValue();
            }
            if (bl) {
                JsonToken jsonToken3;
                --this.stackSize;
                this.token = jsonToken3 = JsonToken.END_ARRAY;
                return jsonToken3;
            }
        }
        this.checkLenient();
        --this.pos;
        this.value = "null";
        this.token = jsonToken = JsonToken.NULL;
        return jsonToken;
    }

    /*
     * Unable to fully structure code
     */
    private JsonToken nextInObject(boolean var1_1) throws IOException {
        if (!var1_1) ** GOTO lbl8
        if (this.nextNonWhitespace(true) != 125) {
            --this.pos;
        } else {
            --this.stackSize;
            this.token = var2_2 = JsonToken.END_OBJECT;
            return var2_2;
lbl8:
            // 1 sources

            var3_5 = this.nextNonWhitespace(true);
            if (var3_5 != 44 && var3_5 != 59) {
                if (var3_5 == 125) {
                    --this.stackSize;
                    this.token = var2_3 = JsonToken.END_OBJECT;
                    return var2_3;
                }
                throw this.syntaxError("Unterminated object");
            }
        }
        var3_5 = this.nextNonWhitespace(true);
        if (var3_5 == 34) ** GOTO lbl26
        if (var3_5 != 39) {
            this.checkLenient();
            --this.pos;
            var2_4 = this.nextLiteral(false);
            this.name = var2_4;
            if (var2_4.length() == 0) {
                throw this.syntaxError("Expected name");
            }
        } else {
            this.checkLenient();
lbl26:
            // 2 sources

            this.name = this.nextString((char)var3_5);
        }
        this.stack[this.stackSize - 1] = JsonScope.DANGLING_NAME;
        var2_4 = JsonToken.NAME;
        this.token = var2_4;
        return var2_4;
    }

    /*
     * Unable to fully structure code
     */
    private String nextLiteral(boolean var1_1) throws IOException {
        block13: {
            this.valuePos = -1;
            var2_2 = 0;
            this.valueLength = 0;
            var3_3 = null;
            var4_4 = null;
            do {
                block14: {
                    var5_5 = 0;
                    block5: while (true) {
                        block15: {
                            if ((var6_6 = this.pos) + var5_5 >= this.limit) break block15;
                            if ((var6_6 = this.buffer[var6_6 + var5_5]) == 9 || var6_6 == 10 || var6_6 == 12 || var6_6 == 13 || var6_6 == 32) break block13;
                            if (var6_6 == 35) ** GOTO lbl-1000
                            if (var6_6 == 44) break block13;
                            if (var6_6 == 47 || var6_6 == 61) ** GOTO lbl-1000
                            if (var6_6 == 123 || var6_6 == 125 || var6_6 == 58) break block13;
                            if (var6_6 == 59) ** GOTO lbl-1000
                            switch (var6_6) {
                                default: {
                                    ++var5_5;
                                    continue block5;
                                }
                                case 92: lbl-1000:
                                // 4 sources

                                {
                                    this.checkLenient();
                                    break block13;
                                }
                                case 91: 
                                case 93: {
                                    break block13;
                                }
                            }
                        }
                        if (var5_5 >= this.buffer.length) break block14;
                        if (!this.fillBuffer(var5_5 + 1)) break;
                    }
                    this.buffer[this.limit] = (char)false;
                    break block13;
                }
                var7_7 = var4_4;
                if (var4_4 == null) {
                    var7_7 = new StringBuilder();
                }
                var7_7.append(this.buffer, this.pos, var5_5);
                this.valueLength += var5_5;
                this.pos += var5_5;
                var4_4 = var7_7;
            } while (this.fillBuffer(1));
            var4_4 = var7_7;
            var5_5 = var2_2;
        }
        if (var1_1 && var4_4 == null) {
            this.valuePos = this.pos;
            var4_4 = var3_3;
        } else if (this.skipping) {
            var4_4 = "skipped!";
        } else if (var4_4 == null) {
            var4_4 = this.stringPool.get(this.buffer, this.pos, var5_5);
        } else {
            var4_4.append(this.buffer, this.pos, var5_5);
            var4_4 = var4_4.toString();
        }
        this.valueLength += var5_5;
        this.pos += var5_5;
        return var4_4;
    }

    private int nextNonWhitespace(boolean bl) throws IOException {
        Object object = this.buffer;
        Object object2 = this.pos;
        int n = this.limit;
        while (true) {
            int n2 = object2;
            int n3 = n;
            if (object2 == n) {
                this.pos = object2;
                if (!this.fillBuffer(1)) {
                    if (!bl) {
                        return -1;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("End of input at line ");
                    ((StringBuilder)object).append(this.getLineNumber());
                    ((StringBuilder)object).append(" column ");
                    ((StringBuilder)object).append(this.getColumnNumber());
                    throw new EOFException(((StringBuilder)object).toString());
                }
                n2 = this.pos;
                n3 = this.limit;
            }
            object2 = n2 + 1;
            n = object[n2];
            if (n != 9 && n != 10 && n != 13 && n != 32) {
                if (n != 35) {
                    if (n != 47) {
                        this.pos = object2;
                        return n;
                    }
                    this.pos = object2;
                    if (object2 == n3) {
                        this.pos = object2 - 1;
                        boolean bl2 = this.fillBuffer(2);
                        ++this.pos;
                        if (!bl2) {
                            return n;
                        }
                    }
                    this.checkLenient();
                    n3 = this.pos;
                    object2 = object[n3];
                    if (object2 != 42) {
                        if (object2 != 47) {
                            return n;
                        }
                        this.pos = n3 + 1;
                        this.skipToEndOfLine();
                        object2 = this.pos;
                        n = this.limit;
                        continue;
                    }
                    this.pos = n3 + 1;
                    if (this.skipTo("*/")) {
                        object2 = this.pos + 2;
                        n = this.limit;
                        continue;
                    }
                    throw this.syntaxError("Unterminated comment");
                }
                this.pos = object2;
                this.checkLenient();
                this.skipToEndOfLine();
                object2 = this.pos;
                n = this.limit;
                continue;
            }
            n = n3;
        }
    }

    private String nextString(char c) throws IOException {
        char[] cArray = this.buffer;
        StringBuilder stringBuilder = null;
        while (true) {
            StringBuilder stringBuilder2;
            int n;
            int n2 = this.pos;
            int n3 = this.limit;
            block1: while (true) {
                int n4 = n2;
                while ((n = n4) < n3) {
                    n4 = n + 1;
                    if ((n = cArray[n]) == c) {
                        this.pos = n4;
                        if (this.skipping) {
                            return "skipped!";
                        }
                        if (stringBuilder == null) {
                            return this.stringPool.get(cArray, n2, n4 - n2 - 1);
                        }
                        stringBuilder.append(cArray, n2, n4 - n2 - 1);
                        return stringBuilder.toString();
                    }
                    if (n != 92) continue;
                    this.pos = n4;
                    stringBuilder2 = stringBuilder;
                    if (stringBuilder == null) {
                        stringBuilder2 = new StringBuilder();
                    }
                    stringBuilder2.append(cArray, n2, n4 - n2 - 1);
                    stringBuilder2.append(this.readEscapeCharacter());
                    n2 = this.pos;
                    n3 = this.limit;
                    stringBuilder = stringBuilder2;
                    continue block1;
                }
                break;
            }
            stringBuilder2 = stringBuilder;
            if (stringBuilder == null) {
                stringBuilder2 = new StringBuilder();
            }
            stringBuilder2.append(cArray, n2, n - n2);
            this.pos = n;
            if (!this.fillBuffer(1)) break;
            stringBuilder = stringBuilder2;
        }
        throw this.syntaxError("Unterminated string");
    }

    private JsonToken nextValue() throws IOException {
        JsonToken jsonToken;
        int n = this.nextNonWhitespace(true);
        if (n != 34) {
            if (n != 39) {
                JsonToken jsonToken2;
                if (n != 91) {
                    JsonToken jsonToken3;
                    if (n != 123) {
                        --this.pos;
                        return this.readLiteral();
                    }
                    this.push(JsonScope.EMPTY_OBJECT);
                    this.token = jsonToken3 = JsonToken.BEGIN_OBJECT;
                    return jsonToken3;
                }
                this.push(JsonScope.EMPTY_ARRAY);
                this.token = jsonToken2 = JsonToken.BEGIN_ARRAY;
                return jsonToken2;
            }
            this.checkLenient();
        }
        this.value = this.nextString((char)n);
        this.token = jsonToken = JsonToken.STRING;
        return jsonToken;
    }

    private JsonToken objectValue() throws IOException {
        int n = this.nextNonWhitespace(true);
        if (n != 58) {
            if (n == 61) {
                char[] cArray;
                this.checkLenient();
                if ((this.pos < this.limit || this.fillBuffer(1)) && (cArray = this.buffer)[n = this.pos] == '>') {
                    this.pos = n + 1;
                }
            } else {
                throw this.syntaxError("Expected ':'");
            }
        }
        this.stack[this.stackSize - 1] = JsonScope.NONEMPTY_OBJECT;
        return this.nextValue();
    }

    private void push(JsonScope jsonScope) {
        JsonScope[] jsonScopeArray;
        int n = this.stackSize;
        JsonScope[] jsonScopeArray2 = this.stack;
        if (n == jsonScopeArray2.length) {
            jsonScopeArray = new JsonScope[n * 2];
            System.arraycopy(jsonScopeArray2, 0, jsonScopeArray, 0, n);
            this.stack = jsonScopeArray;
        }
        jsonScopeArray = this.stack;
        n = this.stackSize;
        this.stackSize = n + 1;
        jsonScopeArray[n] = jsonScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    private char readEscapeCharacter() throws IOException {
        int n;
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        Object object = this.buffer;
        int n2 = this.pos;
        this.pos = n = n2 + 1;
        int n3 = object[n2];
        if (n3 == 98) {
            return '\b';
        }
        if (n3 == 102) {
            return '\f';
        }
        if (n3 == 110) {
            return '\n';
        }
        if (n3 == 114) {
            return '\r';
        }
        if (n3 == 116) {
            return '\t';
        }
        if (n3 != 117) {
            return (char)n3;
        }
        if (n + 4 > this.limit && !this.fillBuffer(4)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        int n4 = 0;
        n2 = n = this.pos;
        n3 = n4;
        while (true) {
            if ((n4 = n2) >= n + 4) {
                this.pos += 4;
                return (char)n3;
            }
            n2 = this.buffer[n4];
            char c = (char)(n3 << 4);
            if (n2 >= 48 && n2 <= 57) {
                n2 -= 48;
            } else {
                if (n2 >= 97 && n2 <= 102) {
                    n2 -= 97;
                } else {
                    if (n2 < 65 || n2 > 70) break;
                    n2 -= 65;
                }
                n2 += 10;
            }
            c = (char)(c + n2);
            n2 = n4 + 1;
            n3 = c;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("\\u");
        ((StringBuilder)object).append(this.stringPool.get(this.buffer, this.pos, 4));
        throw new NumberFormatException(((StringBuilder)object).toString());
    }

    private JsonToken readLiteral() throws IOException {
        this.value = this.nextLiteral(true);
        if (this.valueLength != 0) {
            JsonToken jsonToken;
            this.token = jsonToken = this.decodeLiteral();
            if (jsonToken == JsonToken.STRING) {
                this.checkLenient();
            }
            return this.token;
        }
        throw this.syntaxError("Expected literal value");
    }

    private boolean skipTo(String string2) throws IOException {
        block0: while (true) {
            int n;
            int n2 = ++this.pos;
            int n3 = string2.length();
            int n4 = this.limit;
            int n5 = n = 0;
            if (n2 + n3 > n4) {
                if (this.fillBuffer(string2.length())) {
                    n5 = n;
                } else {
                    return false;
                }
            }
            while (n5 < string2.length()) {
                if (this.buffer[this.pos + n5] != string2.charAt(n5)) continue block0;
                ++n5;
            }
            break;
        }
        return true;
    }

    private void skipToEndOfLine() throws IOException {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            char[] cArray = this.buffer;
            int n = this.pos;
            this.pos = n + 1;
            if ((n = cArray[n]) != 13 && n != 10) continue;
        }
    }

    private IOException syntaxError(String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" at line ");
        stringBuilder.append(this.getLineNumber());
        stringBuilder.append(" column ");
        stringBuilder.append(this.getColumnNumber());
        throw new MalformedJsonException(stringBuilder.toString());
    }

    public void beginArray() throws IOException {
        this.expect(JsonToken.BEGIN_ARRAY);
    }

    public void beginObject() throws IOException {
        this.expect(JsonToken.BEGIN_OBJECT);
    }

    @Override
    public void close() throws IOException {
        this.value = null;
        this.token = null;
        this.stack[0] = JsonScope.CLOSED;
        this.stackSize = 1;
        this.in.close();
    }

    public void endArray() throws IOException {
        this.expect(JsonToken.END_ARRAY);
    }

    public void endObject() throws IOException {
        this.expect(JsonToken.END_OBJECT);
    }

    public boolean hasNext() throws IOException {
        this.peek();
        boolean bl = this.token != JsonToken.END_OBJECT && this.token != JsonToken.END_ARRAY;
        return bl;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public boolean nextBoolean() throws IOException {
        this.peek();
        if (this.token == JsonToken.BOOLEAN) {
            boolean bl = this.value == TRUE;
            this.advance();
            return bl;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a boolean but was ");
        stringBuilder.append((Object)this.token);
        stringBuilder.append(" at line ");
        stringBuilder.append(this.getLineNumber());
        stringBuilder.append(" column ");
        stringBuilder.append(this.getColumnNumber());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public double nextDouble() throws IOException {
        this.peek();
        if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Expected a double but was ");
            stringBuilder.append((Object)this.token);
            stringBuilder.append(" at line ");
            stringBuilder.append(this.getLineNumber());
            stringBuilder.append(" column ");
            stringBuilder.append(this.getColumnNumber());
            throw new IllegalStateException(stringBuilder.toString());
        }
        double d = Double.parseDouble(this.value);
        if (d >= 1.0 && this.value.startsWith("0")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSON forbids octal prefixes: ");
            stringBuilder.append(this.value);
            stringBuilder.append(" at line ");
            stringBuilder.append(this.getLineNumber());
            stringBuilder.append(" column ");
            stringBuilder.append(this.getColumnNumber());
            throw new MalformedJsonException(stringBuilder.toString());
        }
        if (!this.lenient && (Double.isNaN(d) || Double.isInfinite(d))) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSON forbids NaN and infinities: ");
            stringBuilder.append(this.value);
            stringBuilder.append(" at line ");
            stringBuilder.append(this.getLineNumber());
            stringBuilder.append(" column ");
            stringBuilder.append(this.getColumnNumber());
            throw new MalformedJsonException(stringBuilder.toString());
        }
        this.advance();
        return d;
    }

    public int nextInt() throws IOException {
        block4: {
            int n;
            this.peek();
            if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected an int but was ");
                stringBuilder.append((Object)this.token);
                stringBuilder.append(" at line ");
                stringBuilder.append(this.getLineNumber());
                stringBuilder.append(" column ");
                stringBuilder.append(this.getColumnNumber());
                throw new IllegalStateException(stringBuilder.toString());
            }
            try {
                n = Integer.parseInt(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                double d = Double.parseDouble(this.value);
                n = (int)d;
                if ((double)n != d) break block4;
            }
            if ((long)n >= 1L && this.value.startsWith("0")) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("JSON forbids octal prefixes: ");
                stringBuilder.append(this.value);
                stringBuilder.append(" at line ");
                stringBuilder.append(this.getLineNumber());
                stringBuilder.append(" column ");
                stringBuilder.append(this.getColumnNumber());
                throw new MalformedJsonException(stringBuilder.toString());
            }
            this.advance();
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected an int but was ");
        stringBuilder.append(this.value);
        stringBuilder.append(" at line ");
        stringBuilder.append(this.getLineNumber());
        stringBuilder.append(" column ");
        stringBuilder.append(this.getColumnNumber());
        throw new NumberFormatException(stringBuilder.toString());
    }

    public long nextLong() throws IOException {
        block4: {
            long l;
            this.peek();
            if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected a long but was ");
                stringBuilder.append((Object)this.token);
                stringBuilder.append(" at line ");
                stringBuilder.append(this.getLineNumber());
                stringBuilder.append(" column ");
                stringBuilder.append(this.getColumnNumber());
                throw new IllegalStateException(stringBuilder.toString());
            }
            try {
                l = Long.parseLong(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                double d = Double.parseDouble(this.value);
                l = (long)d;
                if ((double)l != d) break block4;
            }
            if (l >= 1L && this.value.startsWith("0")) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("JSON forbids octal prefixes: ");
                stringBuilder.append(this.value);
                stringBuilder.append(" at line ");
                stringBuilder.append(this.getLineNumber());
                stringBuilder.append(" column ");
                stringBuilder.append(this.getColumnNumber());
                throw new MalformedJsonException(stringBuilder.toString());
            }
            this.advance();
            return l;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a long but was ");
        stringBuilder.append(this.value);
        stringBuilder.append(" at line ");
        stringBuilder.append(this.getLineNumber());
        stringBuilder.append(" column ");
        stringBuilder.append(this.getColumnNumber());
        throw new NumberFormatException(stringBuilder.toString());
    }

    public String nextName() throws IOException {
        this.peek();
        if (this.token == JsonToken.NAME) {
            String string2 = this.name;
            this.advance();
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a name but was ");
        stringBuilder.append((Object)this.peek());
        stringBuilder.append(" at line ");
        stringBuilder.append(this.getLineNumber());
        stringBuilder.append(" column ");
        stringBuilder.append(this.getColumnNumber());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void nextNull() throws IOException {
        this.peek();
        if (this.token == JsonToken.NULL) {
            this.advance();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected null but was ");
        stringBuilder.append((Object)this.token);
        stringBuilder.append(" at line ");
        stringBuilder.append(this.getLineNumber());
        stringBuilder.append(" column ");
        stringBuilder.append(this.getColumnNumber());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public String nextString() throws IOException {
        this.peek();
        if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Expected a string but was ");
            stringBuilder.append((Object)this.peek());
            stringBuilder.append(" at line ");
            stringBuilder.append(this.getLineNumber());
            stringBuilder.append(" column ");
            stringBuilder.append(this.getColumnNumber());
            throw new IllegalStateException(stringBuilder.toString());
        }
        String string2 = this.value;
        this.advance();
        return string2;
    }

    public JsonToken peek() throws IOException {
        Object object = this.token;
        if (object != null) {
            return object;
        }
        switch (2.$SwitchMap$com$google$gson$stream$JsonScope[this.stack[this.stackSize - 1].ordinal()]) {
            default: {
                throw new AssertionError();
            }
            case 8: {
                throw new IllegalStateException("JsonReader is closed");
            }
            case 7: {
                if (this.nextNonWhitespace(false) == -1) {
                    return JsonToken.END_DOCUMENT;
                }
                --this.pos;
                if (this.lenient) {
                    return this.nextValue();
                }
                throw this.syntaxError("Expected EOF");
            }
            case 6: {
                return this.nextInObject(false);
            }
            case 5: {
                return this.objectValue();
            }
            case 4: {
                return this.nextInObject(true);
            }
            case 3: {
                return this.nextInArray(false);
            }
            case 2: {
                return this.nextInArray(true);
            }
            case 1: 
        }
        if (this.lenient) {
            this.consumeNonExecutePrefix();
        }
        this.stack[this.stackSize - 1] = JsonScope.NONEMPTY_DOCUMENT;
        object = this.nextValue();
        if (!this.lenient && this.token != JsonToken.BEGIN_ARRAY && this.token != JsonToken.BEGIN_OBJECT) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Expected JSON document to start with '[' or '{' but was ");
            ((StringBuilder)object).append((Object)this.token);
            ((StringBuilder)object).append(" at line ");
            ((StringBuilder)object).append(this.getLineNumber());
            ((StringBuilder)object).append(" column ");
            ((StringBuilder)object).append(this.getColumnNumber());
            throw new IOException(((StringBuilder)object).toString());
        }
        return object;
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void skipValue() throws IOException {
        this.skipping = true;
        int n = 0;
        try {
            int n2;
            do {
                block7: {
                    block5: {
                        block6: {
                            JsonToken jsonToken;
                            if ((jsonToken = this.advance()) == JsonToken.BEGIN_ARRAY || jsonToken == JsonToken.BEGIN_OBJECT) break block5;
                            if (jsonToken == JsonToken.END_ARRAY) break block6;
                            JsonToken jsonToken2 = JsonToken.END_OBJECT;
                            n2 = n;
                            if (jsonToken != jsonToken2) break block7;
                        }
                        n2 = n - 1;
                        break block7;
                    }
                    n2 = n + 1;
                }
                n = n2;
            } while (n2 != 0);
            this.skipping = false;
            return;
        }
        catch (Throwable throwable) {
            this.skipping = false;
            throw throwable;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" at line ");
        stringBuilder.append(this.getLineNumber());
        stringBuilder.append(" column ");
        stringBuilder.append(this.getColumnNumber());
        return stringBuilder.toString();
    }
}

