/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson.stream;

import com.qb.gson.stream.JsonScope;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JsonWriter
implements Closeable {
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private static final String[] REPLACEMENT_CHARS;
    private String deferredName;
    private boolean htmlSafe;
    private String indent;
    private boolean lenient;
    private final Writer out;
    private String separator;
    private boolean serializeNulls;
    private final List<JsonScope> stack;

    static {
        REPLACEMENT_CHARS = new String[128];
        for (int i = 0; i <= 31; ++i) {
            JsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        String[] stringArray = REPLACEMENT_CHARS;
        stringArray[34] = "\\\"";
        stringArray[92] = "\\\\";
        stringArray[9] = "\\t";
        stringArray[8] = "\\b";
        stringArray[10] = "\\n";
        stringArray[13] = "\\r";
        stringArray[12] = "\\f";
        stringArray = (String[])stringArray.clone();
        HTML_SAFE_REPLACEMENT_CHARS = stringArray;
        stringArray[60] = "\\u003c";
        stringArray[62] = "\\u003e";
        stringArray[38] = "\\u0026";
        stringArray[61] = "\\u003d";
        stringArray[39] = "\\u0027";
    }

    public JsonWriter(Writer writer) {
        ArrayList<JsonScope> arrayList = new ArrayList<JsonScope>();
        this.stack = arrayList;
        arrayList.add(JsonScope.EMPTY_DOCUMENT);
        this.separator = ":";
        this.serializeNulls = true;
        Objects.requireNonNull(writer, "out == null");
        this.out = writer;
    }

    private void beforeName() throws IOException {
        Object object;
        block4: {
            block3: {
                block2: {
                    object = this.peek();
                    if (object != JsonScope.NONEMPTY_OBJECT) break block2;
                    this.out.write(44);
                    break block3;
                }
                if (object != JsonScope.EMPTY_OBJECT) break block4;
            }
            this.newline();
            this.replaceTop(JsonScope.DANGLING_NAME);
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Nesting problem: ");
        ((StringBuilder)object).append(this.stack);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void beforeValue(boolean bl) throws IOException {
        int n = 1.$SwitchMap$com$google$gson$stream$JsonScope[this.peek().ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    this.replaceTop(JsonScope.NONEMPTY_ARRAY);
                    this.newline();
                    return;
                }
                if (n == 4) {
                    this.out.append(',');
                    this.newline();
                    return;
                }
                if (n == 5) {
                    this.out.append(this.separator);
                    this.replaceTop(JsonScope.NONEMPTY_OBJECT);
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Nesting problem: ");
                stringBuilder.append(this.stack);
                throw new IllegalStateException(stringBuilder.toString());
            }
        } else if (!this.lenient) throw new IllegalStateException("JSON must have only one top-level value.");
        if (!this.lenient) {
            if (!bl) throw new IllegalStateException("JSON must start with an array or an object.");
        }
        this.replaceTop(JsonScope.NONEMPTY_DOCUMENT);
    }

    private JsonWriter close(JsonScope object, JsonScope jsonScope, String string2) throws IOException {
        JsonScope jsonScope2 = this.peek();
        if (jsonScope2 != jsonScope && jsonScope2 != object) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Nesting problem: ");
            ((StringBuilder)object).append(this.stack);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        if (this.deferredName == null) {
            object = this.stack;
            object.remove(object.size() - 1);
            if (jsonScope2 == jsonScope) {
                this.newline();
            }
            this.out.write(string2);
            return this;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Dangling name: ");
        ((StringBuilder)object).append(this.deferredName);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    private void newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.out.write("\n");
        for (int i = 1; i < this.stack.size(); ++i) {
            this.out.write(this.indent);
        }
    }

    private JsonWriter open(JsonScope jsonScope, String string2) throws IOException {
        this.beforeValue(true);
        this.stack.add(jsonScope);
        this.out.write(string2);
        return this;
    }

    private JsonScope peek() {
        int n = this.stack.size();
        if (n != 0) {
            return this.stack.get(n - 1);
        }
        throw new IllegalStateException("JsonWriter is closed.");
    }

    private void replaceTop(JsonScope jsonScope) {
        List<JsonScope> list = this.stack;
        list.set(list.size() - 1, jsonScope);
    }

    private void string(String string2) throws IOException {
        String[] stringArray = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write("\"");
        int n = string2.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            block8: {
                String string3;
                block7: {
                    char c;
                    block9: {
                        block6: {
                            String string4;
                            c = string2.charAt(i);
                            if (c >= '\u0080') break block6;
                            string3 = string4 = stringArray[c];
                            if (string4 != null) break block7;
                            n3 = n2;
                            break block8;
                        }
                        if (c != '\u2028') break block9;
                        string3 = "\\u2028";
                        break block7;
                    }
                    n3 = n2;
                    if (c != '\u2029') break block8;
                    string3 = "\\u2029";
                }
                if (n2 < i) {
                    this.out.write(string2, n2, i - n2);
                }
                this.out.write(string3);
                n3 = i + 1;
            }
            n2 = n3;
        }
        if (n2 < n) {
            this.out.write(string2, n2, n - n2);
        }
        this.out.write("\"");
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            this.string(this.deferredName);
            this.deferredName = null;
        }
    }

    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(JsonScope.EMPTY_ARRAY, "[");
    }

    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(JsonScope.EMPTY_OBJECT, "{");
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        int n = this.stack.size();
        if (n <= 1 && (n != 1 || this.stack.get(n - 1) == JsonScope.NONEMPTY_DOCUMENT)) {
            this.stack.clear();
            return;
        }
        throw new IOException("Incomplete document");
    }

    public JsonWriter endArray() throws IOException {
        return this.close(JsonScope.EMPTY_ARRAY, JsonScope.NONEMPTY_ARRAY, "]");
    }

    public JsonWriter endObject() throws IOException {
        return this.close(JsonScope.EMPTY_OBJECT, JsonScope.NONEMPTY_OBJECT, "}");
    }

    public void flush() throws IOException {
        if (!this.stack.isEmpty()) {
            this.out.flush();
            return;
        }
        throw new IllegalStateException("JsonWriter is closed.");
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public JsonWriter name(String string2) throws IOException {
        Objects.requireNonNull(string2, "name == null");
        if (this.deferredName == null) {
            if (!this.stack.isEmpty()) {
                this.deferredName = string2;
                return this;
            }
            throw new IllegalStateException("JsonWriter is closed.");
        }
        throw new IllegalStateException();
    }

    public JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue(false);
        this.out.write("null");
        return this;
    }

    public final void setHtmlSafe(boolean bl) {
        this.htmlSafe = bl;
    }

    public final void setIndent(String string2) {
        if (string2.length() == 0) {
            this.indent = null;
            this.separator = ":";
        } else {
            this.indent = string2;
            this.separator = ": ";
        }
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public final void setSerializeNulls(boolean bl) {
        this.serializeNulls = bl;
    }

    public JsonWriter value(double d) throws IOException {
        if (!Double.isNaN(d) && !Double.isInfinite(d)) {
            this.writeDeferredName();
            this.beforeValue(false);
            this.out.append(Double.toString(d));
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Numeric values must be finite, but was ");
        stringBuilder.append(d);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public JsonWriter value(long l) throws IOException {
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.write(Long.toString(l));
        return this;
    }

    public JsonWriter value(Number number) throws IOException {
        if (number == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        CharSequence charSequence = number.toString();
        if (!this.lenient && (((String)charSequence).equals("-Infinity") || ((String)charSequence).equals("Infinity") || ((String)charSequence).equals("NaN"))) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Numeric values must be finite, but was ");
            ((StringBuilder)charSequence).append(number);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }
        this.beforeValue(false);
        this.out.append(charSequence);
        return this;
    }

    public JsonWriter value(String string2) throws IOException {
        if (string2 == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue(false);
        this.string(string2);
        return this;
    }

    public JsonWriter value(boolean bl) throws IOException {
        this.writeDeferredName();
        this.beforeValue(false);
        Writer writer = this.out;
        String string2 = bl ? "true" : "false";
        writer.write(string2);
        return this;
    }
}

