/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.auth.query;

import com.quickblox.auth.model.QBProvider;
import com.quickblox.auth.model.QBSession;
import com.quickblox.auth.model.QBSessionWrap;
import com.quickblox.auth.parsers.QBSessionJsonParser;
import com.quickblox.auth.result.QBSessionResult;
import com.quickblox.core.QBSettings;
import com.quickblox.core.RestMethod;
import com.quickblox.core.exception.BaseServiceException;
import com.quickblox.core.helper.SignHelper;
import com.quickblox.core.query.JsonQuery;
import com.quickblox.core.rest.RestRequest;
import com.quickblox.users.model.QBUser;
import java.lang.reflect.Type;
import java.security.SignatureException;
import java.util.Map;
import java.util.Random;

public class QueryCreateSession
extends JsonQuery<QBSession> {
    String accessToken;
    String accessTokenSecret;
    String provider;
    private QBUser user;

    public QueryCreateSession() {
        QBSessionJsonParser qBSessionJsonParser = new QBSessionJsonParser(this);
        qBSessionJsonParser.setDeserializer((Type)((Object)QBSessionWrap.class));
        this.setParser(qBSessionJsonParser);
    }

    public QueryCreateSession(QBUser qBUser) {
        this();
        this.user = qBUser;
    }

    public QueryCreateSession(String string2, String string3, String string4) {
        this();
        this.provider = string2;
        this.accessToken = string3;
        this.accessTokenSecret = string4;
    }

    private void signRequest(RestRequest object) {
        String string2 = ((RestRequest)object).getParamsOnlyStringNotEncoded();
        String string3 = QBSettings.getInstance().getAuthorizationSecret();
        if (string3 != null) {
            try {
                string3 = SignHelper.calculateHMAC_SHA(string2, string3);
                ((RestRequest)object).getParameters().put("signature", string3);
            }
            catch (SignatureException signatureException) {
                signatureException.printStackTrace();
            }
        } else {
            try {
                object = new BaseServiceException("\nYou have missed the AUTHORIZATION SECRET parameter for QBSettings.\nPlease set parameter using following code:\n    QBSettings.getInstance().setAuthorizationSecret(\"###############\");\nYou can find desired value on your app settings page in QB Admin Panel (http://admin.quickblox.com/apps/<app_id>/edit).");
                throw object;
            }
            catch (BaseServiceException baseServiceException) {
                baseServiceException.printStackTrace();
            }
        }
    }

    @Override
    public Class getResultClass() {
        return QBSessionResult.class;
    }

    @Override
    public String getUrl() {
        return this.buildQueryUrl("session");
    }

    public QBUser getUser() {
        return this.user;
    }

    @Override
    protected void setMethod(RestRequest restRequest) {
        restRequest.setMethod(RestMethod.POST);
    }

    @Override
    protected void setParams(RestRequest object) {
        object = ((RestRequest)object).getParameters();
        Object object2 = QBSettings.getInstance().getApplicationId();
        Object object3 = QBSettings.getInstance().getAuthorizationKey();
        int n = new Random().nextInt();
        long l = System.currentTimeMillis() / 1000L;
        if (object2 != null) {
            this.putValue((Map<String, Object>)object, "application_id", object2);
        } else {
            try {
                object2 = new BaseServiceException("\nYou have missed the APPLICATION ID parameter for QBSettings.\nPlease set parameter using following code:\n    QBSettings.getInstance().setApplicationId(\"123\");\nYou can find desired value on your app settings page in QB Admin Panel (http://admin.quickblox.com/apps/<app_id>/edit).");
                throw object2;
            }
            catch (BaseServiceException baseServiceException) {
                baseServiceException.printStackTrace();
            }
        }
        if (object3 != null) {
            this.putValue((Map<String, Object>)object, "auth_key", object3);
        } else {
            try {
                object3 = new BaseServiceException("\nYou have missed the AUTHORIZATION KEY parameter for QBSettings.\nPlease set parameter using following code:\n    QBSettings.getInstance().setAuthorizationKey(\"###############\");\nYou can find desired value on your app settings page in QB Admin Panel (http://admin.quickblox.com/apps/<app_id>/edit).");
                throw object3;
            }
            catch (BaseServiceException baseServiceException) {
                baseServiceException.printStackTrace();
            }
        }
        object3 = this.provider;
        if (object3 != null) {
            if (((String)object3).equals(QBProvider.TWITTER)) {
                this.putValue((Map<String, Object>)object, "keys[secret]", this.accessTokenSecret);
            }
            this.putValue((Map<String, Object>)object, "keys[token]", this.accessToken);
        }
        this.putValue((Map<String, Object>)object, "nonce", n);
        object3 = this.provider;
        if (object3 != null) {
            this.putValue((Map<String, Object>)object, "provider", object3);
        }
        this.putValue((Map<String, Object>)object, "timestamp", l);
        object3 = this.user;
        if (object3 != null) {
            this.putValue((Map<String, Object>)object, "user[login]", ((QBUser)object3).getLogin());
            this.putValue((Map<String, Object>)object, "user[email]", this.user.getEmail());
            this.putValue((Map<String, Object>)object, "user[password]", this.user.getPassword());
        }
    }

    public void setUser(QBUser qBUser) {
        this.user = qBUser;
    }

    @Override
    protected void setupRequest(RestRequest restRequest) {
        super.setupRequest(restRequest);
        this.signRequest(restRequest);
    }
}

