/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.auth.query;

import com.quickblox.auth.model.QBProvider;
import com.quickblox.core.QBSettings;
import com.quickblox.core.RestMethod;
import com.quickblox.core.exception.BaseServiceException;
import com.quickblox.core.helper.SignHelper;
import com.quickblox.core.query.JsonQuery;
import com.quickblox.core.rest.RestRequest;
import com.quickblox.core.result.Result;
import java.security.SignatureException;
import java.util.Map;
import java.util.Random;

public class QueryCreateSessionUsingSocialProvider
extends JsonQuery {
    String provider;
    String scope = "friends_status";

    public QueryCreateSessionUsingSocialProvider(String string2, String[] stringArray) {
        this.provider = string2;
    }

    private void signRequest(RestRequest object) {
        String string2 = ((RestRequest)object).getParamsOnlyStringNotEncoded();
        String string3 = QBSettings.getInstance().getAuthorizationSecret();
        if (string3 != null) {
            try {
                string2 = SignHelper.calculateHMAC_SHA(string2, string3);
                ((RestRequest)object).getParameters().put("signature", string2);
            }
            catch (SignatureException signatureException) {
                signatureException.printStackTrace();
            }
        } else {
            try {
                object = new BaseServiceException("\nYou have missed the AUTHORIZATION SECRET parameter for QBSettings.\nPlease set parameter using following code:\n    QBSettings.getInstance().setAuthorizationSecret(\"###############\");\nYou can find desired value on your app settings page in QB Admin Panel (http://admin.quickblox.com/apps/<app_id>/edit).");
                throw object;
            }
            catch (BaseServiceException baseServiceException) {
                baseServiceException.printStackTrace();
            }
        }
    }

    @Override
    public Class getResultClass() {
        return Result.class;
    }

    @Override
    public String getUrl() {
        return this.buildQueryUrl("session");
    }

    @Override
    protected void setMethod(RestRequest restRequest) {
        restRequest.setMethod(RestMethod.POST);
    }

    @Override
    protected void setParams(RestRequest object) {
        object = ((RestRequest)object).getParameters();
        Object object2 = QBSettings.getInstance().getApplicationId();
        Object object3 = QBSettings.getInstance().getAuthorizationKey();
        int n = new Random().nextInt();
        long l = System.currentTimeMillis() / 1000L;
        if (object2 != null) {
            this.putValue((Map<String, Object>)object, "application_id", object2);
        } else {
            try {
                object2 = new BaseServiceException("\nYou have missed the APPLICATION ID parameter for QBSettings.\nPlease set parameter using following code:\n    QBSettings.getInstance().setApplicationId(\"123\");\nYou can find desired value on your app settings page in QB Admin Panel (http://admin.quickblox.com/apps/<app_id>/edit).");
                throw object2;
            }
            catch (BaseServiceException baseServiceException) {
                baseServiceException.printStackTrace();
            }
        }
        if (object3 != null) {
            this.putValue((Map<String, Object>)object, "auth_key", object3);
        } else {
            try {
                object3 = new BaseServiceException("\nYou have missed the AUTHORIZATION KEY parameter for QBSettings.\nPlease set parameter using following code:\n    QBSettings.getInstance().setAuthorizationKey(\"###############\");\nYou can find desired value on your app settings page in QB Admin Panel (http://admin.quickblox.com/apps/<app_id>/edit).");
                throw object3;
            }
            catch (BaseServiceException baseServiceException) {
                baseServiceException.printStackTrace();
            }
        }
        this.putValue((Map<String, Object>)object, "nonce", n);
        object3 = this.provider;
        if (object3 != null) {
            this.putValue((Map<String, Object>)object, "provider", object3);
            if (this.provider.equals(QBProvider.FACEBOOK)) {
                this.putValue((Map<String, Object>)object, "scope", this.scope);
            }
        }
        this.putValue((Map<String, Object>)object, "timestamp", l);
    }

    @Override
    protected void setupRequest(RestRequest restRequest) {
        super.setupRequest(restRequest);
        this.signRequest(restRequest);
    }
}

