/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.parser;

import com.qb.gson.Gson;
import com.quickblox.core.error.QBErrorPlain;
import com.quickblox.core.error.QBErrorWithArray;
import com.quickblox.core.error.QBErrorWithBase;
import com.quickblox.core.error.QBErrorWithCode;
import com.quickblox.core.error.QBErrorWithError;
import com.quickblox.core.error.QBIError;
import com.quickblox.core.interfaces.QBErrorParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QBJsonErrorParser
implements QBErrorParser {
    private static Map<String, Class<? extends QBIError>> errorHandlers;
    private List<String> errors;

    static {
        HashMap<String, Class<? extends QBIError>> hashMap = new HashMap<String, Class<? extends QBIError>>();
        errorHandlers = hashMap;
        hashMap.put("error", QBErrorWithError.class);
        errorHandlers.put("errors", QBErrorWithArray.class);
        errorHandlers.put("code", QBErrorWithCode.class);
        errorHandlers.put("base", QBErrorWithBase.class);
        errorHandlers.put("onError", QBErrorPlain.class);
    }

    public QBJsonErrorParser(List<String> list) {
        this.errors = list;
    }

    public void addErrorSerializer(String string2, Class<? extends QBIError> clazz) {
        errorHandlers.put(string2, clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean parseError(String string22) {
        try {
            JSONObject jSONObject = new JSONObject(string22);
            Object object = errorHandlers.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<String, Class<? extends QBIError>> entry = object.next();
                if (!jSONObject.has(entry.getKey())) continue;
                if (this.preCheckParseErrors(entry.getKey(), jSONObject)) break;
                object = new Gson();
                for (String string22 : ((Gson)object).fromJson(string22, entry.getValue()).getErrors()) {
                    this.errors.add(0, string22);
                }
            }
            return this.errors.isEmpty() ^ true;
        }
        catch (JSONException jSONException) {
            return this.errors.isEmpty() ^ true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean preCheckParseErrors(String string2, JSONObject object) {
        if (!"errors".equals(string2)) return false;
        try {
            JSONObject jSONObject = object.optJSONObject(string2);
            if (jSONObject == null) return false;
            if (jSONObject.length() <= 0) return false;
            JSONArray jSONArray = jSONObject.names();
            int n = 0;
            while (n < jSONArray.length()) {
                String string3 = jSONArray.get(n).toString();
                JSONArray jSONArray2 = jSONObject.getJSONArray(string3);
                for (int i = 0; i < jSONArray2.length(); ++i) {
                    string2 = jSONArray2.getString(i);
                    object = this.errors;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string3);
                    stringBuilder.append(" ");
                    stringBuilder.append(string2);
                    object.add(0, stringBuilder.toString());
                }
                ++n;
            }
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }
}

