/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.query;

import com.quickblox.core.parser.QBLimitedJsonParser;
import com.quickblox.core.query.JsonQuery;
import com.quickblox.core.request.GenericQueryRule;
import com.quickblox.core.request.QBLimitedRequestBuilder;
import com.quickblox.core.request.QBRequestGetBuilder;
import com.quickblox.core.request.QueryRule;
import com.quickblox.core.rest.RestRequest;
import com.quickblox.core.result.PagedResult;
import java.util.Map;

public class LimitedQuery<T>
extends JsonQuery<T> {
    private Integer pagesLimit;
    private Integer pagesSkip;
    protected QBRequestGetBuilder requestBuilder;

    public LimitedQuery() {
        this.setParser(new QBLimitedJsonParser(this));
    }

    public Integer getPagesLimit() {
        return this.pagesLimit;
    }

    public Integer getPagesSkip() {
        return this.pagesSkip;
    }

    public QBRequestGetBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    @Override
    public Class getResultClass() {
        return PagedResult.class;
    }

    public void setPagesLimit(Integer n) {
        this.pagesLimit = n;
    }

    public void setPagesSkip(Integer n) {
        this.pagesSkip = n;
    }

    @Override
    protected void setParams(RestRequest restRequest) {
        Map<String, Object> map = restRequest.getParameters();
        Object object = this.requestBuilder;
        if (object != null) {
            if (((QBLimitedRequestBuilder)object).getPagesSkip() != 0) {
                this.setPagesSkip(this.requestBuilder.getPagesSkip());
            }
            if (this.requestBuilder.getPagesLimit() != 0) {
                this.setPagesLimit(this.requestBuilder.getPagesLimit());
            }
            object = this.requestBuilder.getRules().iterator();
            while (object.hasNext()) {
                QueryRule queryRule = (QueryRule)((GenericQueryRule)object.next());
                map.put(queryRule.getRuleAsRequestParamGetQuery(), queryRule.getRuleAsRequestValue());
            }
        }
        this.putValue(map, "skip", this.pagesSkip);
        this.putValue(map, "limit", this.pagesLimit);
        super.setParams(restRequest);
    }

    public void setRequestBuilder(QBRequestGetBuilder qBRequestGetBuilder) {
        this.requestBuilder = qBRequestGetBuilder;
    }
}

